from Products.Five import zcml
from Products.Five import fiveconfigure

from Testing import ZopeTestCase as ztc

from Products.PloneTestCase import PloneTestCase as ptc
from Products.PloneTestCase.layer import onsetup


################################################################################
"""


Lot of files generated by the collective.generic packages  will try to load user defined objects in user specific files.
The final goal is to regenerate easyly the test infrastructure on templates updates without impacting
user-specific test boilerplate.
We do not use paster local commands (insert/update) as it cannot determine witch is specific or not and we prefer to totally
separe generated stuff and what is user specific



If you need to edit something in this file, you must have better to do it in:


    - user_base.py


Objects that you can edit and get things overidden are:


    - user_base.py

        * method: setup__Products_csvreplicata()

            method to setup the plone site

        * class: _Products_csvreplicata_TestCase

            Base plone test case like PloneTestCase

        * class: _Products_csvreplicata_FunctionalTestCase:

            Functionnal TestBase barely based on the previous TestCase.



Think to put "FAILS_ON_UNTESTED_ELEMENT" to True in testing.cfg for production mode or to test very strictly your code!
This will issue errors for untested elements instead of just simple warnings !


"""
################################################################################


TESTED_PRODUCTS = (\
#with_ploneproduct_csvreplica
    'csvreplicata',
)
for product in TESTED_PRODUCTS:
    ztc.installProduct(product)

@onsetup
def setup_csvreplicataPloneSite():
    """Set up the additional products required for the Products) site csvreplicata.

    The @onsetup decorator causes the execution of this body to be deferred
    until the setup of the Plone site testing layer.
    """
    # ------------------------------------------------------------------------------------
    # Get five errors if any for making debug easy.
    # ------------------------------------------------------------------------------------
    fiveconfigure.debug_mode = True

    # ------------------------------------------------------------------------------------
    # Import all our python modules required by our packages
    # ------------------------------------------------------------------------------------

    # ------------------------------------------------------------------------------------
    # - Load the ZCML configuration for the Products.csvreplicata package.
    # ------------------------------------------------------------------------------------



    # ------------------------------------------------------------------------------------
    # - Load the python packages that are registered as Zope2 Products via Five
    #   which can't happen until we have loaded the package ZCML.
    # ------------------------------------------------------------------------------------


    # ------------------------------------------------------------------------------------
    # Load our own csvreplicata
    # ------------------------------------------------------------------------------------
    import Products.csvreplicata
    zcml.load_config('configure.zcml', Products.csvreplicata)

    # ------------------------------------------------------------------------------------
    # Reset five debug mode as we do not use it anymore
    # ------------------------------------------------------------------------------------
    fiveconfigure.debug_mode = False


class TestCase(ptc.PloneTestCase):
    """We use this base class for all the tests in this package. If necessary,
    we can put common utility or setup code in here.
    """

class FunctionalTestCase(TestCase):
    """Functionnal base TestCase."""

# try to load user code
try: from Products.csvreplicata.tests.user_base import setup_csvreplicataPloneSite
except: pass

try:from Products.csvreplicata.tests.user_base import TestCase
except: pass

try:from Products.csvreplicata.tests.user_base import FunctionalTestCase
except: pass

# The order here is important: We first call the (deferred) function which
# installs the products we need for the Products package. Then, we let
# PloneTestCase set up this product on installation.
def setup_site():
    setup_csvreplicataPloneSite()
    ptc.setupPloneSite(products=[\
    # if we have csvreplicata, just say that a plone site can't live without it.
        'csvreplicata',]
    )
# vim:set ft=python:
