import unittest
import os
import csv

import anuga.lib.order_boundary as ob


class Test_order_boundary(unittest.TestCase):
    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_simple(self):

        # filenames
        Test_input_file_path = 'test.in.csv'
        Test_output_file_path = 'test.out.csv'

        # input data
        Data = [('longitude','latitude','index'),
                ( 1.0,  1.0, 'alpha', 'extra'),
                ( 2.3,  2.0, 'bravo'),
                ( 3.9,  3.0, 'charlie'),
                ( 9.0,  9.9, 'delta'),
                (10.0, 10.4, 'echo'),
                (11.0, 11.0, 'foxtrot'),
                (15.9, 16.0, 'golf'),
                (17.0, 17.1, 'hotel'),
                (17.9, 18.0, 'india'),
                (12.2, 12.0, 'juliet'),
                ( 4.7,  4.0, 'kilo'),
                ( 5.2,  5.0, 'lima'),
                ( 6.0,  6.0, 'mike'),
                ( 7.0,  7.3, 'november', 'extra', 'extra', 'extra'),
                ( 8.0,  8.7, 'oscar'),
                (13.6, 13.0, 'papa'),
                (14.9, 14.0, 'quebec'),
                (15.8, 15.0, 'romeo'),
                (16.0, 16.2, 'sierra'),
                (17.1, 17.1, 'tango'),
                (18.0, 18.7, 'uniform'),
                (19.0, 19.9, 'victor'),
                (20.0, 20.0, 'whisky')]

        # expected output data
        Expected = [('longitude','latitude','index'),
                    ( 1.0,  1.0, 'alpha', 'extra'),
                    ( 2.3,  2.0, 'bravo'),
                    ( 3.9,  3.0, 'charlie'),
                    ( 4.7,  4.0, 'kilo'),
                    ( 5.2,  5.0, 'lima'),
                    ( 6.0,  6.0, 'mike'),
                    ( 7.0,  7.3, 'november', 'extra', 'extra', 'extra'),
                    ( 8.0,  8.7, 'oscar'),
                    ( 9.0,  9.9, 'delta'),
                    (10.0, 10.4, 'echo'),
                    (11.0, 11.0, 'foxtrot'),
                    (12.2, 12.0, 'juliet'),
                    (13.6, 13.0, 'papa'),
                    (14.9, 14.0, 'quebec'),
                    (15.8, 15.0, 'romeo'),
                    (15.9, 16.0, 'golf'),
                    (16.0, 16.2, 'sierra'),
                    (17.0, 17.1, 'hotel'),
                    (17.1, 17.1, 'tango'),
                    (17.9, 18.0, 'india'),
                    (18.0, 18.7, 'uniform'),
                    (19.0, 19.9, 'victor'),
                    (20.0, 20.0, 'whisky')]

        # put test data into a file
        fd = open(Test_input_file_path, 'wb')
        w = csv.writer(fd)
        for d in Data:
            w.writerow(d)
        fd.close()

        # call routine, put sorted points into output file
        ob.order_boundary(Test_input_file_path, Test_output_file_path)

        # get sorted data into memory
        fd = open(Test_output_file_path, 'r')
        data_list = []
        for data in csv.reader(fd):
            try:
                data[0] = float(data[0])
            except:
                pass
            try:
                data[1] = float(data[1])
            except:
                pass
            data_list.append(tuple(data))
        fd.close()

        # check same as Expected
        self.assertTrue(data_list == Expected)

        # clean up
        try:
            os.remove(Test_input_file_path)
        except:
            pass
        try:
            os.remove(Test_output_file_path)
        except:
            pass

    # Not a correctness test, as the result was generated by the routine.
    # Still good as a regression test - Johnno told me the output was good.
    def test_regression(self):

        infile = 'test.in.csv'
        outfile = 'test.out.csv'

        data = [('longitude','latitude','index'),
                (150.0833,-37.5,2758),
                (150.1,-37.4667,2765),
                (150.1167,-37.3833,2769),
                (150.1333,-36.7167,2771),
                (150.1333,-36.7667,2774),
                (150.15,-36.5833,2777),
                (150.15,-36.6333,2780),
                (150.15,-36.6833,2783),
                (150.15,-36.8167,2787),
                (150.15,-36.8667,2790),
                (150.15,-36.9167,2793),
                (150.15,-37.35,2795),
                (150.1667,-36.5,2796),
                (150.1667,-36.55,2799),
                (150.1667,-36.9667,2804),
                (150.1667,-37.0167,2807),
                (150.1667,-37.25,2808),
                (150.1667,-37.3,2811),
                (150.1833,-36.45,2815),
                (150.1833,-37.05,2821),
                (150.1833,-37.1,2824),
                (150.1833,-37.2167,2827),
                (150.2,-36.4,2831),
                (150.2,-37.1333,2835),
                (150.2,-37.1667,2837),
                (150.2,-37.2,2839),
                (150.2167,-36.3667,2841),
                (150.2333,-36.0667,2844),
                (150.2333,-36.1167,2847),
                (150.25,-36.0167,2852),
                (150.25,-36.1667,2856),
                (150.25,-36.2167,2859),
                (150.25,-36.3333,2862),
                (150.2667,-36.25,2865),
                (150.2667,-36.3,2868),
                (150.3,-35.8833,2870),
                (150.35,-35.75,2872),
                (150.4333,-35.6333,2873),
                (150.5,-35.5,2875),
                (150.5667,-35.4,2878),
                (150.6,-35.3667,2882),
                (150.6333,-35.3333,2889),
                (150.6667,-35.3,2893),
                (150.7,-35.2667,2898),
                (150.75,-35.2333,2903),
                (150.8,-35.1833,2907),
                (150.8333,-35.1333,2913),
                (150.8667,-35.1,2918),
                (150.9,-35.0667,2923),
                (150.9333,-35.0167,2927),
                (150.95,-34.9833,2938),
                (150.9667,-34.6333,2940),
                (150.9667,-34.6667,2942),
                (150.9667,-34.7,2944),
                (150.9667,-34.75,2947),
                (150.9667,-34.8,2948),
                (150.9667,-34.85,2951),
                (150.9667,-34.9,2953),
                (150.9667,-34.95,2956),
                (150.9833,-34.5833,2958),
                (151,-34.55,2962),
                (151.0167,-34.5167,2965),
                (151.0333,-34.5,2968),
                (151.05,-34.4667,2971),
                (151.0667,-34.4333,2974),
                (151.0833,-34.4,2977),
                (151.1,-34.35,2980),
                (151.1167,-34.3167,2984),
                (151.1333,-34.2833,2988),
                (151.15,-34.2333,2991),
                (151.1667,-34.1833,2995),
                (151.2,-34.15,3002),
                (151.2333,-34.1167,3008),
                (151.2667,-34.0833,3012),
                (151.3,-34.05,3016),
                (151.3333,-34.0167,3021),
                (151.3667,-33.9833,3023),
                (151.3833,-33.95,3027),
                (151.4,-33.85,3031),
                (151.4,-33.9,3034),
                (151.4167,-33.8,3037),
                (151.4333,-33.75,3041),
                (151.45,-33.7167,3046),
                (151.4833,-33.6833,3051),
                (151.5167,-33.65,3054),
                (151.55,-33.6167,3058),
                (151.5667,-33.5833,3060),
                (151.5833,-33.55,3063),
                (151.6167,-33.5167,3070),
                (151.65,-33.4833,3074),
                (151.6833,-33.45,3077),
                (151.7333,-33.35,3084),
                (151.7333,-33.4,3087),
                (151.75,-33.3167,3089),
                (151.7667,-33.2667,3091),
                (151.7833,-33.2,3095),
                (151.8,-33.1667,3099),
                (151.8333,-33.1,3109),
                (151.8667,-33.0667,3116),
                (151.9,-33.0333,3120),
                (151.9333,-33,3125),
                (151.9833,-32.9667,3130),
                (152.0333,-32.9333,3137),
                (152.1,-32.9,3145),
                (152.15,-32.8667,3151),
                (152.2,-32.8333,3158),
                (152.25,-32.8,3164),
                (152.2833,-32.7667,3168),
                (152.3333,-32.7167,3177),
                (152.3667,-32.7,3181),
                (152.4,-32.6667,3183),
                (152.4333,-32.65,3187),
                (152.4833,-32.6167,3193),
                (152.5167,-32.5833,3198),
                (152.55,-32.55,3202)]

        expected = [('longitude','latitude','index'),
                    (150.0833,-37.5,'2758'),
                    (150.1,-37.4667,'2765'),
                    (150.1167,-37.3833,'2769'),
                    (150.15,-37.35,'2795'),
                    (150.1667,-37.3,'2811'),
                    (150.1667,-37.25,'2808'),
                    (150.1833,-37.2167,'2827'),
                    (150.2,-37.2,'2839'),
                    (150.2,-37.1667,'2837'),
                    (150.2,-37.1333,'2835'),
                    (150.1833,-37.1,'2824'),
                    (150.1833,-37.05,'2821'),
                    (150.1667,-37.0167,'2807'),
                    (150.1667,-36.9667,'2804'),
                    (150.15,-36.9167,'2793'),
                    (150.15,-36.8667,'2790'),
                    (150.15,-36.8167,'2787'),
                    (150.1333,-36.7667,'2774'),
                    (150.1333,-36.7167,'2771'),
                    (150.15,-36.6833,'2783'),
                    (150.15,-36.6333,'2780'),
                    (150.15,-36.5833,'2777'),
                    (150.1667,-36.55,'2799'),
                    (150.1667,-36.5,'2796'),
                    (150.1833,-36.45,'2815'),
                    (150.2,-36.4,'2831'),
                    (150.2167,-36.3667,'2841'),
                    (150.25,-36.3333,'2862'),
                    (150.2667,-36.3,'2868'),
                    (150.2667,-36.25,'2865'),
                    (150.25,-36.2167,'2859'),
                    (150.25,-36.1667,'2856'),
                    (150.2333,-36.1167,'2847'),
                    (150.2333,-36.0667,'2844'),
                    (150.25,-36.0167,'2852'),
                    (150.3,-35.8833,'2870'),
                    (150.35,-35.75,'2872'),
                    (150.4333,-35.6333,'2873'),
                    (150.5,-35.5,'2875'),
                    (150.5667,-35.4,'2878'),
                    (150.6,-35.3667,'2882'),
                    (150.6333,-35.3333,'2889'),
                    (150.6667,-35.3,'2893'),
                    (150.7,-35.2667,'2898'),
                    (150.75,-35.2333,'2903'),
                    (150.8,-35.1833,'2907'),
                    (150.8333,-35.1333,'2913'),
                    (150.8667,-35.1,'2918'),
                    (150.9,-35.0667,'2923'),
                    (150.9333,-35.0167,'2927'),
                    (150.95,-34.9833,'2938'),
                    (150.9667,-34.95,'2956'),
                    (150.9667,-34.9,'2953'),
                    (150.9667,-34.85,'2951'),
                    (150.9667,-34.8,'2948'),
                    (150.9667,-34.75,'2947'),
                    (150.9667,-34.7,'2944'),
                    (150.9667,-34.6667,'2942'),
                    (150.9667,-34.6333,'2940'),
                    (150.9833,-34.5833,'2958'),
                    (151.0,-34.55,'2962'),
                    (151.0167,-34.5167,'2965'),
                    (151.0333,-34.5,'2968'),
                    (151.05,-34.4667,'2971'),
                    (151.0667,-34.4333,'2974'),
                    (151.0833,-34.4,'2977'),
                    (151.1,-34.35,'2980'),
                    (151.1167,-34.3167,'2984'),
                    (151.1333,-34.2833,'2988'),
                    (151.15,-34.2333,'2991'),
                    (151.1667,-34.1833,'2995'),
                    (151.2,-34.15,'3002'),
                    (151.2333,-34.1167,'3008'),
                    (151.2667,-34.0833,'3012'),
                    (151.3,-34.05,'3016'),
                    (151.3333,-34.0167,'3021'),
                    (151.3667,-33.9833,'3023'),
                    (151.3833,-33.95,'3027'),
                    (151.4,-33.9,'3034'),
                    (151.4,-33.85,'3031'),
                    (151.4167,-33.8,'3037'),
                    (151.4333,-33.75,'3041'),
                    (151.45,-33.7167,'3046'),
                    (151.4833,-33.6833,'3051'),
                    (151.5167,-33.65,'3054'),
                    (151.55,-33.6167,'3058'),
                    (151.5667,-33.5833,'3060'),
                    (151.5833,-33.55,'3063'),
                    (151.6167,-33.5167,'3070'),
                    (151.65,-33.4833,'3074'),
                    (151.6833,-33.45,'3077'),
                    (151.7333,-33.4,'3087'),
                    (151.7333,-33.35,'3084'),
                    (151.75,-33.3167,'3089'),
                    (151.7667,-33.2667,'3091'),
                    (151.7833,-33.2,'3095'),
                    (151.8,-33.1667,'3099'),
                    (151.8333,-33.1,'3109'),
                    (151.8667,-33.0667,'3116'),
                    (151.9,-33.0333,'3120'),
                    (151.9333,-33.0,'3125'),
                    (151.9833,-32.9667,'3130'),
                    (152.0333,-32.9333,'3137'),
                    (152.1,-32.9,'3145'),
                    (152.15,-32.8667,'3151'),
                    (152.2,-32.8333,'3158'),
                    (152.25,-32.8,'3164'),
                    (152.2833,-32.7667,'3168'),
                    (152.3333,-32.7167,'3177'),
                    (152.3667,-32.7,'3181'),
                    (152.4,-32.6667,'3183'),
                    (152.4333,-32.65,'3187'),
                    (152.4833,-32.6167,'3193'),
                    (152.5167,-32.5833,'3198'),
                    (152.55,-32.55,'3202')]

        # put test data into a file
        fd = open(infile, 'wb')
        w = csv.writer(fd)
        for d in data:
            w.writerow(d)
        fd.close()

        # call routine, put sorted points into output file
        ob.order_boundary(infile, outfile)

        # get sorted data into memory
        fd = open(outfile, 'r')
        data_list = []
        for data in csv.reader(fd):
            try:
                data[0] = float(data[0])
            except:
                pass
            try:
                data[1] = float(data[1])
            except:
                pass
            data_list.append(tuple(data))
        fd.close()

        # check same as expected
        self.assertTrue(data_list == expected)

        # clean up
        try:
            os.remove(infile)
        except:
            pass
        try:
            os.remove(outfile)
        except:
            pass


#-------------------------------------------------------------

if __name__ == "__main__":
    suite = unittest.makeSuite(Test_order_boundary, 'test')
    runner = unittest.TextTestRunner()
    runner.run(suite)

