import os
from setuptools import setup, find_packages

import hwd as pkg


def read(fname):
    """ Return content of specified file """
    return open(os.path.join(os.path.dirname(__file__), fname)).read()


VERSION = pkg.__version__

setup(
    name='hwd',
    version=VERSION,
    license='GPLv3',
    packages=[pkg.__name__],
    url='https://github.com/Outernet-Project/hwd',
    include_package_data=True,
    long_description=read('README.rst'),
    install_requires=[
        'pyudev>=0.17',
        'netifaces>=0.10.4',
    ],
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
        'Topic :: System :: Hardware',
        'Topic :: Utilities',
    ]
)
