import unittest2 as unittest

from croniter.testing import (
    CRONITER_FIXTURE as UNIT_TESTING,
    CRONITER_INTEGRATION_TESTING as INTEGRATION_TESTING,
    CRONITER_FUNCTIONAL_TESTING as FUNCTIONAL_TESTING,
)
from croniter.tests.globals import *

"""


Lot of files generated by the collective.generic packages  will try to load user defined objects in user specific files.
The final goal is to regenerate easyly the test infrastructure on templates updates without impacting
user-specific test boilerplate.
We do not use paster local commands (insert/update) as it cannot determine witch is specific or not and we prefer to totally
separe generated stuff and what is user specific


"""


class TestCase(unittest.TestCase):
    """We use this base class for all the tests in this package.
    If necessary, we can put common utility or setup code in here.
    """
    layer = UNIT_TESTING

    def setUp(self):
        super(TestCase, self).setUp()


class IntegrationTestCase(TestCase):
    """Integration base TestCase."""
    layer = INTEGRATION_TESTING


class FunctionalTestCase(TestCase):
    """Functionnal base TestCase."""
    layer = FUNCTIONAL_TESTING



# vim:set ft=python:
