/* This note applies to rcss, react, and underscore.
 *
 * We're faking a node module for this package by just exporting the global.
 * There are a few complications which led us to this solution as a temporary
 * fix.
 *
 * - Browserify can slow down a lot when you include the other packages (and
 *   their dependency graphs). We were also battling general browserify
 *   slowness at this time - browserify 3.4.0 is "good" but later versions
 *   (3.53 if I remember correctly) are terribly slow (on the order of 20x
 *   slower).
 *
 * - I'm not clear on the details of packaging this so we don't duplicate
 *   dependencies anywhere. For instance when packaging perseus for webapp we
 *   need to be careful not to include packages like underscore from our
 *   dependencies or from the packages we depend on. (note: this is a very good
 *   opportunity to either explain how existing tools solve the problem or
 *   create a new tool to solve it)
 *
 * - Joel (and Jack)
 */
module.exports = window._;
