# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PipelineRunQueryFilter(Model):
    """Query filter option for listing pipeline runs.

    :param operand: Parameter name to be used for filter. Possible values
     include: 'PipelineName', 'Status', 'RunStart', 'RunEnd'
    :type operand: str or
     ~azure.mgmt.datafactory.models.PipelineRunQueryFilterOperand
    :param operator: Operator to be used for filter. Possible values include:
     'Equals', 'NotEquals', 'In', 'NotIn'
    :type operator: str or
     ~azure.mgmt.datafactory.models.PipelineRunQueryFilterOperator
    :param values: List of filter values.
    :type values: list[str]
    """

    _validation = {
        'operand': {'required': True},
        'operator': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'operand': {'key': 'operand', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, operand, operator, values):
        self.operand = operand
        self.operator = operator
        self.values = values
