/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.parser.TypeCheckerEnvironment;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class LetExpression
extends Assignation
implements TailCallReturner {
    private int evaluationMode = -1;

    public String getExpressionName() {
        return "let";
    }

    public void setRefCount(int refCount) {
        this.refCount = refCount;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.sequence = visitor.typeCheck(this.sequence, contextInfo);
        RoleLocator role = new RoleLocator(3, this.getVariableQName(), 0);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, this.requiredType, role, visitor.getStaticContext());
        ItemType actualItemType = this.sequence.getItemType();
        this.refineTypeInformation(actualItemType, this.sequence.getCardinality(), this.sequence instanceof Literal ? ((Literal)this.sequence).getValue() : null, this.sequence.getSpecialProperties(), visitor, this);
        boolean indexed = this.refCount == 10000;
        this.refCount = 0;
        this.action = visitor.typeCheck(this.action, contextInfo);
        if (indexed) {
            this.refCount = 10000;
        }
        return this;
    }

    public boolean implementsStaticTypeCheck() {
        return true;
    }

    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, RoleLocator role, TypeCheckerEnvironment visitor) throws XPathException {
        this.action = TypeChecker.staticTypeCheck(this.action, req, backwardsCompatible, role, visitor);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression act2;
        Expression seq2;
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        if (this.action instanceof VariableReference && ((VariableReference)this.action).getBinding() == this && !ExpressionTool.changesXsltContext(this.sequence)) {
            Expression e2 = visitor.optimize(this.sequence, contextItemType);
            opt.trace("Eliminated trivial variable " + this.getVariableName(), e2);
            return e2;
        }
        if (this.sequence instanceof DocumentInstr && ((DocumentInstr)this.sequence).isTextOnly() && this.allReferencesAreFlattened()) {
            this.sequence = ((DocumentInstr)this.sequence).getStringValueExpression();
            this.requiredType = SequenceType.SINGLE_UNTYPED_ATOMIC;
            this.adoptChildExpression(this.sequence);
            this.refineTypeInformation(this.requiredType.getPrimaryType(), this.requiredType.getCardinality(), null, 0, visitor, this);
        }
        if (this.refCount == 0) {
            Expression a = visitor.optimize(this.action, contextItemType);
            ExpressionTool.copyLocationInfo(this, a);
            opt.trace("Eliminated unused variable " + this.getVariableName(), a);
            return a;
        }
        if (this.refCount == 1 && ExpressionTool.dependsOnFocus(this.sequence)) {
            Container container = this.getContainer();
            if (visitor.isOptimizeForStreaming()) {
                this.refCount = 5;
            }
        }
        if (this.refCount == 1 && ExpressionTool.changesXsltContext(this.sequence)) {
            this.refCount = 5;
        }
        if (this.refCount == 1 || this.sequence instanceof Literal) {
            this.replaceVariable(this.sequence);
            Expression e2 = visitor.optimize(this.action, contextItemType);
            opt.trace("Inlined local variable " + this.getVariableName(), e2);
            return e2;
        }
        int tries = 0;
        while (tries++ < 5 && (seq2 = visitor.optimize(this.sequence, contextItemType)) != this.sequence) {
            this.sequence = seq2;
            this.adoptChildExpression(this.sequence);
            visitor.resetStaticProperties();
        }
        tries = 0;
        while (tries++ < 5 && (act2 = visitor.optimize(this.action, contextItemType)) != this.action) {
            this.action = act2;
            this.adoptChildExpression(this.action);
            visitor.resetStaticProperties();
        }
        this.evaluationMode = this.isIndexedVariable() ? 3 : ExpressionTool.lazyEvaluationMode(this.sequence);
        return this;
    }

    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.sequence == original) {
            this.sequence = replacement;
            this.setEvaluationMode(ExpressionTool.eagerEvaluationMode(this.sequence));
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        return found;
    }

    private boolean allReferencesAreFlattened() {
        ArrayList<VariableReference> references = new ArrayList<VariableReference>();
        ExpressionTool.gatherVariableReferences(this.action, this, references);
        for (int i = references.size() - 1; i >= 0; --i) {
            BindingReference bref = (BindingReference)references.get(i);
            if (bref instanceof VariableReference) {
                VariableReference ref = (VariableReference)bref;
                if (ref.isFlattened()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isVacuousExpression() {
        return this.action.isVacuousExpression();
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, whole);
    }

    public IntegerValue[] getIntegerBounds() {
        return this.action.getIntegerBounds();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        return let.action.iterate(context);
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        return let.action.iterateEvents(context);
    }

    public Sequence eval(XPathContext context) throws XPathException {
        if (this.evaluationMode == -1) {
            this.evaluationMode = ExpressionTool.lazyEvaluationMode(this.sequence);
        }
        int savedOutputState = context.getTemporaryOutputState();
        context.setTemporaryOutputState(206);
        Sequence result = ExpressionTool.evaluate(this.sequence, this.evaluationMode, context, this.refCount);
        context.setTemporaryOutputState(savedOutputState);
        return result;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        return let.action.evaluateItem(context);
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        return let.action.effectiveBooleanValue(context);
    }

    public void process(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        let.action.process(context);
    }

    public ItemType getItemType() {
        return this.action.getItemType();
    }

    public int computeCardinality() {
        return this.action.getCardinality();
    }

    public int computeSpecialProperties() {
        int props = this.action.getSpecialProperties();
        int seqProps = this.sequence.getSpecialProperties();
        if ((seqProps & 0x400000) == 0) {
            props &= 0xFFBFFFFF;
        }
        return props;
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        return ExpressionTool.markTailFunctionCalls(this.action, qName, arity);
    }

    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Binding b;
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        Expression seq2 = this.doPromotion(this.sequence, offer);
        if (seq2 != this.sequence) {
            if (seq2 instanceof VariableReference && (b = ((VariableReference)seq2).getBinding()) instanceof GlobalVariable && this.refCount == 10000) {
                ((GlobalVariable)b).setIndexedVariable();
            }
            this.sequence = seq2;
        }
        if (offer.action == 14) {
            this.action = this.doPromotion(this.action, offer);
        } else if (offer.action == 11 || offer.action == 10) {
            Binding[] savedBindingList = offer.bindingList;
            offer.bindingList = this.extendBindingList(offer.bindingList);
            this.action = this.doPromotion(this.action, offer);
            offer.bindingList = savedBindingList;
        }
        if (this.sequence instanceof VariableReference && (b = ((VariableReference)this.sequence).getBinding()) != null && !b.isAssignable()) {
            this.replaceVariable(this.sequence);
            if (ExpressionTool.dependsOnVariable(this.action, new Binding[]{this})) {
                offer.getOptimizer().trace("Failed to eliminate redundant variable $" + this.getVariableName(), this);
            } else {
                return this.action;
            }
        }
        return this;
    }

    public Expression copy() {
        LetExpression let = new LetExpression();
        let.refCount = this.refCount;
        let.setVariableQName(this.variableName);
        let.setRequiredType(this.requiredType);
        let.setSequence(this.sequence.copy());
        Expression newAction = this.action.copy();
        let.setAction(newAction);
        ExpressionTool.rebindVariableReferences(newAction, this, let);
        return let;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        if (let.action instanceof TailCallReturner) {
            return ((TailCallReturner)((Object)let.action)).processLeavingTail(context);
        }
        let.action.process(context);
        return null;
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.action instanceof LetExpression)) break;
            let = (LetExpression)let.action;
        }
        let.action.evaluatePendingUpdates(context, pul);
    }

    public String toString() {
        return "let $" + this.getVariableEQName() + " := " + this.sequence.toString() + " return " + ExpressionTool.parenthesize(this.action);
    }

    public String toShortString() {
        return "let $" + this.getVariableName() + " := ...";
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("let");
        out.emitAttribute("variable", this.getVariableEQName());
        out.emitAttribute("as", this.sequence.getItemType().toString() + Cardinality.getOccurrenceIndicator(this.sequence.getCardinality()));
        if (this.isIndexedVariable()) {
            out.emitAttribute("indexable", "true");
        }
        out.emitAttribute("slot", this.getLocalSlotNumber() + "");
        out.startSubsidiaryElement("be");
        this.sequence.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("return");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    public void setEvaluationMode(int evaluationMode) {
        this.evaluationMode = evaluationMode;
    }

    public int getEvaluationMode() {
        return this.evaluationMode;
    }
}

