#coding=utf-8

import smtplib
from email.header import Header
from email.mime.text import MIMEText

def send(
    from_addr, 
    to_addr,
    host='localhost', 
    port=25, 
    cc_addr = '', 
    title = '', 
    content = ''
):
    msg = MIMEText(content, 'plain', 'utf-8')
    msg['From'] = from_addr
    msg['To'] = to_addr
    msg['Cc'] = cc_addr
    msg['Subject'] = Header(title, 'utf-8').encode()
    s = smtplib.SMTP(host = host, port = port)
    s.sendmail(
        from_addr = from_addr,
        to_addrs = to_addr,
        msg = msg.as_string()
    )
    return True
