from __future__ import absolute_import, division, print_function
from abc import ABCMeta, abstractproperty, abstractmethod

from future.utils import with_metaclass

from bingads.v12.bulk.entities import BulkError
from bingads.v12.internal.bulk.bulk_object import _BulkObject


class _BulkEntityIdentifier(with_metaclass(ABCMeta, _BulkObject)):

    @abstractproperty
    def is_delete_row(self):
        raise NotImplementedError()

    @abstractmethod
    def _create_entity_with_this_identifier(self):
        raise NotImplementedError()

    def write_to_stream(self, row_writer, exclude_readonly_data):
        row_writer.write_object_row(self)

    def read_related_data_from_stream(self, stream_reader):
        if self.is_delete_row:
            has_more_errors = True

            while has_more_errors:
                has_more_errors, error = stream_reader.try_read(BulkError)

    @property
    def can_enclose_in_multiline_entity(self):
        return True

    def enclose_in_multiline_entity(self):
        return self._create_entity_with_this_identifier()
