# This file was auto-generated by zetup
#
# https://bitbucket.org/userzimmermann/zetup.py


from __future__ import absolute_import

import sys
import os
from collections import OrderedDict

from zetup.version import Version
from zetup.dist import Distribution
from zetup.requires import Requirements
from zetup.extras import Extras
from zetup.package import Packages, Package
from zetup.notebook import Notebook



zfg = sys.modules[__name__]

NAME = 'zetup'

KEEP_MADE = []

SCRIPTS = {'zetup': 'zetup.script:run'}

TITLE = 'zetup'

SETUP_REQUIRES = None

URL = 'https://bitbucket.org/userzimmermann/zetup.py'

EMAIL = 'zimmermann.code@gmail.com'

DISTRIBUTION = Distribution(zfg)

DESCRIPTION = "Zimmermann's Python package setup"

EXTRAS = Extras([
('commands', Requirements("""
path.py >= 8.0 #import path
jinjatools >= 0.1.6

""")),
('notebook', Requirements("""
path.py >= 8.0 #import path
ipython >= 4.0 #import IPython
nbconvert >= 4.0

""")),
('pytest', Requirements("""
pytest

"""))
], zfg=zfg)

VERSION = Version('0.2.30')

KEYWORDS = ['setup', 'python3']

TEST_COMMANDS = ['py.test -v test']

PACKAGES = Packages([

Package('zetup',
  sources=[
    'annotate.py',
    'conda.py',
    'config.py',
    'dist.py',
    'error.py',
    'extras.py',
    'modules.py',
    'object.py',
    'package.py',
    'requires.py',
    'script.py',
    'version.py',
    'zetup.py',
    '__init__.py'
    ],
  subpackages=[
    
Package('zetup.commands',
  sources=[
    'command.py',
    'conda.py',
    'del_.py',
    'dev.py',
    'error.py',
    'pytest.py',
    'run.py',
    'test.py',
    'tox.py',
    '__init__.py'
    ],
  subpackages=[
    
Package('zetup.commands.make',
  sources=[
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )
,
    
Package('zetup.notebook',
  sources=[
    'jinja.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('zetup.process',
  sources=[
    'scons.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )

  ], root=os.path.dirname(os.path.dirname(os.path.realpath(__file__))))

PYTHON = ['2.7', '3.3', '3.4', '3.5']

MODULES = []

REQUIRES = Requirements("""
setuptools # >= 15.0
setuptools_scm

""", zfg=zfg)

FORCE_MAKE = True

CLASSIFIERS = ['Development Status :: 3 - Alpha', 'Intended Audience :: Developers', 'License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)', 'Operating System :: OS Independent', 'Topic :: Software Development', 'Topic :: Utilities', 'Programming Language :: Python', 'Programming Language :: Python :: 2.7', 'Programming Language :: Python :: 3.3', 'Programming Language :: Python :: 3.4', 'Programming Language :: Python :: 3.5']

SETUP_KEYWORDS = {'use_zetup': 'zetup:setup_entry_point'}

NO_MAKE = ['setup.py', 'tox.ini']

AUTHOR = 'Stefan Zimmermann'

LICENSE = 'LGPLv3'

SETUP_HOOKS = []