# Leo colorizer control file for clojure mode.
# This file is in the public domain.

# Properties for clojure mode.
properties = {
	"lineComment": ";",
	"multipleBracketIndent": "true",
	"noWordSep": ".*+!-_?/",
	"unalignedCloseBrackets": ")",
	"unalignedOpenBrackets": "(",
}

# Attributes dict for clojure_main ruleset.
clojure_main_attributes_dict = {
	"default": "null",
	"digit_re": "([0-9]+)|(([0-9]*\\.[0-9]+)M?)|([0-9]+/[0-9]+)",
	"escape": "\\", ### was ""
	"highlight_digits": "true",
	"ignore_case": "false",
	"no_word_sep": ".*+!-_?/",
}

# Dictionary of attributes dictionaries for clojure mode.
attributesDictDict = {
	"clojure_main": clojure_main_attributes_dict,
}

# Keywords dict for clojure_main ruleset.
clojure_main_keywords_dict = {
	"%": "keyword4",
	"&": "keyword3",
	"*": "keyword4",
	"*ns*": "keyword3",
	"*out*": "keyword3",
	"*print-readably*": "keyword3",
	"*warn-on-reflection*": "keyword3",
	"+": "keyword4",
	"-": "keyword4",
	"/": "keyword4",
	"<": "keyword4",
	"=": "keyword4",
	"==": "keyword4",
	">": "keyword4",
	"accessor": "keyword1",
	"agent": "function",
	"agent-errors": "keyword1",
	"aget": "keyword1",
	"alength": "keyword1",
	"all-ns": "keyword3",
	"alter": "keyword3",
	"and": "keyword4",
	"apply": "keyword4",
	"array-map": "function",
	"aset": "keyword1",
	"assert": "keyword3",
	"assoc": "keyword1",
	"await": "keyword3",
	"await-for": "keyword3",
	"bean": "function",
	"binding": "function",
	"bit-and": "keyword4",
	"bit-not": "keyword4",
	"bit-or": "keyword4",
	"bit-shift-left": "keyword4",
	"bit-shift-right": "keyword4",
	"boolean": "function",
	"byte": "function",
	"catch": "keyword2",
	"char": "function",
	"clear-agent-errors": "keyword1",
	"commute": "function",
	"comp": "keyword3",
	"comparator": "keyword3",
	"complement": "keyword3",
	"concat": "keyword1",
	"cond": "keyword2",
	"conj": "keyword1",
	"cons": "function",
	"constantly": "keyword3",
	"contains?": "keyword4",
	"count": "keyword1",
	"create-ns": "function",
	"create-struct": "function",
	"cycle": "keyword1",
	"dec": "keyword4",
	"def": "function",
	"defmacro": "function",
	"defmethod": "function",
	"defmulti": "function",
	"defn": "function",
	"defstruct": "function",
	"deref": "function",
	"diffference": "keyword4",
	"disj": "keyword1",
	"dissoc": "keyword1",
	"distinct": "keyword4",
	"do": "keyword2",
	"doall": "keyword3",
	"dorun": "keyword3",
	"doseq": "keyword3",
	"dosync": "keyword3",
	"dotimes": "keyword2",
	"doto": "keyword3",
	"double": "function",
	"drop": "keyword1",
	"drop-while": "keyword1",
	"ensure": "keyword3",
	"eval": "keyword4",
	"every?": "keyword4",
	"false": "literal4",
	"false?": "keyword4",
	"ffirst": "keyword1",
	"filter": "keyword1",
	"finally": "keyword2",
	"find": "keyword1",
	"find-ns": "keyword3",
	"find-var": "keyword1",
	"first": "keyword1",
	"fn": "function",
	"fnseq": "keyword1",
	"for": "keyword3",
	"frest": "keyword1",
	"get": "keyword1",
	"hash-map": "function",
	"hash-set": "function",
	"identical?": "keyword4",
	"identity": "keyword3",
	"if": "keyword2",
	"import": "keyword3",
	"in-ns": "keyword3",
	"inc": "keyword4",
	"index": "keyword4",
	"instance?": "keyword4",
	"int": "function",
	"interleave": "keyword1",
	"intersection": "keyword4",
	"into": "keyword1",
	"into-array": "keyword1",
	"iterate": "keyword1",
	"join": "keyword4",
	"key": "keyword1",
	"keys": "keyword1",
	"keyword": "keyword4",
	"lazy-cat": "keyword1",
	"lazy-cons": "keyword1",
	"let": "function",
	"line-seq": "keyword1",
	"list": "function",
	"load": "keyword4",
	"load-file": "keyword4",
	"locking": "keyword1",
	"long": "function",
	"loop": "keyword2",
	"macroexpand": "keyword1",
	"macroexpand-1": "keyword1",
	"make-array": "function",
	"map": "keyword1",
	"map?": "keyword4",
	"mapcat": "keyword1",
	"max": "keyword4",
	"memfn": "function",
	"merge": "keyword1",
	"merge-with": "keyword1",
	"meta": "function",
	"min": "keyword4",
	"monitor-enter": "keyword1",
	"monitor-exit": "keyword1",
	"name": "keyword1",
	"namespace": "keyword1",
	"neg?": "keyword4",
	"new": "function",
	"newline": "literal1",
	"nil": "literal4",
	"nil?": "keyword4",
	"not": "keyword4",
	"not-any?": "keyword4",
	"not-every?": "keyword4",
	"not=": "keyword4",
	"ns-imports": "keyword1",
	"ns-interns": "keyword1",
	"ns-map": "keyword1",
	"ns-name": "keyword1",
	"ns-publics": "keyword1",
	"ns-refers": "keyword1",
	"ns-resolve": "keyword1",
	"ns-unmap": "keyword1",
	"nth": "keyword1",
	"nthrest": "keyword1",
	"or": "keyword4",
	"parse": "function",
	"partial": "keyword3",
	"peek": "keyword1",
	"pop": "keyword1",
	"pos?": "keyword4",
	"pr": "keyword1",
	"pr-str": "keyword1",
	"print": "keyword1",
	"print-str": "keyword1",
	"println": "keyword1",
	"println-str": "keyword1",
	"prn": "keyword1",
	"prn-str": "keyword1",
	"proxy": "function",
	"put": "keyword1",
	"quot": "keyword4",
	"quote": "keyword1",
	"range": "keyword1",
	"re-find": "keyword1",
	"re-groups": "keyword1",
	"re-matcher": "keyword1",
	"re-matches": "keyword1",
	"re-seq": "keyword1",
	"read": "keyword4",
	"recur": "keyword2",
	"reduce": "keyword1",
	"ref": "function",
	"ref-set": "function",
	"refer": "keyword3",
	"rem": "keyword4",
	"remove-method": "function",
	"remove-ns": "function",
	"rename": "keyword4",
	"repeat": "keyword1",
	"replicate": "keyword1",
	"resolve": "keyword1",
	"rest": "keyword1",
	"reverse": "keyword1",
	"rfirst": "keyword1",
	"rrest": "keyword1",
	"rseq": "keyword1",
	"second": "keyword1",
	"select": "keyword4",
	"select-keys": "keyword1",
	"send": "keyword3",
	"send-off": "keyword3",
	"seq": "keyword1",
	"seq?": "keyword4",
	"set": "function",
	"set!": "function",
	"short": "function",
	"shutdown": "keyword3",
	"some": "keyword1",
	"sort": "keyword1",
	"sort-by": "keyword1",
	"sorted-map": "function",
	"sorted-map-by": "function",
	"sorted-set": "function",
	"split-at": "keyword1",
	"split-with": "keyword1",
	"str": "keyword1",
	"string?": "keyword4",
	"struct": "function",
	"struct-map": "function",
	"submit": "keyword4",
	"subvec": "keyword1",
	"symbol": "keyword4",
	"symbol?": "keyword4",
	"take": "keyword1",
	"take-nth": "keyword1",
	"take-while": "keyword1",
	"throw": "keyword2",
	"time": "keyword1",
	"to-array": "keyword1",
	"to-array-2d": "keyword1",
	"true": "literal4",
	"true?": "keyword4",
	"try": "keyword2",
	"union": "keyword4",
	"val": "keyword1",
	"vals": "keyword1",
	"var": "function",
	"var-get": "keyword1",
	"var-set": "keyword1",
	"vector": "function",
	"vector?": "keyword4",
	"when": "keyword2",
	"when-first": "keyword3",
	"when-not": "keyword2",
	"with-local-vars": "function",
	"with-meta": "keyword1",
	"with-open": "keyword2",
	"with-out-str": "keyword2",
	"zero?": "keyword4",
	"zipmap": "keyword1",
}

# Dictionary of keywords dictionaries for clojure mode.
keywordsDictDict = {
	"clojure_main": clojure_main_keywords_dict,
}

# Rules for clojure_main ruleset.

def clojure_rule0(colorer, s, i):
    return colorer.match_seq(s, i, kind="keyword1", seq="#'",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def clojure_rule1(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="literal3", pattern="'",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, exclude_match=False)

def clojure_rule2(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="label", pattern="@",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, exclude_match=False)

def clojure_rule3(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="markup", pattern="#^",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, exclude_match=False)

def clojure_rule4(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment4", seq=";;;;",
        at_line_start=False, at_whitespace_end=False, at_word_start=False,
        delegate="", exclude_match=False)

def clojure_rule5(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment3", seq=";;;",
        at_line_start=False, at_whitespace_end=False, at_word_start=False,
        delegate="", exclude_match=False)

def clojure_rule6(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment2", seq=";;",
        at_line_start=False, at_whitespace_end=False, at_word_start=False,
        delegate="", exclude_match=False)

def clojure_rule7(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment1", seq=";",
        at_line_start=False, at_whitespace_end=False, at_word_start=False,
        delegate="", exclude_match=False)

def clojure_rule8(colorer, s, i):
    return colorer.match_span(s, i, kind="literal2", begin="#\"", end="\"",
        at_line_start=False, at_whitespace_end=False, at_word_start=False,
        delegate="clojure::regexps",exclude_match=False,
        no_escape=False, no_line_break=False, no_word_break=False)

def clojure_rule9(colorer, s, i):
    return colorer.match_span(s, i, kind="literal1", begin="\"", end="\"",
        at_line_start=False, at_whitespace_end=False, at_word_start=False,
        delegate="clojure::strings",exclude_match=False,
        no_escape=False, no_line_break=False, no_word_break=False)

def clojure_rule10(colorer, s, i):
    return colorer.match_keywords(s, i)

# Rules dict for clojure_main ruleset.
rulesDict1 = {
	"!": [clojure_rule10,],
	"\"": [clojure_rule9,],
	"#": [clojure_rule0,clojure_rule3,clojure_rule8,],
	"%": [clojure_rule10,],
	"&": [clojure_rule10,],
	"'": [clojure_rule1,],
	"*": [clojure_rule10,],
	"+": [clojure_rule10,],
	"-": [clojure_rule10,],
	"/": [clojure_rule10,],
	"0": [clojure_rule10,],
	"1": [clojure_rule10,],
	"2": [clojure_rule10,],
	"3": [clojure_rule10,],
	"4": [clojure_rule10,],
	"5": [clojure_rule10,],
	"6": [clojure_rule10,],
	"7": [clojure_rule10,],
	"8": [clojure_rule10,],
	"9": [clojure_rule10,],
	";": [clojure_rule4,clojure_rule5,clojure_rule6,clojure_rule7,],
	"<": [clojure_rule10,],
	"=": [clojure_rule10,],
	">": [clojure_rule10,],
	"?": [clojure_rule10,],
	"@": [clojure_rule2,clojure_rule10,],
	"A": [clojure_rule10,],
	"B": [clojure_rule10,],
	"C": [clojure_rule10,],
	"D": [clojure_rule10,],
	"E": [clojure_rule10,],
	"F": [clojure_rule10,],
	"G": [clojure_rule10,],
	"H": [clojure_rule10,],
	"I": [clojure_rule10,],
	"J": [clojure_rule10,],
	"K": [clojure_rule10,],
	"L": [clojure_rule10,],
	"M": [clojure_rule10,],
	"N": [clojure_rule10,],
	"O": [clojure_rule10,],
	"P": [clojure_rule10,],
	"Q": [clojure_rule10,],
	"R": [clojure_rule10,],
	"S": [clojure_rule10,],
	"T": [clojure_rule10,],
	"U": [clojure_rule10,],
	"V": [clojure_rule10,],
	"W": [clojure_rule10,],
	"X": [clojure_rule10,],
	"Y": [clojure_rule10,],
	"Z": [clojure_rule10,],
	"a": [clojure_rule10,],
	"b": [clojure_rule10,],
	"c": [clojure_rule10,],
	"d": [clojure_rule10,],
	"e": [clojure_rule10,],
	"f": [clojure_rule10,],
	"g": [clojure_rule10,],
	"h": [clojure_rule10,],
	"i": [clojure_rule10,],
	"j": [clojure_rule10,],
	"k": [clojure_rule10,],
	"l": [clojure_rule10,],
	"m": [clojure_rule10,],
	"n": [clojure_rule10,],
	"o": [clojure_rule10,],
	"p": [clojure_rule10,],
	"q": [clojure_rule10,],
	"r": [clojure_rule10,],
	"s": [clojure_rule10,],
	"t": [clojure_rule10,],
	"u": [clojure_rule10,],
	"v": [clojure_rule10,],
	"w": [clojure_rule10,],
	"x": [clojure_rule10,],
	"y": [clojure_rule10,],
	"z": [clojure_rule10,],
}

# x.rulesDictDict for clojure mode.
rulesDictDict = {
	"clojure_main": rulesDict1,
}

# Import dict for clojure mode.
importDict = {}

