# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CreateStorageAccountInfo(Model):
    """Azure Storage account information to add to the Data Lake analytics
    account being created.

    :param name: the account name associated with the Azure storage account
     to add to the Data Lake analytics account being created.
    :type name: str
    :param access_key: the access key associated with this Azure Storage
     account that will be used to connect to it.
    :type access_key: str
    :param suffix: the optional suffix for the storage account.
    :type suffix: str
    """ 

    _validation = {
        'name': {'required': True},
        'access_key': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'access_key': {'key': 'properties.accessKey', 'type': 'str'},
        'suffix': {'key': 'properties.suffix', 'type': 'str'},
    }

    def __init__(self, name, access_key, suffix=None):
        self.name = name
        self.access_key = access_key
        self.suffix = suffix
