# -*- coding: utf-8 -*-
"""
Base module for unittesting
---------------------------
"""

import unittest2 as unittest

from plone.app.controlpanel.tests import ControlPanelTestCase
from plone.app.testing import applyProfile
from plone.app.testing import FunctionalTesting
from plone.app.testing import IntegrationTesting
from plone.app.testing import login
from plone.app.testing import PLONE_FIXTURE
from plone.app.testing import PloneSandboxLayer
from plone.app.testing import setRoles
from plone.app.testing import TEST_USER_ID
from plone.app.testing import TEST_USER_NAME
from plone.testing import z2
from Products.CMFPlone.tests.utils import MockMailHost
from Products.MailHost.interfaces import IMailHost
from zope.site.hooks import getSite

import logging


class MockedLoggingHandler(logging.Handler):

    debug = []
    warning = []
    info = []
    error = []

    def emit(self, record):
        getattr(self.__class__, record.levelname.lower()).append(record.getMessage())

    @classmethod
    def reset(cls):
        for attr in dir(cls):
            if isinstance(getattr(cls, attr), list):
                setattr(cls, attr, [])


class NiteowebJVZooLayer(PloneSandboxLayer):

    defaultBases = (PLONE_FIXTURE,)

    def setUpZope(self, app, configurationContext):
        """Set up Zope."""
        # Load ZCML
        import niteoweb.jvzoo
        self.loadZCML(package=niteoweb.jvzoo)
        z2.installProduct(app, 'niteoweb.jvzoo')

    def setUpPloneSite(self, portal):
        """Set up Plone."""
        # Install into Plone site using portal_setup
        applyProfile(portal, 'niteoweb.jvzoo:default')

        # Login as Manager
        setRoles(portal, TEST_USER_ID, ['Manager'])
        login(portal, TEST_USER_NAME)

        # Mock mailhost
        portal.email_from_address = 'info@example.org'
        mockmailhost = MockMailHost('MailHost')
        portal.MailHost = mockmailhost
        sm = getSite().getSiteManager()
        sm.registerUtility(component=mockmailhost, provided=IMailHost)

        # Commit so that the test browser sees these objects
        portal.portal_catalog.clearFindAndRebuild()
        import transaction
        transaction.commit()

        # add a logging handler that stores everything in a list so we can
        # later assert on it
        logger = logging.getLogger('niteoweb.jvzoo')
        logger.addHandler(MockedLoggingHandler())

    def tearDownZope(self, app):
        """Tear down Zope."""
        z2.uninstallProduct(app, 'niteoweb.jvzoo')


FIXTURE = NiteowebJVZooLayer()
INTEGRATION_TESTING = IntegrationTesting(
    bases=(FIXTURE,), name="NiteowebJVZooLayer:Integration")
FUNCTIONAL_TESTING = FunctionalTesting(
    bases=(FIXTURE,), name="NiteowebJVZooLayer:Functional")


class IntegrationTestCase(unittest.TestCase):
    """Base class for integration tests."""

    layer = INTEGRATION_TESTING


class FunctionalTestCase(unittest.TestCase):
    """Base class for functional tests."""

    layer = FUNCTIONAL_TESTING


class JvzooControlPanelTestCase(FunctionalTestCase, ControlPanelTestCase):
    """Test case used for control panel tests, with some convenience
    methods from plone.app.controlpanel.
    """
