# -*- coding: utf-8 -*-

################################################################
# zopyx.plone.smashdocs
# (C) 2016,  Andreas Jung, www.zopyx.com, Tuebingen, Germany
################################################################


from zope import schema
from zope.interface import Interface


from .i18n import MessageFactory as _


class IBrowserLayer(Interface):
    """A brower layer specific to my product """


class ISmashdocsSettings(Interface):
    """ Connector settings """

    client_id = schema.TextLine(
        title=_(u'Client ID'),
        default=None,
        required=True
    )

    client_key = schema.TextLine(
        title=_(u'Client Key'),
        default=None,
        required=True
    )

    partner_url = schema.TextLine(
        title=_(u'Partner URL'),
        default=u'https://partner.smashdocs.net/api',
        required=True
    )

    group_id = schema.TextLine(
        title=_(u'Default group id '),
        default=u'default',
        required=True
    )
