"""
Unit tests for items

'Tale' mud driver, mudlib and interactive fiction framework
Copyright by Irmen de Jong (irmen@razorvine.net)
"""
from __future__ import print_function, division, unicode_literals, absolute_import
import datetime
import unittest
from tale.errors import ActionRefused
from tale.items import basic
from tale import mud_context
from tale import util, player, base
from tests.supportstuff import TestDriver
from tale.driver import StoryConfig


class TestItems(unittest.TestCase):
    def setUp(self):
        mud_context.driver = TestDriver()
        mud_context.config = StoryConfig(**dict.fromkeys(StoryConfig.config_items))   # empty config
        self.actor = player.Player("julie", "f")

    def test_gameclock(self):
        mud_context.driver.game_clock = util.GameDateTime(datetime.datetime(2013, 9, 17, 13, 52, 30))
        c = basic.gameclock
        c.use_locale = False
        mud_context.config.display_gametime = False
        c.read(self.actor)
        out = self.actor.test_get_output_paragraphs()[0]
        self.assertEqual("It looks broken.\n", out)
        mud_context.config.display_gametime = True
        c.read(self.actor)
        out = self.actor.test_get_output_paragraphs()[0]
        self.assertEqual("It reads: 2013-09-17 13:52:30\n", out)

    def test_newspaper(self):
        n = basic.newspaper
        n.read(self.actor)
        out = self.actor.test_get_output_paragraphs()[0]
        self.assertTrue(out.startswith("The newspaper reads:"))

    def test_pouch(self):
        p = basic.pouch
        thing = base.Item("thing")
        self.assertEqual(0, p.inventory_size)
        p.insert(thing, self.actor)
        self.assertTrue(thing in p)
        self.assertEqual(1, p.inventory_size)
        p.remove(thing, self.actor)
        self.assertFalse(thing in p)

    def test_trashcan(self):
        t = basic.trashcan
        thing = base.Item("thing")
        with self.assertRaises(ActionRefused):
            t.insert(thing, self.actor)
        t.open(self.actor)
        t.insert(thing, self.actor)
        self.assertTrue(thing in t)
        t.close(self.actor)
        with self.assertRaises(ActionRefused):
            t.remove(thing, self.actor)
        t.open(self.actor)
        t.remove(thing, self.actor)
        self.assertFalse(thing in t)


if __name__ == '__main__':
    unittest.main()
