import cx_Oracle
import simplejson
from shapely.geometry import asShape 
from sdo import Geometry as SdoGeometry
from sdo import Geometry as Geometry
import sdo
import re
import sys

def tuple_construct(*args):
    return(list([float(a) for a in args]))

con = cx_Oracle.connect(sys.argv[1])
cur = con.cursor()

test_data = [
             "MDSYS.SDO_GEOMETRY(2006,null,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,2,1,49,2,1,95,2,1),MDSYS.SDO_ORDINATE_ARRAY(-569661.628493,-1273409.559753,-569635.988041,-1273398.570988,-569600.667009,-1273381.826202,-569567.962351,-1273360.895221,-569549.647742,-1273351.476279,-569498.890112,-1273331.591847,-569436.097167,-1273309.614316,-569358.129261,-1273281.357491,-569310.24964,-1273265.920892,-569284.609188,-1273259.903235,-569253.73599,-1273255.455401,-569222.339518,-1273254.932127,-569158.238387,-1273257.286862,-569104.864384,-1273263.827794,-569053.583479,-1273273.508373,-569037.885243,-1273274.031647,-568987.912524,-1273272.985098,-568947.620385,-1273269.060539,-568925.11958,-1273264.351069,-568901.048951,-1273258.856686,-568887.70545,-1273255.717039,-568876.716685,-1273251.007568,-568807.906083,-1273349.383181,-568769.183767,-1273401.972272,-569569.814749,-1273362.080756,-569576.596381,-1273347.911471,-569598.573911,-1273304.479685,-569604.591568,-1273289.893407,-569607.992853,-1273280.212828,-569611.655775,-1273261.374945,-569614.533785,-1273232.07157,-569616.103608,-1273204.33802,-569618.719981,-1273186.285048,-569623.691089,-1273170.848449,-569630.755295,-1273153.58039,-569632.586756,-1273144.94636,-569632.586756,-1273130.033035,-569634.941492,-1273120.352456,-569647.761718,-1273089.217621,-569658.227209,-1273067.240091,-569672.093984,-1273043.692736,-569676.541818,-1273030.87251,-569677.850004,-1273020.145382,-569676.803455,-1273009.679891,-569672.093984,-1273000.26095,-569668.692699,-1272993.720018,-569667.907788,-1272986.655812,-569774.655794,-1273123.851855,-569755.81791,-1273090.787445,-569742.474409,-1273072.211199,-569732.79383,-1273058.344423,-569729.130909,-1273049.448756,-569723.113252,-1273027.9945,-569719.188692,-1273016.220823,-569712.386123,-1273008.371705,-569701.920633,-1273002.092411,-569667.907788,-1272986.655812,-569618.719981,-1272966.509742,-569578.427842,-1272946.363672,-569573.718371,-1272942.177476,-569572.410184,-1272935.636544,-569572.933459,-1272927.002514,-569583.660587,-1272899.007326,-569602.49847,-1272851.389343,-569610.347588,-1272835.952744,-569617.411795,-1272826.533803))",
             "MDSYS.SDO_GEOMETRY(2002,null,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,2,1),MDSYS.SDO_ORDINATE_ARRAY(-560704.155,-1265827.399,-560772.91,-1265669.043,-560831.806,-1265531.747))",
"MDSYS.SDO_GEOMETRY(2002,null,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,2,1),MDSYS.SDO_ORDINATE_ARRAY(-552205.845,-1274831.432,-552318.748,-1274649.987))",
"""MDSYS.SDO_GEOMETRY(2007,null,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,9,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(0,0,10,0,10,10,0,0,20,0,40,0,40,40,40,20,20,0))""",
'MDSYS.SDO_GEOMETRY(2007,null,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,9,1003,1),MDSYS.SDO_ORDINATE_ARRAY(1,1,10,1,10,10,1,1,11,1,20,1,20,10,11,1))',
'MDSYS.SDO_GEOMETRY(2006,null,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,2,1,5,2,1),MDSYS.SDO_ORDINATE_ARRAY(-572493.608498,-1278953.984257,-572442.021442,-1278884.175201,-572450.088024,-1278878.444985,-572393.993456,-1278794.902054))',
"""MDSYS.SDO_GEOMETRY(
    2003,  
    NULL,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1, 19,2003,1),
    SDO_ORDINATE_ARRAY(2,4, 4,3, 10,3, 13,5, 13,9, 11,13, 5,13, 2,11, 2,4,
        7,5, 7,10, 10,10, 10,5, 7,5)
  )""",#polygon with hole
"""MDSYS.SDO_GEOMETRY(
      2001,
      NULL,
      SDO_POINT_TYPE(12, 14, NULL),
      NULL,
      NULL)""",
"MDSYS.SDO_GEOMETRY(2006,null,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,2,1,7,2,1),MDSYS.SDO_ORDINATE_ARRAY(-565103.996283,-1286038.100927,-565074.954589,-1286088.923892,-565055.247725,-1286123.843072,-565110.565238,-1286159.453721,-565016.352599,-1286098.777324))",
"MDSYS.SDO_GEOMETRY(2003,null,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,3),MDSYS.SDO_ORDINATE_ARRAY(-559346.778397786,-1269668.14743684,-556346.778397786,-1266668.14743684))",
"MDSYS.SDO_GEOMETRY(2001,null,MDSYS.SDO_POINT_TYPE(-569253.73599,-1273255.455401,null),null,null)",
"MDSYS.SDO_GEOMETRY(2003,null,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,3),MDSYS.SDO_ORDINATE_ARRAY(-569774.655794,-1273409.559753,-568769.183767,-1272826.533803))",
"MDSYS.SDO_GEOMETRY(2001,null,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1,1),MDSYS.SDO_ORDINATE_ARRAY(-575339.066928998,-1245224.47664912))",
]


for sel in test_data:

    print "sel:"+sel
    
    translated = sel
    for i in dict({"null":"None",
                   "MDSYS\.":"",
                   "SDO_GEOMETRY":"Geometry",
                   "SDO_ELEM_INFO_ARRAY":"tuple_construct",
                   "SDO_ORDINATE_ARRAY":"tuple_construct",
                   "SDO_POINT_TYPE":"sdo.Point"}).items():
        translated = re.sub(re.compile(i[0],re.IGNORECASE),i[1],translated)
    
    print "Translated:"+translated
    sdo_geometry = eval(translated)
    print "repr(ggg):"+repr(sdo_geometry)
    
    p=SdoGeometry(sdo_geometry) # the conversion
    
    print "dimensions:"+str(p.dimensions())
    print 'SDO_ORDINATES:'+str(p.SDO_ORDINATES)
    print 'particular:' + str(p.get_quadruplets())
    print 'to_geo: ' + simplejson.dumps(p.__geo_interface__) #printing geojson
    print 'wktfrom shapely: ' + asShape(p).wkt # printing wktgeometry, the numbers are too long. 
    print 'bounds shapely: ' + str(asShape(p).bounds) #determining MBR
    print 'this wkt:------' + str(p.wkt())

    cur.execute('select SDO_UTIL.TO_WKTGEOMETRY('+sel+') FROM DUAL') # the Oracle version of WKT for comparison
    wktstring = cur.fetchone()[0]
    print "wktfrom oralce:"+str(wktstring)
    print '-----\n'

    assert(str(wktstring)==p.wkt())
        
    
    
    
