
import logging
from pyvisdk.exceptions import InvalidArgumentError

########################################
# Automatically generated, do not edit.
########################################

log = logging.getLogger(__name__)

def InvalidDatastore(vim, *args, **kwargs):
    '''An InvalidDatastore exception is thrown if an operation fails because of a
    problem with the specified datastore. Typically, a subclass of this exception
    is thrown, indicating a problem such as an inaccessible datastore or an invalid
    datastore path.'''

    obj = vim.client.factory.create('{urn:vim25}InvalidDatastore')

    # do some validation checking...
    if (len(args) + len(kwargs)) < 6:
        raise IndexError('Expected at least 7 arguments got: %d' % len(args))

    required = [ 'datastore', 'name', 'dynamicProperty', 'dynamicType', 'faultCause',
        'faultMessage' ]
    optional = [  ]

    for name, arg in zip(required+optional, args):
        setattr(obj, name, arg)

    for name, value in kwargs.items():
        if name in required + optional:
            setattr(obj, name, value)
        else:
            raise InvalidArgumentError("Invalid argument: %s.  Expected one of %s" % (name, ", ".join(required + optional)))

    return obj
