#! python3
# -*- coding: utf-8 -*-
# ┌─────────────────────────────────────────────────────┐
# │ jsBuild 0.1 - A fiddler replacement in python       │
# ├─────────────────────────────────────────────────────┤
# │ Copyright (c) 2013 Amadeusguo                       │
# │ http://amadeus.herokuapp.com/                       │
# │ Licensed under the MIT license.                     │
# └─────────────────────────────────────────────────────┘

# Features:
# 1. build js ts css less jade
# 2. auto fix version number
# 3. play well with blackhole, zero configuration 
# 4. r.js dependency resolve
# 5. make inlines easy

# build.py: dev build
# build.py -p dist: make a release build
# build.py js/require.js css/reset.css: build a individual files

###############################################

import os
import sys
import argparse
import configparser
import logging

from meteor.scripts import build
from meteor.scripts import minify
from meteor.scripts import inline
from meteor.scripts import base64
from meteor.scripts import qrcode


# logging.basicConfig(format='%(levelname)s: %(message)s', level=logging.DEBUG)
logging.basicConfig(format='%(message)s', level=logging.DEBUG)

help_msg = '''
Meteor is a frontend toolbox.'

Usage:
    meteor build: build all
    meteor build js/a.js: build a single file

arguments:
    --profile

    meteor minify

    meteor inline

    meteor base64

    meteor qrcode

    meteor serve
'''

def main(argv=sys.argv):

    parser = argparse.ArgumentParser(prog='meteor',
            description=help_msg)
    subparser = parser.add_subparsers(title='subcommand',
            description='Following subcommands are available',
            dest='subcmd', help='Subcommand')

    def add_subcmd(name, config, help):
        parser = subparser.add_parser(name, help=help)
        config(parser)

    add_subcmd('build', build.config, help=build.help_msg)
    add_subcmd('minify', minify.config, help=minify.help_msg)
    add_subcmd('inline', inline.config, help=inline.help_msg)
    add_subcmd('base64', base64.config, help=base64.help_msg)
    add_subcmd('qrcode', qrcode.config, help=qrcode.help_msg)

    args = parser.parse_args()

    if args.subcmd:
        args.func(args)
    else:
        parser.print_help()
        sys.exit(1)

