# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class RedisResource(Resource):
    """A single redis item in List or Get Operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :ivar redis_version: Redis Version.
    :vartype redis_version: str
    :ivar provisioning_state: Redis instance provisioning status
    :vartype provisioning_state: str
    :ivar host_name: Redis host name
    :vartype host_name: str
    :ivar port: Redis non-ssl port
    :vartype port: int
    :ivar ssl_port: Redis ssl port
    :vartype ssl_port: int
    :param redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :type redis_configuration: dict
    :param enable_non_ssl_port: If the value is true, then the non-ssl redis
     server port (6379) will be enabled.
    :type enable_non_ssl_port: bool
    :param tenant_settings: tenantSettings
    :type tenant_settings: dict
    :param shard_count: The number of shards to be created on a Premium
     Cluster Cache.
    :type shard_count: int
    :param subnet_id: The full resource ID of a subnet in a virtual network
     to deploy the redis cache in. Example format:
     /subscriptions/{subid}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
    :type subnet_id: str
    :param static_ip: Required when deploying a redis cache inside an
     existing Azure Virtual Network.
    :type static_ip: str
    :param sku: What sku of redis cache to deploy.
    :type sku: :class:`Sku <azure.mgmt.redis.models.Sku>`
    """ 

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'redis_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'host_name': {'readonly': True},
        'port': {'readonly': True},
        'ssl_port': {'readonly': True},
        'subnet_id': {'pattern': '^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$'},
        'static_ip': {'pattern': '^\d+\.\d+\.\d+\.\d+$'},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'redis_version': {'key': 'properties.redisVersion', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'ssl_port': {'key': 'properties.sslPort', 'type': 'int'},
        'redis_configuration': {'key': 'properties.redisConfiguration', 'type': '{str}'},
        'enable_non_ssl_port': {'key': 'properties.enableNonSslPort', 'type': 'bool'},
        'tenant_settings': {'key': 'properties.tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'properties.shardCount', 'type': 'int'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'static_ip': {'key': 'properties.staticIP', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
    }

    def __init__(self, location, sku, tags=None, redis_configuration=None, enable_non_ssl_port=None, tenant_settings=None, shard_count=None, subnet_id=None, static_ip=None):
        super(RedisResource, self).__init__(location=location, tags=tags)
        self.redis_version = None
        self.provisioning_state = None
        self.host_name = None
        self.port = None
        self.ssl_port = None
        self.redis_configuration = redis_configuration
        self.enable_non_ssl_port = enable_non_ssl_port
        self.tenant_settings = tenant_settings
        self.shard_count = shard_count
        self.subnet_id = subnet_id
        self.static_ip = static_ip
        self.sku = sku
