from distutils.core import setup

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name = 'postalCodeCz',         # How you named your package folder (MyLib)
    packages = ['postalCodeCz'],   # Chose the same as "name"
    version = '0.3.1',      # Start with a small number and increase it with every change you make
    license='MIT',        # Chose a license from here: https://help.github.com/articles/licensing-a-repository
    description = 'Module returning Czech postal codes/cities based on input.',   # Give a short description about your library
    long_description=long_description,
    long_description_content_type="text/markdown",
    author = 'Jan Sindler',                   # Type in your name
    author_email = 'jansindl3r@gmail.com',      # Type in your E-Mail
    url = 'https://github.com/jansindl3r/postalCodeCz',   # Provide either the link to your github or to your website
    download_url = 'https://github.com/jansindl3r/postalCodeCz/archive/0.3.tar.gz',    # I explain this later on
    keywords = ['PostalCode', 'Czech', 'Czechia','PSC','Postal code','postalCodeCz'],   # Keywords that define your package best
    install_requires=[],
    classifiers=[
    'Development Status :: 4 - Beta',      # Chose either "3 - Alpha", "4 - Beta" or "5 - Production/Stable" as the current state of your package
    'Intended Audience :: Developers',      # Define that your audience are developers
    'Topic :: Software Development :: Build Tools',
    'License :: OSI Approved :: MIT License',   # Again, pick a license
    'Operating System :: OS Independent',
    'Programming Language :: Python :: 3',      #Specify which pyhton versions that you want to support
    'Programming Language :: Python :: 3.4',
    'Programming Language :: Python :: 3.5',
    'Programming Language :: Python :: 3.6',
    ],
)
