#jansindl3r@gmail.com
#====================
#module to return 'PSČ - postal code' or city name based on input code/name
#code dictionary updated on 6th november 2018

from re import sub
from difflib import get_close_matches

codes = {"10000": "Praha 10", "10100": "Praha 101", "10200": "Praha 102", "10300": "Praha 113", "10400": "Praha 114", "10600": "Praha 106", "10700": "Praha 112", "10800": "Praha 108", "10900": "Praha 111", "11000": "Praha 1", "11101": "Dolní Měcholupy", "11800": "Praha 011", "11900": "Praha 012", "12000": "Praha 2", "12800": "Praha 28", "13000": "Praha 3", "14000": "Praha 4", "14100": "Praha 41", "14200": "Praha 411", "14300": "Praha 412", "14700": "Praha 47", "14800": "Praha 414", "14900": "Praha 415", "15000": "Praha 5", "15200": "Praha 52", "15300": "Praha 512", "15400": "Praha 514", "15500": "Praha 515", "15521": "Praha 517", "15531": "Praha 511", "15600": "Praha 516", "15800": "Praha 58", "15900": "Praha 59", "16000": "Praha 6", "16100": "Praha 614", "16200": "Praha 616", "16300": "Praha 618", "16400": "Praha 619", "16500": "Praha 620", "16900": "Praha 69", "17000": "Praha 7", "17100": "Praha 71", "18000": "Praha 8", "18100": "Praha 81", "18200": "Praha 82", "18400": "Praha 84", "18600": "Praha 86", "19000": "Praha 9", "19011": "Praha 911", "19012": "Praha 912", "19014": "Praha 914", "19015": "Praha 915", "19016": "Praha 916", "19017": "Praha 917", "19300": "Praha 913", "19600": "Praha 96", "19700": "Praha 97", "19800": "Praha 98", "19900": "Praha 99","25001": "Brandýs nad Labem-Stará Boleslav 1", "25063": "Mratín", "25064": "Měšice u Prahy", "25065": "Líbeznice", "25066": "Zdiby", "25067": "Klecany", "25068": "Řež", "25069": "Vodochody", "25070": "Odolena Voda", "25072": "Kojetice u Prahy", "25073": "Jenštejn", "25074": "Výdejní místo Radonice", "25075": "Káraný", "25081": "Nehvizdy", "25082": "Úvaly", "25083": "Škvorec", "25084": "Sibřina", "25087": "Mochov", "25088": "Čelákovice", "25089": "Lázně Toušeň", "25090": "Jirny", "25091": "Zeleneč v Čechách", "25092": "Šestajovice", "25101": "Říčany u Prahy", "25162": "Mukařov", "25163": "Strančice", "25164": "Mnichovice", "25165": "Ondřejov", "25166": "Senohraby", "25167": "Pyšely", "25168": "Kamenice", "25169": "Velké Popovice", "25202": "Jíloviště", "25203": "Řitka", "25204": "Čisovice", "25205": "Hvozdnice", "25206": "Davle", "25207": "Štěchovice", "25208": "Slapy nad Vltavou", "25209": "Hradištko", "25210": "Mníšek pod Brdy", "25216": "Nučice", "25217": "Tachlovice", "25218": "Úhonice", "25219": "Rudná", "25225": "Jinočany", "25226": "Třebotov", "25228": "Černošice", "25229": "Dobřichovice", "25230": "Řevnice", "25231": "Všenory", "25241": "Dolní Břežany", "25242": "Jesenice u Prahy", "25243": "Průhonice", "25244": "Psáry", "25245": "Zvole u Prahy", "25246": "Vrané nad Vltavou", "25250": "Vestec", "25261": "Jeneč", "25262": "Horoměřice", "25263": "Roztoky u Prahy", "25264": "Velké Přílepy", "25265": "Tursko", "25266": "Libčice nad Vltavou", "25267": "Tuchoměřice", "25268": "Středokluky", "25281": "Petrov", "25282": "Kamenný Přívoz", "25301": "Hostivice", "25303": "Chýně", "25401": "Jílové u Prahy", "25601": "Benešov u Prahy", "25701": "Postupice", "25703": "Jankov", "25705": "Zvěstov", "25706": "Louňovice pod Blaníkem", "25708": "Načeradec", "25709": "Pravonín", "25721": "Poříčí nad Sázavou", "25722": "Čerčany", "25723": "Přestavlky u Čerčan", "25724": "Chocerady", "25726": "Divišov", "25728": "Chotýšany", "25741": "Týnec nad Sázavou", "25742": "Krhanice", "25744": "Netvořice", "25751": "Bystřice u Benešova", "25753": "Vrchotovy Janovice", "25755": "Maršovice", "25756": "Neveklov", "25763": "Trhový Štěpánov", "25764": "Zdislavice", "25765": "Čechtice", "25766": "Křivsoudov", "25768": "Dolní Kralovice", "25771": "Soutice", "25786": "Miličín", "25787": "Střezimíř", "25788": "Červený Újezd u Votic", "25789": "Heřmaničky", "25791": "Sedlec-Prčice 1", "25801": "Vlašim", "25901": "Votice", "26101": "Příbram 1", "26202": "Stará Huť u Dobříše", "26203": "Nový Knín", "26204": "Nová Ves pod Pleší", "26205": "Velká Lečice", "26206": "Korkyně", "26211": "Rosovice", "26212": "Obořiště", "26213": "Nečín", "26214": "Hřiměždice", "26215": "Borotice", "26221": "Obecnice", "26222": "Hluboš", "26223": "Jince", "26225": "Pičín", "26231": "Milín", "26232": "Pečice", "26241": "Bohutín", "26242": "Rožmitál pod Třemšínem", "26243": "Věšín", "26244": "Hvožďany", "26251": "Dublovice", "26252": "Vysoký Chlumec", "26255": "Petrovice u Sedlčan", "26256": "Krásná Hora nad Vltavou", "26261": "Višňová u Příbramě", "26262": "Dolní Hbity", "26263": "Kamýk nad Vltavou", "26272": "Březnice", "26281": "Tochovice", "26284": "Zalužany", "26285": "Drahenice", "26291": "Kosova Hora", "26293": "Nalžovice", "26301": "Dobříš", "26401": "Sedlčany", "26601": "Beroun 1", "26701": "Králův Dvůr u Berouna", "26703": "Hudlice", "26705": "Nižbor", "26706": "Hýskov", "26707": "Chyňava", "26711": "Vráž u Berouna", "26712": "Loděnice u Berouna", "26716": "Vysoký Újezd u Berouna", "26717": "Mořina", "26718": "Karlštejn", "26721": "Tmaň", "26722": "Suchomasty", "26723": "Lochovice", "26724": "Hostomice pod Brdy", "26725": "Osov", "26726": "Všeradice", "26727": "Liteň", "26728": "Svinaře", "26729": "Zadní Třebaň", "26741": "Kublov", "26742": "Broumy", "26743": "Bzová u Hořovic", "26751": "Zdice", "26753": "Žebrák", "26754": "Praskolesy", "26761": "Cerhovice", "26762": "Komárov u Hořovic", "26763": "Zaječov", "26764": "Olešná u Hořovic", "26801": "Hořovice", "26901": "Rakovník 1", "27001": "Kněževes u Rakovníka", "27002": "Kolešovice", "27004": "Hořesedly", "27006": "Kounov u Rakovníka", "27007": "Mutějovice", "27008": "Hředle", "27009": "Krupá", "27021": "Pavlíkov", "27023": "Křivoklát", "27024": "Zbečno", "27031": "Senomaty", "27032": "Oráčov", "27033": "Jesenice u Rakovníka", "27034": "Čistá u Rakovníka", "27035": "Petrovice u Rakovníka", "27036": "Lubná u Rakovníka", "27041": "Slabce", "27042": "Skryje u Rakovníka", "27051": "Lužná v Čechách", "27052": "Lišany", "27053": "Krušovice", "27054": "Řevničov", "27055": "Pochvalov", "27061": "Lány", "27062": "Rynholec", "27064": "Mšec", "27065": "Srbeč", "27101": "Nové Strašecí", "27201": "Kladno 1", "27203": "Kladno 3", "27204": "Kladno 4", "27301": "Kamenné Žehrovice", "27302": "Tuchlovice", "27303": "Stochov", "27304": "Kačice", "27305": "Smečno", "27306": "Libušín", "27307": "Vinařice u Kladna", "27308": "Pchery", "27309": "Kladno 7", "27321": "Hobšovice", "27322": "Hospozín", "27323": "Černuc", "27324": "Velvary", "27325": "Zvoleněves", "27326": "Olovnice", "27327": "Otvovice", "27328": "Zákolany", "27329": "Koleč", "27341": "Brandýsek", "27342": "Stehelčeves", "27343": "Buštěhrad", "27345": "Hřebeč", "27351": "Unhošť", "27353": "Hostouň u Prahy", "27354": "Lidice", "27361": "Velká Dobrá", "27362": "Družec", "27363": "Bratronice", "27364": "Doksy u Kladna", "27371": "Zlonice", "27372": "VM Šlapanice", "27373": "Vraný u Slaného", "27374": "Klobuky v Čechách", "27375": "Třebíz", "27376": "Pozdeň", "27377": "Malíkovice", "27378": "Řisuty", "27379": "Tuřany u Slaného", "27401": "Slaný 1", "27601": "Mělník 1", "27701": "Dolní Beřkovice", "27703": "Horní Počaply", "27704": "Cítov", "27705": "Spomyšl", "27706": "Lužec nad Vltavou", "27707": "Vraňany", "27708": "Ledčice", "27711": "Neratovice", "27713": "Kostelec nad Labem", "27714": "Dřísy", "27715": "Tišice", "27716": "Všetaty", "27721": "Liběchov", "27723": "Kokořín", "27724": "Vysoká u Mělníka", "27731": "Velký Borek", "27732": "Byšice", "27733": "Řepín", "27734": "Nebužely", "27735": "Mšeno u Mělníka", "27736": "Lobeč", "27737": "Chorušice", "27738": "Mělnické Vtelno", "27741": "Kly", "27742": "Obříství", "27743": "Chlumín", "27744": "Vojkovice u Kralup nad Vltavou", "27745": "Úžice u Kralup nad Vltavou", "27746": "Veltrusy", "27751": "Nelahozeves", "27752": "Nová Ves u Mělníka", "27801": "Kralupy nad Vltavou 1", "28002": "Kolín 2", "28101": "Velim", "28102": "Cerhenice", "28103": "Radim u Kolína", "28104": "Plaňany", "28106": "Vitice", "28107": "Svojšice u Kolína", "28121": "Červené Pečky", "28123": "Starý Kolín", "28125": "Konárovice", "28126": "Týnec nad Labem", "28127": "Krakovany v Čechách", "28128": "Radovesnice", "28129": "Žiželice nad Cidlinou", "28130": "Ohaře", "28141": "Ratboř", "28143": "Bečváry", "28144": "Zásmuky", "28146": "Horní Kruty", "28151": "Velký Osek", "28161": "Kouřim", "28162": "Oleška u Českého Brodu", "28163": "Kostelec nad Černými Lesy", "28166": "Jevany", "28167": "Stříbrná Skalice", "28171": "Rostoklaty", "28201": "Český Brod", "28401": "Kutná Hora 1", "28403": "Kutná Hora 3", "28404": "Kutná Hora 4", "28501": "Miskovice u Kutné Hory", "28502": "Suchdol u Kutné Hory", "28504": "Uhlířské Janovice", "28506": "Sázava", "28507": "Rataje nad Sázavou", "28509": "Kácov", "28510": "Čestín", "28511": "Nepoměřice", "28521": "Zbraslavice", "28522": "Zruč nad Sázavou 1", "28523": "Vlastějovice", "28525": "Bohdaneč u Zbraslavic", "28531": "Nové Dvory u Kutné Hory", "28532": "Hlízov", "28533": "Církvice u Kutné Hory", "28541": "Malešov", "28542": "Červené Janovice", "28543": "Paběnice", "28545": "Kluky u Kutné Hory", "28546": "Úmonín", "28547": "Křesetice", "28561": "Žleby", "28562": "Hostovlice u Čáslavě", "28563": "Tupadly", "28564": "Vlkaneč", "28565": "Zbýšov v Čechách", "28571": "Vrdy", "28572": "Bílé Podolí", "28573": "Horušice", "28574": "Záboří nad Labem", "28575": "Žehušice", "28576": "Chotusice", "28601": "Čáslav", "28802": "Nymburk 2", "28901": "Dymokury", "28902": "Kněžice u Městce Králové", "28903": "Městec Králové", "28904": "Opočnice", "28905": "Žehuň", "28906": "Sány", "28907": "Libice nad Cidlinou", "28908": "Běrunice", "28911": "Pečky", "28912": "Sadská", "28913": "Zvěřínek", "28914": "Poříčany", "28915": "Kounice", "28916": "Přerov nad Labem", "28917": "Semice", "28921": "Kostomlaty nad Labem", "28922": "Lysá nad Labem", "28923": "Milovice nad Labem 1", "28924": "Milovice nad Labem 3", "28925": "Straky", "28926": "Stará Lysá", "28931": "Bobnice", "28932": "Oskořínek", "28933": "Křinec", "28934": "Rožďalovice", "28935": "Košík", "28936": "Mcely", "28937": "Loučeň", "28941": "Pňov", "29001": "Poděbrady 1", "29301": "Mladá Boleslav 1", "29306": "Kosmonosy", "29307": "Josefův Důl u Mladé Boleslavě", "29401": "Bakov nad Jizerou", "29402": "Kněžmost", "29403": "Obruby", "29404": "Dolní Bousov", "29405": "Dlouhá Lhota u Mladé Boleslavě", "29406": "Březno u Mladé Boleslavě", "29411": "Loukov u Mnichova Hradiště", "29412": "Žďár u Mnichova Hradiště", "29413": "Mohelnice nad Jizerou", "29414": "Jivina u Mnichova Hradiště", "29415": "Klášter Hradiště nad Jizerou", "29421": "Bělá pod Bezdězem", "29423": "Čistá u Mladé Boleslavě", "29424": "Březovice u Mladé Boleslavě", "29425": "Katusice", "29426": "Skalsko", "29427": "Velké Všelisy", "29428": "Chotětov", "29429": "Bezno", "29430": "Dolní Cetno", "29431": "Krnsko", "29441": "Dobrovice", "29442": "Luštěnice", "29443": "Čachovice u Mladé Boleslavě", "29445": "Jabkenice", "29446": "Semčice", "29447": "Ledce u Mladé Boleslavi", "29448": "Domousnice", "29471": "Benátky nad Jizerou 1", "29473": "Brodce nad Jizerou", "29474": "Předměřice nad Jizerou", "29475": "Sojovice", "29476": "Kostelní Hlavno", "29477": "Mečeříž", "29478": "Dolní Slivno", "29479": "Kropáčova Vrutice", "29501": "Mnichovo Hradiště","30100": "Plzeň 1", "31200": "Plzeň 12", "31600": "Plzeň 16", "31800": "Plzeň 18", "32100": "Plzeň 21", "32200": "Plzeň 22", "32300": "Plzeň 23", "32600": "Plzeň 26", "33001": "Kyšice", "33002": "Dýšina", "33003": "Chrást u Plzně", "33005": "Dobříč", "33007": "Druztová", "33008": "Zruč-Senec", "33011": "Třemošná", "33012": "Horní Bříza", "33013": "Trnová u Plzně", "33014": "Ledce u Plzně", "33016": "Všeruby u Plzně", "33017": "Chotíkov", "33021": "Líně", "33022": "Zbůch", "33023": "Nýřany", "33024": "Heřmanova Huť", "33025": "Blatnice u Plzně", "33026": "Tlučná", "33027": "Vejprnice", "33032": "Kozolupy", "33033": "Město Touškov", "33035": "Líšťany", "33036": "Pernarec", "33038": "Úněšov", "33040": "Úterý", "33041": "Bezvěrov", "33101": "Plasy", "33141": "Kralovice", "33144": "Kožlany", "33151": "Kaznějov", "33152": "Dolní Bělá", "33162": "Manětín", "33165": "Žihle", "33201": "Tymákov", "33202": "Starý Plzenec", "33203": "Šťáhlavy", "33204": "Nezvěstice", "33205": "Chválenice", "33207": "Výdejní místo Střížovice", "33209": "Štěnovice", "33211": "Hradec u Stoda", "33214": "Chotěšov", "33301": "Stod", "33401": "Přeštice", "33441": "Dobřany", "33442": "Chlumčany u Přeštic", "33443": "Dnešice", "33444": "Dolní Lukavice", "33452": "Merklín u Přeštic", "33453": "Roupov", "33454": "Výdejní místo Lužany u Přeštic", "33455": "Horšice", "33501": "Nepomuk 1", "33503": "Nepomuk 3", "33541": "Vrčeň", "33543": "Dožice", "33544": "Kasejovice", "33546": "Oselce", "33547": "Nekvasovy", "33551": "Měcholupy u Blovic", "33554": "Žinkovy", "33555": "Neurazy", "33561": "Spálené Poříčí", "33563": "Nové Mitrovice", "33564": "Čížkov u Blovic", "33601": "Blovice", "33701": "Rokycany 1", "33801": "Holoubkov", "33805": "Mýto v Čechách", "33806": "Cheznovice", "33808": "Zbiroh", "33821": "Osek u Rokycan", "33822": "Volduchy", "33824": "Břasy 1", "33828": "Radnice u Rokycan", "33841": "Klabava", "33842": "Hrádek u Rokycan", "33843": "Mirošov 1", "33844": "Dobřív", "33845": "Strašice", "33901": "Klatovy 1", "34004": "Železná Ruda", "34012": "Švihov", "34021": "Janovice nad Úhlavou", "34022": "Nýrsko", "34034": "Plánice", "34101": "Horažďovice", "34142": "Kolinec", "34192": "Kašperské Hory", "34201": "Sušice 1", "34401": "Domažlice 1", "34501": "Mrákov", "34502": "Kout na Šumavě", "34506": "Kdyně", "34507": "Všeruby u Kdyně", "34509": "Pocinovice", "34521": "Meclov", "34522": "Poběžovice", "34525": "Hostouň u Horšovského Týna", "34526": "Bělá nad Radbuzou", "34532": "Česká Kubice", "34533": "Trhanov", "34534": "Klenčí pod Čerchovem", "34535": "Postřekov", "34543": "Koloveč", "34545": "Blížejov", "34561": "Staňkov", "34562": "Holýšov", "34601": "Horšovský Týn", "34701": "Tachov 1", "34801": "Staré Sedliště", "34802": "Bor u Tachova", "34806": "Přimda", "34813": "Chodová Planá", "34815": "Planá u Mariánských Lázní", "34901": "Stříbro", "34952": "Konstantinovy Lázně", "34953": "Bezdružice", "34958": "Černošín", "34961": "Kladruby u Stříbra", "35002": "Cheb 2", "35101": "Františkovy Lázně", "35124": "Hranice u Aše", "35131": "Libá", "35132": "Hazlov", "35134": "Skalná", "35135": "Plesná u Chebu", "35137": "Luby u Chebu", "35201": "Aš 1", "35301": "Mariánské Lázně 1", "35491": "Lázně Kynžvart", "35493": "Dolní Žandov", "35601": "Sokolov 1", "35604": "Dolní Rychnov", "35701": "Rotava 1", "35703": "Svatava", "35707": "Oloví", "35708": "Krajková", "35709": "Habartov", "35731": "Horní Slavkov", "35733": "Loket", "35734": "Nové Sedlo u Lokte", "35735": "Chodov u Karlových Var 1", "35751": "Kynšperk nad Ohří", "35755": "Bukovany u Sokolova", "35801": "Kraslice", "36001": "Karlovy Vary 1", "36004": "Karlovy Vary 4", "36005": "Karlovy Vary 5", "36006": "Karlovy Vary 6", "36007": "Karlovy Vary 7", "36010": "Karlovy Vary 10", "36017": "Karlovy Vary 17", "36018": "Karlovy Vary 18", "36221": "Nejdek 1", "36222": "Nejdek 2", "36225": "Nová Role", "36233": "Hroznětín", "36234": "Merklín u Karlových Var", "36235": "Abertamy", "36236": "Pernink", "36251": "Jáchymov", "36262": "Boží Dar", "36263": "Dalovice", "36272": "Kyselka", "36273": "Vojkovice nad Ohří", "36301": "Ostrov nad Ohří", "36401": "Toužim", "36452": "Žlutice", "36453": "Chyše", "36461": "Teplá u Toužimě", "36464": "Bečov nad Teplou", "36471": "Bochov", "37001": "České Budějovice 1", "37004": "České Budějovice 4", "37005": "České Budějovice 5", "37006": "České Budějovice 6", "37007": "České Budějovice 7", "37008": "České Budějovice 8", "37010": "České Budějovice 10", "37011": "České Budějovice 11", "37301": "Temelín", "37302": "Neznašov", "37304": "Chrášťany u Týna nad Vltavou", "37305": "Temelín-elektrárna", "37311": "Ledenice", "37312": "Borovany", "37314": "Komařice", "37315": "Nová Ves u Českých Budějovic", "37316": "Dobrá Voda u Českých Budějovic", "37321": "Slavče", "37322": "Ločenice", "37323": "Svatý Jan nad Malší", "37324": "Římov", "37331": "Olešnice u Českých Budějovic", "37332": "Jílovice u Trhových Svin", "37333": "Nové Hrady v jižních Čechách", "37335": "Horní Stropnice", "37336": "Rychnov u Nových Hradů", "37341": "Hluboká nad Vltavou", "37343": "Výdejní místo Purkarec", "37344": "Zliv", "37346": "Pištín", "37347": "Sedlec u Českých Budějovic", "37348": "Dívčice", "37349": "Mydlovary", "37350": "Olešník", "37351": "Dříteň", "37361": "Hrdějovice", "37362": "Chotýčany u Českých Budějovic", "37363": "Ševětín", "37364": "Dynín", "37365": "Dolní Bukovsko", "37366": "Žimutice", "37367": "Borek", "37371": "Rudolfov", "37372": "Lišov u Českých Budějovic", "37373": "Štěpánovice u Českých Budějovic", "37381": "Kamenný Újezd", "37382": "Boršov nad Vltavou", "37384": "Dubné", "37401": "Trhové Sviny", "37501": "Týn nad Vltavou 1", "37701": "Jindřichův Hradec 1", "37801": "Lásenice", "37802": "Stráž nad Nežárkou", "37803": "Majdalena", "37804": "Chlum u Třeboně", "37806": "Suchdol nad Lužnicí", "37807": "Rapšach", "37808": "Dvory nad Lužnicí", "37809": "Nová Ves nad Lužnicí", "37810": "České Velenice", "37816": "Lomnice nad Lužnicí", "37817": "Novosedly nad Nežárkou", "37818": "Výdejní místo Stříbřec", "37821": "Kardašova Řečice", "37824": "Výdejní místo Pluhův Žďár", "37825": "Deštná u Jindřichova Hradce", "37826": "Lodhéřov", "37831": "Horní Pěna", "37832": "Číměř", "37833": "Nová Bystřice", "37841": "Jarošov nad Nežárkou", "37842": "Nová Včelnice", "37843": "Výdejní místo Horní Radouň", "37846": "Roseč", "37852": "Blažejov", "37853": "Strmilov", "37855": "Výdejní místo Popelín", "37856": "Studená", "37861": "Člunek", "37862": "Kunžak", "37871": "Staré Hobzí", "37872": "Písečné", "37873": "Dešná u Dačic", "37881": "Slavonice", "37882": "Staré Město pod Landštejnem", "37883": "Český Rudolec", "37891": "Budíškovice", "37892": "Budeč", "37901": "Třeboň", "38001": "Dačice", "38101": "Český Krumlov 1", "38201": "Dolní Třebonín", "38202": "Zlatá Koruna", "38203": "Křemže", "38206": "Brloh", "38208": "Chvalšiny", "38211": "Větřní", "38216": "Světlík", "38218": "Rožmberk nad Vltavou", "38221": "Kájov", "38222": "Hořice na Šumavě", "38223": "Černá v Pošumaví", "38226": "Horní Planá", "38229": "Polná na Šumavě", "38232": "Velešín", "38241": "Kaplice 1", "38242": "Kaplice 2", "38272": "Dolní Dvořiště", "38273": "Vyšší Brod", "38276": "Loučovice", "38278": "Lipno nad Vltavou", "38279": "Frymburk", "38281": "Besednice", "38282": "Benešov nad Černou", "38283": "Pohorská Ves", "38291": "Malonty", "38292": "Rožmitál na Šumavě", "38293": "Horní Dvořiště", "38301": "Prachatice", "38401": "Nebahovy", "38402": "Lhenice", "38403": "Ktiš", "38404": "Chroboly", "38411": "Netolice", "38421": "Husinec", "38422": "Vlachovo Březí", "38425": "Dub u Prachatic", "38426": "Strunkovice nad Blanicí", "38427": "Vitějovice", "38432": "Lažiště", "38433": "Záblatí u Prachatic", "38441": "Zbytiny", "38442": "Lenora", "38443": "Strážný", "38444": "Stožec", "38451": "Volary", "38462": "Nová Pec", "38471": "Šumavské Hoštice", "38472": "Zdíkov", "38473": "Stachy", "38481": "Čkyně", "38486": "Vacov", "38491": "Horní Vltavice", "38492": "Borová Lada", "38493": "Kvilda", "38501": "Vimperk", "38601": "Strakonice 1", "38701": "Volyně", "38706": "Malenice nad Volyňkou", "38711": "Katovice", "38715": "Střelské Hoštice", "38716": "Volenice", "38719": "Čestice", "38731": "Radomyšl", "38732": "Sedlice u Blatné", "38733": "Kadov u Blatné", "38734": "Záboří u Blatné", "38735": "Doubravice u Strakonic", "38736": "Mečichov", "38737": "Třebohostice", "38742": "Lnáře", "38743": "Bělčice", "38751": "Štěkeň", "38752": "Cehnice", "38756": "Čepřovice", "38771": "Číčenice", "38772": "Libějovice", "38773": "Bavorov", "38775": "Skočice", "38801": "Blatná", "38901": "Vodňany", "39001": "Tábor 1", "39002": "Tábor 2", "39003": "Tábor 3", "39005": "Tábor 5", "39101": "Sezimovo Ústí 1", "39102": "Sezimovo Ústí 2", "39111": "Planá nad Lužnicí", "39116": "Myslkovice", "39117": "Košice u Soběslavě", "39118": "Choustník", "39120": "Radenín", "39121": "Turovec", "39126": "Tučapy u Soběslavě", "39127": "Dírná", "39131": "Dražice", "39132": "Výdejní místo Božejovice", "39133": "Jistebnice", "39135": "Borotín u Tábora", "39136": "Sudoměřice u Tábora", "39137": "Chotoviny", "39142": "Ratibořské Hory", "39143": "Mladá Vožice", "39152": "Smilovy Hory", "39153": "Vodice u Tábora", "39155": "Chýnov", "39156": "Tábor 4", "39161": "Opařany", "39162": "Stádlec", "39165": "Bechyně", "39171": "Březnice u Bechyně", "39172": "Sudoměřice u Bechyně", "39173": "Hlavatce", "39174": "Želeč u Tábora", "39175": "Malšice", "39176": "Slapy u Tábora", "39181": "Veselí nad Lužnicí 1", "39201": "Soběslav", "39301": "Pelhřimov", "39401": "Rynárec", "39403": "Horní Cerekev", "39404": "Nový Rychnov", "39405": "Vyskytná u Pelhřimova", "39409": "Kojčice", "39411": "Cetoraz", "39412": "Obrataň", "39413": "Kámen u Pacova", "39414": "Leskovice", "39415": "Nová Cerekev", "39421": "Hořepník", "39422": "Košetice", "39424": "Křešín u Pacova", "39426": "Lukavec u Pacova", "39427": "Vyklantice", "39428": "Velká Chyška", "39443": "Mladé Bříště", "39444": "Želiv", "39445": "Křelovice u Pelhřimova", "39446": "Červená Řečice", "39451": "Kaliště", "39452": "Kejžlice", "39456": "Senožaty", "39459": "Koberovice", "39461": "Božejov", "39462": "Libkova Voda", "39463": "Častrov", "39464": "Počátky", "39468": "Žirovnice", "39470": "Kamenice nad Lipou", "39491": "Bohdalín", "39492": "Mnich", "39493": "Chválkov u Kamenice nad Lipou", "39494": "Černovice u Tábora", "39495": "Křeč", "39496": "Těmice u Kamenice nad Lipou", "39501": "Pacov", "39601": "Humpolec", "39701": "Písek 1", "39801": "Mirotice", "39804": "Čimelice", "39806": "Mirovice", "39807": "Orlík nad Vltavou", "39811": "Protivín", "39815": "Tálín", "39816": "Albrechtice nad Vltavou", "39817": "Chřešťovice", "39818": "Záhoří u Písku", "39819": "Kluky u Písku", "39821": "Kestřany", "39822": "Ražice", "39831": "Čížová", "39832": "Vráž u Písku", "39833": "Ostrovec", "39834": "Kučeř", "39835": "Oslov", "39842": "Veselíčko u Milevska", "39843": "Bernartice u Milevska", "39847": "Slabčice", "39848": "Jetětice", "39851": "Sepekov", "39852": "Nadějkov", "39853": "Chyšky", "39855": "Kovářov", "39858": "Kostelec nad Vltavou", "39859": "Hrejkovice", "39901": "Milevsko 1","40001": "Ústí nad Labem 1", "40002": "Ústí nad Labem 2", "40003": "Ústí nad Labem 3", "40004": "Trmice", "40007": "Ústí nad Labem 7", "40010": "Ústí nad Labem 10", "40011": "Ústí nad Labem 11", "40301": "Dolní Zálezly", "40302": "Výdejní místo Sebuzín", "40313": "Řehlovice", "40317": "Chabařovice", "40321": "Ústí nad Labem 17", "40322": "Ústí nad Labem 20", "40323": "Velké Březno", "40327": "Malečov", "40331": "Ústí nad Labem 16", "40332": "Povrly", "40334": "Velké Chvojno", "40335": "Libouchec", "40336": "Tisá", "40337": "Petrovice u Ústí nad Labem", "40338": "Telnice", "40339": "Chlumec u Ústí nad Labem", "40340": "Ústí nad Labem 19", "40502": "Děčín 2", "40505": "Děčín 5", "40701": "Jílové u Děčína", "40702": "Modrá u Děčína", "40703": "Dobkovice u Děčína", "40711": "Děčín 9", "40713": "Ludvíkovice", "40714": "Arnoltice u Děčína", "40715": "Srbská Kamenice", "40716": "Jetřichovice u Děčína", "40717": "Hřensko", "40721": "Česká Kamenice", "40722": "Benešov nad Ploučnicí", "40723": "Františkov nad Ploučnicí", "40724": "Valkeřice", "40725": "Verneřice", "40729": "Velká Bukovina u Děčína", "40741": "Dobrná", "40742": "Markvartice u Děčína", "40744": "Chřibská", "40745": "Kytlice", "40746": "Krásná Lípa u Rumburka", "40747": "Varnsdorf 1", "40751": "Rybniště", "40752": "Varnsdorf 3", "40753": "Jiříkov", "40755": "Dolní Podluží", "40756": "Jiřetín pod Jedlovou", "40757": "Horní Podluží", "40760": "Výdejní místo Brtníky", "40761": "Staré Křečany", "40777": "Šluknov", "40778": "Velký Šenov", "40779": "Mikulášovice", "40780": "Vilémov u Šluknova", "40781": "Lipová u Šluknova", "40782": "Dolní Poustevna", "40784": "Lobendava", "40801": "Rumburk", "41002": "Lovosice 2", "41101": "Žalhostice", "41103": "Libochovany", "41108": "Štětí", "41111": "Sulejovice", "41112": "Čížkovice", "41113": "Třebenice", "41114": "Výdejní místo Vlastislav", "41115": "Třebívlice", "41116": "Klapý", "41117": "Libochovice", "41118": "Budyně nad Ohří", "41119": "Mšené-lázně", "41120": "Ředhošť", "41121": "Vrbičany", "41131": "Velemín", "41132": "Milešov u Lovosic", "41133": "Prackovice nad Labem", "41141": "Žitenice", "41142": "Ploskovice", "41145": "Úštěk", "41146": "Liběšice u Litoměřic", "41147": "Polepy", "41148": "Křešice", "41155": "Terezín", "41156": "Bohušovice nad Ohří", "41162": "Sukorady", "41164": "Vrbice u Roudnice nad Labem", "41171": "Chodouny", "41172": "Hoštka u Roudnice nad Labem", "41173": "Chcebuz", "41174": "Snědovice", "41181": "Brozany nad Ohří", "41182": "Doksany", "41183": "Hrobce", "41184": "Straškov-Vodochody", "41185": "Horní Beřkovice", "41186": "Bechlín", "41187": "Krabčice u Roudnice nad Labem", "41201": "Litoměřice 1", "41301": "Roudnice nad Labem", "41501": "Teplice 1", "41503": "Teplice 3", "41510": "Teplice 10", "41701": "Dubí u Teplic 1", "41702": "Dubí", "41703": "Pozorka", "41704": "Hrob", "41705": "Osek u Duchcova", "41712": "Proboštov u Teplic", "41713": "Modlany", "41722": "Háj u Duchcova", "41723": "Košťany u Teplic", "41724": "Oldřichov", "41725": "Lahošť", "41731": "Novosedlice", "41741": "Krupka 3", "41742": "Krupka 1", "41752": "Hostomice nad Bílinou", "41753": "Světec", "41754": "Kostomlaty pod Milešovkou", "41757": "Hrobčice", "41761": "Bystřany", "41762": "Rtyně nad Bílinou", "41763": "Žalany", "41765": "Ohníč", "41771": "Zabrušany", "41772": "Ledvice", "41781": "Moldava", "41801": "Bílina 1", "41804": "Bílina 4", "41901": "Duchcov", "43001": "Chomutov 1", "43003": "Chomutov 3", "43004": "Chomutov 4", "43101": "Spořice", "43102": "Zelená", "43111": "Jirkov 1", "43114": "Strupčice", "43115": "Výdejní místo Vrskmaň", "43121": "Boleboř", "43132": "Výdejní místo Kalek", "43141": "Údlice", "43143": "Hrušovany u Chomutova", "43144": "Droužkovice", "43145": "Březno u Chomutova", "43151": "Klášterec nad Ohří 1", "43153": "Pětipsy", "43154": "Vilémov u Kadaně", "43155": "Radonice u Kadaně", "43156": "Mašťov", "43157": "Chbany", "43158": "Místo", "43159": "Vysoká Pec", "43163": "Perštejn", "43182": "Hora Svatého Šebestiána", "43183": "Výdejní místo Výsluní", "43184": "Výdejní místo Měděnec", "43186": "Kovářská", "43191": "Vejprty", "43201": "Kadaň 1", "43401": "Most 1", "43501": "Havraň", "43502": "Most 9", "43511": "Lom u Mostu 1", "43513": "Meziboří u Litvínova", "43521": "Obrnice", "43522": "Braňany", "43524": "Lužice u Mostu", "43526": "Bečov u Mostu", "43532": "Mariánské Radčice", "43533": "Louka u Litvínova", "43542": "Litvínov 8", "43543": "Horní Jiřetín", "43545": "Nová Ves v Horách", "43546": "Hora Svaté Kateřiny", "43547": "Brandov", "43601": "Litvínov 1", "43603": "Litvínov 3", "43801": "Žatec 1", "43901": "Černčice", "43902": "Cítoliby", "43903": "Chlumčany u Loun", "43904": "Hříškov", "43905": "Panenský Týnec", "43906": "Vrbno nad Lesy", "43907": "Peruc", "43908": "Pátek", "43909": "Slavětín nad Ohří", "43914": "Smolnice", "43915": "Vinařice u Loun", "43921": "Koštice nad Ohří", "43922": "Chožov", "43923": "Lenešice", "43924": "Raná u Loun", "43926": "Libčeves", "43931": "Měcholupy u Žatce", "43942": "Postoloprty", "43949": "Staňkovice u Žatce", "43963": "Liběšice u Žatce", "43965": "Hřivice", "43967": "Ročov", "43968": "Domoušice", "43969": "Tuchořice", "43971": "Nepomyšl", "43972": "Krásný Dvůr", "43975": "Libočany", "43981": "Kryry", "43982": "Vroutek", "43983": "Lubenec", "43984": "Blatno u Podbořan", "43985": "Petrohrad", "43986": "Strojetice", "43987": "Očihov", "43988": "Blšany", "44001": "Louny 1", "44101": "Podbořany", "46001": "Liberec 1", "46005": "Liberec 5", "46006": "Liberec 6", "46007": "Liberec 7", "46008": "Liberec 8", "46010": "Liberec 10", "46014": "Liberec 14", "46015": "Liberec 15", "46303": "Stráž nad Nisou", "46311": "Liberec 30", "46312": "Liberec 25", "46331": "Chrastava", "46334": "Hrádek nad Nisou", "46342": "Hodkovice nad Mohelkou", "46343": "Český Dub", "46344": "Sychrov", "46345": "Pěnčín u Liberce", "46346": "Příšovice", "46348": "Všelibice", "46352": "Osečná", "46353": "Křižany", "46362": "Hejnice", "46365": "Nové Město pod Smrkem", "46373": "Habartice u Frýdlantu", "46401": "Frýdlant v Čechách", "46601": "Jablonec nad Nisou 1", "46602": "Jablonec nad Nisou 2", "46604": "Jablonec nad Nisou 4", "46605": "Jablonec nad Nisou 5", "46606": "Jablonec nad Nisou 6", "46801": "Jablonec nad Nisou 8", "46802": "Rychnov u Jablonce nad Nisou", "46803": "Rádlo", "46804": "Jablonec nad Nisou 7", "46811": "Janov nad Nisou", "46812": "Bedřichov", "46821": "Bratříkov", "46822": "Železný Brod", "46824": "Držkov", "46825": "Zásada", "46826": "Huť", "46827": "Nová Ves nad Nisou", "46833": "Jenišovice u Jablonce nad Nisou", "46841": "Tanvald", "46843": "Albrechtice v Jizerských horách", "46844": "Josefův Důl", "46845": "Velké Hamry", "46846": "Plavy", "46847": "Zlatá Olešnice", "46848": "Výdejní místo Příchovice", "46849": "Kořenov", "46850": "Výdejní místo Polubný", "46851": "Smržovka", "46861": "Desná v Jizerských horách", "46871": "Lučany nad Nisou", "47001": "Česká Lípa 1", "47002": "Česká Lípa 2", "47006": "Česká Lípa 6", "47101": "Zahrádky u České Lípy", "47102": "Výdejní místo Stvolínky", "47103": "Kravaře u České Lípy", "47104": "Blíževedly", "47105": "Valteřice", "47106": "Horní Police", "47107": "Žandov u České Lípy", "47108": "Jezvé", "47111": "Horní Libchava u České Lípy", "47112": "Volfartice", "47113": "Nový Oldřichov", "47114": "Kamenický Šenov", "47115": "Prysk", "47116": "Polevsko", "47117": "Skalice u České Lípy", "47118": "Pihel", "47121": "Dobranov", "47123": "Zákupy", "47124": "Mimoň", "47125": "Jablonné v Podještědí", "47126": "Dubnice pod Ralskem", "47127": "Stráž pod Ralskem", "47128": "Hamr u České Lípy", "47129": "Brniště", "47141": "Dubá", "47151": "Svor", "47152": "Sloup v Čechách", "47153": "Svojkov", "47154": "Cvikov", "47155": "Kunratice u Cvikova", "47156": "Mařenice", "47157": "Krompach v Čechách", "47158": "Lindava", "47161": "Jestřebí", "47162": "Okna", "47163": "Staré Splavy", "47167": "Provodín", "47201": "Doksy", "47301": "Nový Bor","50002": "Hradec Králové 2", "50003": "Hradec Králové 3", "50004": "Hradec Králové 4", "50006": "Hradec Králové 6", "50008": "Hradec Králové 8", "50009": "Hradec Králové 9", "50011": "Hradec Králové 11", "50012": "Hradec Králové 12", "50301": "Hradec Králové 16", "50302": "Předměřice nad Labem", "50303": "Smiřice", "50304": "Černožice nad Labem", "50305": "Výdejní místo Lužany", "50306": "Hořiněves", "50311": "Hradec Králové 15", "50312": "Všestary", "50313": "Dohalice", "50314": "Stračov", "50315": "Nechanice", "50316": "Dolní Přím", "50321": "Stěžery", "50322": "Libčany", "50323": "Výdejní místo Boharyně", "50324": "Kratonohy", "50325": "Dobřenice", "50326": "Osice", "50327": "Lhota pod Libčany", "50331": "Vysoká nad Labem", "50332": "Hradec Králové 22", "50333": "Praskačka", "50341": "Hradec Králové 7", "50343": "Černilov", "50344": "Libřice", "50346": "Třebechovice pod Orebem", "50351": "Chlumec nad Cidlinou", "50352": "Skřivany u Nového Bydžova", "50353": "Smidary", "50354": "Ohnišťany", "50355": "Petrovice u Nového Bydžova", "50356": "Hlušice", "50357": "Starý Bydžov", "50361": "Lovčice u Nového Bydžova", "50362": "Lužec nad Cidlinou", "50363": "Nepolisy", "50364": "Měník", "50365": "Kosičky", "50366": "Káranice", "50401": "Nový Bydžov", "50601": "Jičín 1", "50702": "Žeretice", "50703": "Vysoké Veselí", "50704": "Třtěnice", "50705": "Konecchlumí", "50706": "Lužany u Jičína", "50707": "Úlibice", "50711": "Valdice", "50712": "Radim u Jičína", "50713": "Železnice", "50715": "Libuň", "50721": "Veliš", "50722": "Střevač", "50723": "Libáň", "50724": "Dětenice", "50731": "Jičíněves", "50732": "Kopidlno", "50733": "Vršce", "50734": "Žlunice", "50742": "Markvartice u Sobotky", "50743": "Sobotka", "50744": "Libošovice", "50745": "Mladějov v Čechách", "50752": "Ostroměř", "50753": "Chomutice u Hořic v Podkrkonoší", "50754": "Podhorní Újezd", "50758": "Mlázovice", "50759": "Výdejní místo Šárovcova Lhota", "50771": "Miletín", "50773": "Dobrá Voda u Hořic", "50777": "Cerekvice nad Bystřicí", "50781": "Lázně Bělohrad", "50782": "Pecka", "50791": "Stará Paka", "50792": "Úbislavice", "50801": "Hořice v Podkrkonoší", "50901": "Nová Paka", "51101": "Turnov 1", "51201": "Slaná u Semil", "51202": "Košťálov", "51203": "Libštát", "51204": "Mříčná", "51206": "Benešov u Semil", "51211": "Vysoké nad Jizerou", "51212": "Jesenný", "51213": "Bozkov", "51231": "Roztoky u Jilemnice", "51232": "Martinice v Krkonoších", "51233": "Studenec u Horek", "51234": "Horka u Staré Paky", "51235": "Čistá u Horek", "51236": "Horní Branná", "51237": "Benecko", "51238": "Vítkovice v Krkonoších", "51241": "Víchová nad Jizerou", "51242": "Poniklá", "51243": "Jablonec nad Jizerou", "51244": "Rokytnice nad Jizerou 1", "51245": "Rokytnice nad Jizerou 3", "51246": "Harrachov v Krkonoších", "51247": "Paseky nad Jizerou", "51251": "Lomnice nad Popelkou", "51252": "Veselá u Semil", "51253": "Tatobity", "51261": "Přepeře", "51263": "Rovensko pod Troskami", "51264": "Vyskeř", "51265": "Všeň", "51271": "Nová Ves nad Popelkou", "51301": "Semily", "51401": "Jilemnice", "51601": "Rychnov nad Kněžnou", "51603": "Lukavice", "51701": "Solnice", "51702": "Kvasiny", "51703": "Skuhrov nad Bělou", "51704": "Černíkovice", "51711": "Javornice", "51712": "Liberk", "51721": "Týniště nad Orlicí", "51722": "Albrechtice nad Orlicí", "51723": "Žďár nad Orlicí", "51724": "Borohrádek", "51725": "Čermná nad Orlicí", "51731": "Bolehošť", "51732": "Přepychy", "51733": "Trnov u Dobrušky", "51734": "Voděrady u Rychnova nad Kněžnou", "51735": "Lično", "51736": "Olešnice u Rychnova nad Kněžnou", "51741": "Kostelec nad Orlicí", "51742": "Doudleby nad Orlicí", "51743": "Potštejn", "51745": "Chleny", "51750": "Častolovice", "51754": "Vamberk", "51755": "Rybná nad Zdobnicí", "51756": "Slatina nad Zdobnicí", "51757": "Pěčín u Rychnova nad Kněžnou", "51761": "Rokytnice v Orlických horách", "51764": "Orlické Záhoří", "51771": "České Meziříčí", "51772": "Jílovice u Dobrušky", "51773": "Opočno", "51783": "Olešnice v Orlických horách", "51784": "Ohnišov", "51791": "Deštné v Orlických horách", "51792": "Kounov u Dobrušky", "51793": "Dobré", "51801": "Dobruška", "51803": "Podbřezí", "53002": "Pardubice 2", "53003": "Pardubice 3", "53006": "Pardubice 6", "53009": "Pardubice 9", "53012": "Pardubice 12", "53301": "Pardubice 21", "53303": "Dašice v Čechách", "53304": "Sezemice", "53305": "Dříteč", "53311": "Zdechovice", "53312": "Chvaletice", "53313": "Řečany nad Labem", "53314": "Kladruby nad Labem", "53315": "Hlavečník", "53316": "Vápno", "53321": "Vysoké Chvojno", "53322": "Býšť", "53332": "Čepí", "53333": "Pardubice 23", "53341": "Lázně Bohdaneč", "53342": "Živanice", "53343": "Rohovládova Bělá", "53344": "Staré Ždánice", "53345": "Opatovice nad Labem", "53351": "Pardubice 17", "53352": "Staré Hradiště u Pardubic", "53353": "Pardubice 19", "53354": "Rybitví", "53361": "Choltice", "53362": "Svojšice u Přelouče", "53363": "Turkovice u Přelouče", "53364": "Lipoltice", "53371": "Dolní Roveň", "53372": "Moravany u Holic", "53373": "Uhersko", "53374": "Horní Jelení", "53375": "Dolní Ředice", "53401": "Holice v Čechách", "53501": "Přelouč", "53701": "Chrudim 1", "53703": "Chrudim 3", "53705": "Chrudim 5", "53801": "Bylany", "53802": "Morašice u Chrudimě", "53803": "Heřmanův Městec", "53804": "Prachovice", "53805": "Seč 3", "53807": "Seč 1", "53821": "Slatiňany", "53823": "Licibořice", "53824": "Svídnice u Chrudimě", "53825": "Nasavrky", "53826": "Bojanov", "53831": "Medlešice", "53832": "Úhřetice", "53833": "Trojovice", "53834": "Rosice u Chrasti", "53835": "Zaječice", "53836": "Žumberk", "53841": "Podhořany u Ronova nad Doubravou", "53842": "Ronov nad Doubravou", "53843": "Třemošnice", "53845": "Běstvina", "53851": "Chrast u Chrudimě", "53854": "Luže", "53861": "Kočí", "53862": "Hrochův Týnec", "53863": "Chroustovice", "53864": "Jenišovice u Chrudimě", "53865": "Řepníky", "53901": "Hlinsko v Čechách 1", "53941": "Kameničky", "53942": "Svratouch", "53943": "Krouna", "53944": "Proseč u Skutče", "53945": "Nové Hrady u Skutče", "53952": "Trhová Kamenice", "53953": "Horní Bradlo", "53955": "Miřetice u Hlinska", "53956": "Vrbatův Kostelec", "53957": "Včelákov", "53961": "Vortová", "53962": "Hlinsko v Čechách 3", "53971": "Holetín", "53972": "Raná u Hlinska", "53973": "Skuteč", "53974": "Předhradí", "53976": "Prosetín u Hlinska", "54101": "Trutnov 1", "54102": "Trutnov 4", "54103": "Trutnov 3", "54201": "Žacléř", "54203": "Královec", "54204": "Bernartice u Trutnova", "54211": "Chvaleč", "54212": "Radvanice v Čechách", "54213": "Jívka", "54221": "Pec pod Sněžkou", "54223": "Mladé Buky", "54224": "Svoboda nad Úpou", "54225": "Janské Lázně", "54226": "Horní Maršov", "54227": "Výdejní místo Malá Úpa", "54232": "Úpice", "54233": "Rtyně v Podkrkonoší", "54234": "Malé Svatoňovice", "54235": "Velké Svatoňovice", "54236": "Libňatov", "54237": "Batňovice", "54242": "Pilníkov", "54301": "Vrchlabí 1", "54302": "Vrchlabí 4", "54303": "Vrchlabí 3", "54341": "Lánov", "54342": "Dolní Dvůr", "54344": "Černý Důl", "54351": "Špindlerův Mlýn", "54352": "Strážné", "54361": "Kunčice nad Labem", "54362": "Dolní Branná", "54371": "Hostinné", "54372": "Rudník u Vrchlabí", "54373": "Prosečné", "54374": "Dolní Kalná", "54375": "Dolní Olešnice", "54376": "Chotěvice", "54377": "Čermná u Vrchlabí", "54401": "Dvůr Králové nad Labem", "54404": "Výdejní místo Žireč", "54442": "Choustníkovo Hradiště", "54443": "Kuks", "54451": "Doubravice u Dvora Králové n/Labem", "54452": "Výdejní místo Bílé Poličany", "54454": "Velký Vřešťov", "54455": "Dubenec u Dvora Králové nad Labem", "54461": "Nemojov", "54462": "Vítězná", "54464": "Kocbeře", "54466": "Hajnice", "54472": "Bílá Třemešná", "54474": "Horní Brusnice", "54475": "Mostek", "54477": "Borovnice", "54701": "Náchod 1", "54901": "Nové Město nad Metují 1", "54906": "Bohuslavice nad Metují", "54907": "Nahořany", "54908": "Provodov-Šonov", "54911": "Dolní Radechová", "54912": "Výdejní místo Vysokov", "54921": "Česká Čermná", "54922": "Nový Hrádek", "54923": "Výdejní místo Mezilesí", "54931": "Hronov 1", "54932": "Velké Poříčí", "54934": "Hronov 4", "54936": "Stárkov", "54937": "Žďárky", "54941": "Červený Kostelec", "54946": "Horní Radechová", "54947": "Výdejní místo Slatina nad Úpou", "54948": "Studnice u Náchoda", "54952": "Horní Adršpach", "54954": "Police nad Metují", "54955": "Žďár nad Metují", "54956": "Česká Metuje", "54957": "Teplice nad Metují", "54962": "Suchý Důl", "54963": "Machov", "54964": "Bezděkov nad Metují", "54971": "Šonov u Broumova", "54972": "Otovice u Broumova", "54973": "Martínkovice", "54974": "Božanov", "54981": "Meziměstí u Broumova 1", "54982": "Vernéřovice", "54983": "Meziměstí u Broumova 3", "54984": "Heřmánkovice", "55001": "Broumov 1", "55101": "Jaroměř 1", "55102": "Jaroměř 3", "55203": "Česká Skalice", "55204": "Chvalkovice v Čechách", "55205": "Hořičky", "55211": "Velichovky", "55212": "Heřmanice nad Labem", "55221": "Rasošky", "55222": "Jasenná", "55224": "Velká Jesenice", "55225": "Rychnovek", "56002": "Česká Třebová 2", "56101": "Hnátnice", "56102": "Dolní Dobrouč", "56112": "Brandýs nad Orlicí", "56113": "Sudslava", "56114": "České Libchavy", "56115": "Sopotnice", "56116": "Libchavy", "56117": "Dlouhá Třebová", "56118": "Němčice", "56122": "Ostrov", "56123": "Damníkov", "56124": "Třebovice", "56125": "Rudoltice", "56131": "Tatenice", "56132": "Cotkytle", "56133": "Horní Heřmanice v Čechách", "56134": "Výprachtice", "56141": "Řetová", "56151": "Letohrad", "56152": "Verměřovice", "56153": "Dolní Čermná", "56154": "Bystřec", "56155": "Orličky", "56156": "Horní Čermná", "56161": "Červená Voda 1", "56162": "Výdejní místo Červená Voda", "56163": "Nekoř", "56164": "Jablonné nad Orlicí", "56165": "Jamné nad Orlicí", "56166": "Těchonín", "56167": "Mladkov", "56168": "Výdejní místo Lichkov", "56169": "Králíky", "56170": "Písečná", "56181": "Kunvald", "56182": "Klášterec nad Orlicí", "56184": "Líšnice", "56185": "Česká Rybná u Žamberka", "56186": "Záchlumí", "56201": "Ústí nad Orlicí 1", "56203": "Ústí nad Orlicí 3", "56204": "Ústí nad Orlicí 4", "56206": "Ústí nad Orlicí 6", "56301": "Lanškroun", "56401": "Žamberk", "56501": "Choceň 1", "56542": "Vraclav", "56543": "Zámrsk", "56544": "Sruby", "56552": "České Heřmanice", "56553": "Sloupnice", "56555": "VM Hrušová", "56601": "Vysoké Mýto", "56802": "Svitavy 2", "56901": "Hradec nad Svitavou", "56902": "Březová nad Svitavou", "56903": "Rozhraní", "56904": "Brněnec", "56905": "Bělá nad Svitavou", "56906": "Vítějeves", "56907": "Radiměř", "56911": "Koclířov u Svitav", "56912": "Opatov v Čechách", "56914": "Vendolí", "56921": "Moravská Třebová 3", "56922": "Křenov", "56923": "Březina u Moravské Třebové", "56924": "Kunčina", "56932": "Staré Město u Moravské Třebové", "56933": "Třebařov", "56934": "Rychnov na Moravě", "56935": "Mladějov na Moravě", "56941": "Městečko Trnávka", "56942": "Chornice", "56943": "Jevíčko", "56944": "Jaroměřice u Jevíčka", "56951": "Morašice u Litomyšle", "56953": "Cerekvice nad Loučnou", "56955": "Janov u Litomyšle", "56956": "Čistá u Litomyšle", "56957": "Trstěnice u Litomyšle", "56961": "Dolní Újezd u Litomyšle", "56962": "Sebranice u Litomyšle", "56963": "Lubná u Poličky", "56965": "Budislav u Litomyšle", "56966": "Jarošov u Litomyšle", "56967": "Osík u Litomyšle", "56971": "Pomezí", "56972": "Rohozná u Poličky", "56973": "Svojanov", "56974": "Trpín", "56982": "Borová u Poličky", "56991": "Jedlová u Poličky", "56992": "Bystré u Poličky", "56993": "Korouhev", "56994": "Telecí", "57001": "Litomyšl", "57101": "Moravská Třebová 1", "57201": "Polička", "58001": "Havlíčkův Brod 1", "58221": "Pohled", "58222": "Přibyslav", "58223": "Havlíčkova Borová", "58224": "Oudoleň", "58231": "Okrouhlice", "58232": "Lipnice nad Sázavou", "58233": "Dolní Město", "58234": "Krásná Hora u Havlíčkova Brodu", "58235": "Lučice", "58241": "Skuhrov u Havlíčkova Brodu", "58242": "Kámen u Habrů", "58243": "Tis", "58244": "Sázavka", "58245": "Uhelná Příbram", "58251": "Šlapanov", "58252": "Věžnice u Havlíčkova Brodu", "58253": "Štoky", "58254": "Úsobí", "58255": "Herálec u Havlíčkova Brodu", "58256": "Věž", "58257": "Lípa u Havlíčkova Brodu", "58261": "Česká Bělá", "58262": "Sobíňov", "58263": "Ždírec nad Doubravou", "58264": "Výdejní místo Horní Studenec", "58265": "Slavíkov", "58266": "Krucemburk", "58271": "Dolní Krupá u Havlíčkova Brodu", "58272": "Rozsochatec", "58273": "Nová Ves u Chotěboře", "58274": "Jeřišno", "58276": "Maleč", "58277": "Libice nad Doubravou", "58281": "Habry", "58282": "Golčův Jeníkov", "58283": "Vilémov u Golčova Jeníkova", "58286": "Leština u Světlé nad Sázavou", "58287": "Číhošť", "58291": "Světlá nad Sázavou", "58292": "Kamenná Lhota", "58293": "Kožlí", "58294": "Hněvkovice u Ledče nad Sázavou", "58301": "Chotěboř", "58401": "Ledeč nad Sázavou", "58601": "Jihlava 1", "58603": "Jihlava 3", "58801": "Smrčná", "58805": "Dušejov", "58811": "Střítež u Jihlavy", "58812": "Dobronín", "58813": "Polná", "58821": "Velký Beranov", "58822": "Luka nad Jihlavou", "58823": "Kamenice u Jihlavy", "58824": "Řehořov", "58825": "Jersín", "58826": "Zhoř u Jihlavy", "58827": "Jamné u Jihlavy", "58831": "Puklice", "58832": "Brtnice", "58833": "Stonařov", "58834": "Dlouhá Brtnice", "58835": "Vílanec", "58841": "Vyskytná nad Jihlavou", "58842": "Větrný Jeníkov", "58844": "Rohozná u Jihlavy", "58845": "Dolní Cerekev", "58851": "Batelov", "58852": "Horní Dubenky", "58854": "Mrákotín", "58856": "Telč", "58861": "Kostelec u Jihlavy", "58862": "Urbanov", "58864": "Krasonice", "58865": "Nová Říše", "58866": "Rozseč", "58867": "Stará Říše", "58901": "Třešť", "59101": "Žďár nad Sázavou 1", "59102": "Žďár nad Sázavou 2", "59201": "Herálec pod Žákovou horou", "59202": "Svratka", "59203": "Sněžné", "59204": "Fryšava pod Žákovou horou", "59211": "Velká Losenice", "59212": "Nížkov", "59213": "Bohdalov", "59214": "Nové Veselí", "59221": "Škrdlovice", "59231": "Nové Město na Moravě", "59232": "Jámy", "59233": "Radešínská Svratka", "59241": "Dalečín", "59242": "Jimramov", "59244": "Věcov", "59245": "Lísek", "59251": "Dolní Rožínka", "59252": "Rožná", "59253": "Strážek", "59254": "Moravec", "59255": "Bobrová", "59256": "Zvole nad Pernštejnem", "59257": "Rozsochy", "59261": "Doubravník", "59262": "Nedvědice", "59263": "Štěpánov nad Svratkou", "59264": "Prosetín u Bystřice nad Pernštejnem", "59265": "Rovečné", "59266": "Vír", "59301": "Bystřice nad Pernštejnem", "59401": "Velké Meziříčí", "59441": "Uhřínov", "59442": "Měřín", "59444": "Radostín nad Oslavou", "59445": "Ostrov nad Oslavou", "59451": "Křižanov", "59452": "Ořechov u Vel.Meziříčí", "59453": "Osová Bítýška", "59454": "Křoví", "59455": "Dolní Loučky", "59456": "Žďárec", "59457": "Vidonín", "59458": "Heřmanov", "59461": "Bory", "59501": "Velká Bíteš","60200": "Brno 2", "60300": "Brno 3", "61200": "Brno 12", "61300": "Brno 13", "61400": "Brno 14", "61500": "Brno 15", "61600": "Brno 16", "61700": "Brno 17", "61800": "Brno 18", "61900": "Brno 19", "62000": "Brno 20", "62100": "Brno 21", "62300": "Brno 23", "62400": "Brno 24", "62500": "Brno 25", "62700": "Brno 27", "62800": "Brno 28", "63400": "Brno 34", "63500": "Brno 35", "63600": "Brno 36", "63700": "Brno 37", "63800": "Brno 38", "63900": "Brno 39", "64100": "Brno 41", "64200": "Brno 42", "64300": "Brno 43", "64400": "Brno 44", "66401": "Bílovice nad Svitavou", "66402": "Ochoz u Brna", "66403": "Podolí u Brna", "66404": "Mokrá", "66405": "Tvarožná", "66406": "Viničné Šumice", "66407": "Pozořice", "66408": "Blažovice", "66411": "Zbýšov u Brna", "66412": "Oslavany", "66417": "Tetčice", "66423": "Čebín", "66424": "Drásov", "66431": "Lelekovice", "66432": "Vranov u Brna", "66434": "Kuřim", "66441": "Troubsko", "66442": "Modřice", "66443": "Želešice", "66444": "Ořechov u Brna", "66446": "Prštice", "66447": "Střelice u Brna", "66448": "Moravany u Brna", "66449": "Ostopovice", "66451": "Šlapanice u Brna", "66452": "Sokolnice", "66453": "Újezd u Brna", "66454": "Těšany", "66455": "Moutnice", "66456": "Blučina", "66457": "Měnín", "66458": "Prace", "66459": "Telnice u Brna", "66461": "Rajhrad", "66462": "Hrušovany u Brna", "66463": "Žabčice", "66464": "Dolní Kounice", "66465": "Malešovice", "66466": "Němčičky u Židlochovic", "66467": "Syrovice", "66471": "Veverská Bítýška", "66475": "Deblín", "66481": "Ostrovačice", "66482": "Říčany u Brna", "66483": "Domašov u Brna", "66484": "Zastávka u Brna", "66488": "Zbraslav u Brna", "66491": "Ivančice", "66501": "Rosice u Brna", "66601": "Tišnov 1", "66602": "Předklášteří", "66603": "Tišnov 3", "66701": "Židlochovice", "66902": "Znojmo 2", "66904": "Znojmo 4", "67101": "Citonice", "67102": "Šumná", "67103": "Vranov nad Dyjí", "67106": "Šafov", "67107": "Uherčice u Znojma", "67110": "Výdejní místo Bítov", "67122": "Šatov", "67124": "Vrbovec", "67125": "Hodonice", "67126": "Dyjákovice", "67127": "Hrádek u Znojma", "67128": "Jaroslavice", "67129": "Strachotice", "67131": "Únanov", "67132": "Plaveč u Znojma", "67133": "Mikulovice u Znojma", "67134": "Horní Dunajovice", "67138": "Višňové u Znojma", "67139": "Výdejní místo Běhařovice", "67140": "Tavíkovice", "67142": "Vémyslice", "67151": "Kravsko", "67152": "Hluboké Mašůvky", "67153": "Jevišovice", "67154": "Hostim", "67155": "Blížkovice", "67156": "Pavlice", "67161": "Prosiměřice", "67162": "Oleksovice", "67163": "Lechovice", "67164": "Božice", "67165": "Břežany u Znojma", "67167": "Hrušovany nad Jevišovkou", "67168": "Hrabětice", "67169": "Hevlín", "67171": "Hostěradice", "67172": "Miroslav", "67173": "Tulešice", "67175": "Loděnice u Moravského Krumlova", "67176": "Olbramovice u Moravského Krumlova", "67177": "Branišovice", "67178": "Jiřice u Miroslavi", "67181": "Znojmo 5", "67182": "Dobšice", "67201": "Moravský Krumlov", "67401": "Třebíč 1", "67501": "Vladislav", "67502": "Koněšín", "67503": "Budišov u Třebíče", "67504": "Hodov", "67505": "Rudíkov", "67506": "Výdejní místo Benetice", "67507": "Čechtín", "67508": "Kouty u Třebíče", "67521": "Okříšky", "67522": "Stařeč", "67523": "Kojetice na Moravě", "67524": "Čáslavice", "67525": "Rokytnice nad Rokytnou", "67526": "Želetava", "67527": "Předín", "67528": "Opatov na Moravě", "67529": "Kněžice u Třebíče", "67531": "Jemnice", "67532": "Třebelovice", "67533": "Dešov", "67534": "Police u Jemnice", "67541": "Nové Syrovice", "67542": "Budkov", "67543": "Domamil", "67544": "Lesonice", "67545": "Šebkovice", "67550": "Dukovany-elektrárna", "67551": "Jaroměřice nad Rokytnou", "67552": "Lipník u Hrotovic", "67553": "Valeč u Hrotovic", "67554": "Dalešice", "67555": "Hrotovice", "67556": "Dukovany", "67557": "Rouchovany", "67559": "Radkovice u Hrotovic", "67560": "Myslibořice", "67571": "Náměšť nad Oslavou", "67573": "Rapotice", "67574": "Březník", "67575": "Mohelno", "67576": "Hartvíkovice", "67577": "Kramolín-vodní dílo", "67578": "Čikov", "67579": "Tasov", "67602": "Moravské Budějovice 2", "67801": "Blansko 1", "67901": "Skalice nad Svitavou", "67902": "Rájec-Jestřebí", "67903": "Olomučany", "67904": "Adamov 1", "67905": "Křtiny", "67906": "Jedovnice", "67907": "Kotvrdovice", "67911": "Doubravice nad Svitavou", "67913": "Sloup v Moravském Krasu", "67914": "Ostrov u Macochy", "67915": "Lipovec u Blanska", "67921": "Černá Hora", "67922": "Lipůvka", "67923": "Lomnice u Tišnova", "67924": "Výdejní místo Unín", "67931": "Sebranice u Boskovic", "67932": "Svitávka", "67933": "Vísky u Letovic", "67934": "Knínice", "67935": "Šebetov", "67936": "Vanovice", "67937": "Borotín u Boskovic", "67938": "Cetkovice", "67939": "Úsobrno", "67951": "Němčice u Boskovic", "67952": "Žďárná", "67953": "Benešov u Boskovic", "67961": "Letovice", "67962": "Křetín", "67963": "Velké Opatovice", "67971": "Lysice", "67972": "Kunštát na Moravě", "67973": "Rozseč nad Kunštátem", "67974": "Olešnice na Moravě", "67975": "Výdejní místo Černovice", "67976": "Drnovice u Lysic", "68001": "Boskovice", "68201": "Vyškov 1", "68301": "Rousínov u Vyškova", "68303": "Luleč", "68304": "Drnovice", "68305": "Račice-Pístovice", "68308": "Studnice u Vyškova", "68321": "Pustiměř", "68323": "Ivanovice na Hané", "68333": "Nesovice", "68335": "Letonice u Vyškova", "68341": "Bohdalice", "68351": "Holubice", "68352": "Křenovice u Slavkova", "68354": "Otnice", "68401": "Slavkov u Brna", "68501": "Bučovice", "68601": "Uherské Hradiště 1", "68603": "Staré Město u Uherského Hradiště", "68604": "Kunovice", "68605": "Uherské Hradiště 5", "68606": "Uherské Hradiště 6", "68609": "Míkovice", "68703": "Babice u Uherského Hradiště", "68704": "Traplice", "68705": "Jalubí", "68706": "Velehrad", "68707": "Tupesy", "68708": "Buchlovice", "68709": "Boršice u Buchlovic", "68710": "Zlechov", "68711": "Topolná", "68712": "Bílovice u Uherského Hradiště", "68713": "Březolupy", "68722": "Ostrožská Nová Ves", "68723": "Ostrožská Lhota", "68724": "Uherský Ostroh", "68725": "Hluk", "68731": "Šumice", "68732": "Nezdenice", "68733": "Hradčovice", "68734": "Uherský Brod 3", "68737": "Polešovice", "68738": "Nedakonice", "68741": "Medlovice", "68742": "Osvětimany", "68751": "Nivnice", "68752": "Korytná", "68753": "Suchá Loz", "68754": "Bánov u Uherského Brodu", "68755": "Bystřice pod Lopeníkem", "68756": "Prakšice", "68761": "Vlčnov", "68762": "Dolní Němčí", "68763": "Boršice u Blatnice", "68764": "Horní Němčí", "68765": "Strání", "68766": "Květná", "68767": "Březová u Uherského Brodu", "68771": "Bojkovice", "68774": "Starý Hrozenkov", "68801": "Uherský Brod 1", "69002": "Břeclav 2", "69003": "Břeclav 3", "69006": "Břeclav 6", "69101": "Moravský Žižkov", "69102": "Velké Bílovice", "69103": "Rakvice", "69104": "Přítluky", "69105": "Zaječí", "69106": "Velké Pavlovice", "69107": "Němčičky", "69108": "Bořetice u Hustopečí", "69109": "Vrbice u Břeclavě", "69110": "Kobylí na Moravě", "69111": "Brumovice na Moravě", "69112": "Boleradice", "69121": "Sedlec u Mikulova", "69122": "Pasohlávky", "69123": "Pohořelice", "69124": "Přibice", "69125": "Vranovice", "69126": "Pouzdřany", "69127": "Popice", "69129": "Dolní Věstonice", "69130": "Vlasatice", "69141": "Břeclav 4", "69142": "Valtice", "69143": "Hlohovec u Břeclavě", "69144": "Lednice na Moravě", "69145": "Podivín", "69146": "Ladná", "69151": "Lanžhot", "69152": "Kostice u Břeclavě", "69153": "Tvrdonice", "69154": "Týnec u Břeclavě", "69155": "Moravská Nová Ves", "69156": "Hrušky", "69162": "Uherčice u Hustopečí", "69163": "Velké Němčice", "69164": "Nosislav", "69165": "Křepice u Hustopečí", "69167": "Šakvice", "69168": "Starovičky", "69171": "Diváky", "69172": "Klobouky u Brna", "69173": "Krumvíř", "69174": "Velké Hostěrádky", "69175": "Borkovany", "69176": "Šitbořice", "69181": "Březí u Mikulova", "69182": "Novosedly na Moravě", "69183": "Drnholec", "69185": "Dolní Dunajovice", "69186": "Perná", "69188": "Milovice u Mikulova", "69189": "Bulhary", "69201": "Mikulov na Moravě", "69301": "Hustopeče u Brna", "69501": "Hodonín 1", "69601": "Rohatec", "69602": "Ratíškovice", "69603": "Dubňany", "69604": "Svatobořice", "69605": "Milotice u Kyjova", "69606": "Vacenovice", "69611": "Mutěnice", "69612": "Hovorany", "69613": "Šardice", "69614": "Čejč", "69615": "Čejkovice", "69616": "Starý Poddvorov", "69617": "Dolní Bojanovice", "69618": "Lužice u Hodonína", "69619": "Mikulčice", "69621": "Prušánky", "69631": "Bukovany u Hodonína", "69632": "Ždánice", "69633": "Archlebov", "69634": "Žarošice", "69635": "Dambořice", "69636": "Násedlovice", "69637": "Želetice u Kyjova", "69638": "Strážovice", "69639": "Lovčice u Kyjova", "69641": "Vlkoš u Kyjova", "69642": "Vracov", "69647": "Žeravice", "69648": "Ježov", "69649": "Žádovice", "69650": "Moravany u Kyjova", "69651": "Kostelec u Kyjova", "69655": "Kyjov 3", "69661": "Vnorovy", "69662": "Strážnice", "69663": "Hroznová Lhota", "69664": "Kněždub", "69665": "Petrov u Hodonína", "69666": "Sudoměřice nad Moravou", "69667": "Radějov u Hodonína", "69671": "Blatnice pod Svatým Antonínkem", "69672": "Lipov", "69673": "Hrubá Vrbka", "69674": "Velká nad Veličkou", "69676": "Louka nad Veličkou", "69681": "Bzenec", "69683": "Domanín", "69684": "Těmice u Hodonína", "69685": "Moravský Písek", "69701": "Kyjov 1", "69801": "Veselí nad Moravou", "70030": "Ostrava 30", "70200": "Ostrava 2", "70300": "Ostrava 3", "70800": "Ostrava 8", "70900": "Ostrava 9", "71000": "Ostrava 10", "71100": "Ostrava 11", "71200": "Ostrava 12", "71300": "Ostrava 13", "71500": "Ostrava 15", "71600": "Ostrava 16", "71700": "Ostrava 17", "71800": "Ostrava 18", "71900": "Ostrava 19", "72000": "Ostrava 20", "72100": "Ostrava 21", "72200": "Ostrava 22", "72300": "Ostrava 23", "72400": "Ostrava 24", "72525": "Ostrava 25", "72526": "Ostrava 26", "72527": "Ostrava 27", "72528": "Ostrava 28", "72529": "Ostrava 29", "73301": "Karviná 1", "73401": "Karviná 4", "73503": "Karviná 3", "73506": "Karviná 6", "73511": "Orlová 1", "73514": "Orlová 4", "73531": "Bohumín 3", "73532": "Rychvald", "73533": "Doubrava", "73534": "Stonava", "73535": "Horní Suchá", "73541": "Petřvald u Karviné", "73542": "Těrlicko", "73543": "Albrechtice u Českého Těšína", "73551": "Bohumín 5", "73552": "Bohumín 4", "73553": "Dolní Lutyně", "73561": "Chotěbuz", "73562": "Český Těšín 6", "73564": "Havířov 4", "73571": "Dětmarovice", "73572": "Petrovice u Karviné", "73581": "Bohumín 1", "73601": "Havířov 1", "73701": "Český Těšín 1", "73801": "Frýdek-Místek 1", "73901": "Baška", "73904": "Pražmo", "73911": "Frýdlant nad Ostravicí", "73912": "Čeladná", "73913": "Kunčice pod Ondřejníkem", "73914": "Ostravice", "73915": "Staré Hamry", "73921": "Paskov", "73923": "Stará Ves nad Ondřejnicí", "73924": "Krmelín", "73925": "Sviadnov", "73932": "Vratimov 1", "73934": "Šenov u Ostravy", "73936": "Sedliště", "73937": "Horní Bludovice", "73938": "Dolní Domaslavice", "73939": "Lučina", "73941": "Palkovice", "73942": "Frýdek-Místek 8", "73943": "Staříč", "73944": "Brušperk", "73945": "Fryčovice", "73946": "Hukvaldy", "73947": "Kozlovice", "73949": "Metylovice", "73951": "Dobrá", "73953": "Hnojník", "73955": "Smilovice u Třince", "73959": "Střítež u Českého Těšína", "73961": "Třinec 1", "73981": "Milíkov u Jablunkova", "73984": "Písek u Jablunkova", "73985": "Bukovec", "73991": "Jablunkov", "73992": "Návsí", "73994": "Vendryně", "73995": "Bystřice nad Olší", "73997": "Hrádek nad Olší", "73998": "Mosty u Jablunkova", "74101": "Nový Jičín 1", "74201": "Suchdol nad Odrou", "74213": "Studénka 3", "74221": "Kopřivnice", "74231": "Starý Jičín", "74233": "Jeseník nad Odrou", "74235": "Odry", "74236": "Jakubčovice nad Odrou", "74237": "Spálov", "74242": "Šenov u Nového Jičína", "74243": "Pustějov", "74245": "Fulnek 1", "74247": "Hladké Životice", "74251": "Mošnov", "74253": "Kunín", "74254": "Bartošovice na Moravě", "74255": "Albrechtičky", "74256": "Sedlnice", "74257": "Libhošť", "74258": "Příbor", "74260": "Petřvald u Nového Jičína", "74265": "Rybí", "74266": "Štramberk", "74267": "Ženklava", "74271": "Hodslavice", "74272": "Mořkov", "74273": "Veřovice", "74274": "Tichá", "74275": "Lichnov u Nového Jičína", "74281": "Bravantice", "74282": "Jistebník", "74283": "Klimkovice", "74285": "Vřesina u Bílovce", "74291": "Velké Albrechtice", "74292": "Bílovec 5", "74293": "Slatina u Bílovce", "74301": "Bílovec 1", "74401": "Frenštát pod Radhoštěm", "74601": "Opava 1", "74705": "Opava 5", "74706": "Opava 6", "74707": "Opava 7", "74711": "Kozmice u Hlučína", "74714": "Ludgeřovice", "74715": "Šilheřovice", "74716": "Hať u Hlučína", "74717": "Darkovice", "74718": "Píšť", "74719": "Bohuslavice u Hlučína", "74720": "Vřesina u Hlučína", "74721": "Kravaře u Hlučína", "74722": "Dolní Benešov", "74723": "Bolatice", "74724": "Chuchelná", "74725": "Sudice", "74727": "Kobeřice", "74728": "Štěpánkovice", "74731": "Velké Hoštice", "74733": "Oldřišov", "74735": "Hněvošice", "74741": "Hradec nad Moravicí", "74743": "Větřkovice u Vítkova", "74744": "Březová u Vítkova", "74745": "Skřipov u Opavy", "74747": "Vítkov 3", "74751": "Výdejní místo Stěbořice", "74752": "Hlavnice", "74753": "Jakartovice", "74754": "Mladecko", "74755": "Litultovice", "74756": "Dolní Životice", "74757": "Slavkov u Opavy", "74761": "Raduň", "74762": "Mokré Lazce", "74763": "Hrabyně 1", "74764": "Velká Polom", "74766": "Dolní Lhota", "74767": "Hrabyně 3", "74768": "Kyjovice", "74769": "Pustá Polom", "74770": "Opava 9", "74771": "Brumovice u Opavy", "74773": "Vávrovice", "74774": "Neplachovice", "74775": "Velké Heraltice", "74781": "Otice", "74782": "Štáblovice", "74784": "Melč", "74786": "Kružberk", "74787": "Budišov nad Budišovkou", "74791": "Štítina", "74792": "Háj ve Slezsku", "74794": "Děhylov", "74795": "Suché Lazce", "74801": "Hlučín", "74901": "Vítkov 1", "75002": "Přerov 2", "75101": "Tovačov", "75102": "Troubky nad Bečvou", "75103": "Brodek u Přerova", "75104": "Rokytnice u Přerova", "75105": "Kokory", "75111": "Radslavice", "75114": "Dřevohostice", "75115": "Domaželice u Přerova", "75116": "Želatovice", "75117": "Horní Moštěnice", "75118": "Říkovice", "75119": "Vlkoš u Přerova", "75121": "Prosenice", "75122": "Osek nad Bečvou", "75123": "Dolní Újezd", "75124": "Přerov 4", "75125": "Veselíčko u Lipníka nad Bečvou", "75127": "Výdejní místo Penčice", "75131": "Lipník nad Bečvou", "75144": "Polkovice", "75201": "Kojetín", "75301": "Hranice 1", "75352": "Skalička u Hranic", "75353": "Všechovice", "75354": "Soběchleby", "75355": "Paršovice", "75356": "Opatovice u Hranic", "75361": "Hranice 4", "75362": "Potštát", "75363": "Střítež nad Ludinou", "75364": "Bělotín", "75366": "Hustopeče nad Bečvou", "75367": "Milotice nad Bečvou", "75368": "Černotín", "75501": "Vsetín 1", "75601": "Hovězí", "75602": "Huslenky", "75603": "Halenkov", "75604": "Nový Hrozenkov", "75605": "Karolinka", "75606": "Velké Karlovice", "75607": "Zděchov", "75611": "Valašská Polanka", "75612": "Horní Lideč", "75614": "Francova Lhota", "75621": "Ratiboř u Vsetína", "75622": "Hošťálková u Vsetína", "75623": "Jablůnka nad Bečvou", "75624": "Bystřička", "75625": "Růžďka", "75627": "Valašská Bystřice", "75631": "Liptál", "75641": "Lešná", "75642": "Choryně", "75643": "Kelč", "75644": "Loučka", "75645": "Branky", "75651": "Zašová", "75652": "Střítež nad Bečvou", "75653": "Vidče", "75654": "Zubří", "75655": "Dolní Bečva", "75656": "Prostřední Bečva", "75657": "Horní Bečva", "75661": "Rožnov pod Radhoštěm 1", "75662": "Hutisko-Solanec", "75663": "Krhová", "75701": "Valašské Meziříčí 1", "76001": "Zlín 1", "76005": "Zlín 5", "76301": "Mysločovice", "76302": "Zlín 4", "76307": "Velký Ořechov", "76310": "Hvozdná", "76311": "Želechovice nad Dřevnicí", "76312": "Vizovice", "76313": "Jasenná u Vizovic", "76314": "Zlín 12", "76315": "Slušovice", "76316": "Fryšták", "76317": "Lukov u Zlína", "76318": "Trnava u Zlína", "76319": "Kašava", "76321": "Slavičín", "76323": "Dolní Lhota u Luhačovic", "76324": "Vlachovice", "76325": "Újezd u Valašských Klobouk", "76326": "Luhačovice", "76331": "Brumov-Bylnice", "76332": "Nedašov", "76333": "Štítná nad Vláří", "76334": "Brumov-Bylnice 3", "76341": "Biskupice u Luhačovic", "76345": "Březůvky", "76351": "Bohuslavice u Zlína", "76361": "Napajedla", "76362": "Tlumačov", "76363": "Halenkovice", "76364": "Spytihněv", "76502": "Otrokovice 2", "76601": "Valašské Klobouky", "76701": "Kroměříž 1", "76801": "Výdejní místo Jarohněvice", "76802": "Zdounky", "76803": "Roštín", "76804": "Střílky", "76805": "Koryčany", "76811": "Chropyně", "76812": "Rataje u Kroměříže", "76813": "Litenčice", "76821": "Kvasice", "76823": "Břest", "76824": "Hulín", "76831": "Zlobice", "76832": "Zborovice", "76833": "Morkovice-Slížany", "76834": "Pačlavice", "76841": "Bystřice pod Hostýnem 7", "76842": "Prusinovice", "76843": "Kostelec u Holešova", "76852": "Míškovice u Holešova", "76861": "Bystřice pod Hostýnem 1", "76871": "Rajnochovice", "76872": "Chvalčov", "76875": "Loukov", "76901": "Holešov", "77900": "Olomouc 9", "78301": "Olomouc 18", "78305": "Horní Loděnice", "78306": "Domašov nad Bystřicí", "78307": "Město Libavá", "78313": "Štěpánov u Olomouce", "78314": "Bohuňovice", "78316": "Dolany u Olomouce", "78321": "Chudobín", "78322": "Cholina", "78324": "Slavětín", "78325": "Bouzov", "78332": "Náklo", "78333": "Příkazy", "78335": "Horka nad Moravou", "78336": "Křelov-Břuchotín", "78342": "Slatinice", "78344": "Náměšť na Hané", "78345": "Senice na Hané", "78346": "Těšetice", "78347": "Hněvotín", "78349": "Lutín", "78353": "Velká Bystřice", "78354": "Přáslavice", "78355": "Velký Újezd", "78356": "Doloplazy", "78357": "Tršice", "78361": "Hlubočky 1", "78365": "Hlubočky 3", "78372": "Velký Týnec 1", "78373": "Grygov", "78375": "Dub nad Moravou", "78383": "Troubelice", "78385": "Šumvald u Uničova", "78386": "Dlouhá Loučka", "78391": "Uničov 1", "78396": "Újezd u Uničova", "78397": "Paseka u Šternberka", "78401": "Litovel", "78501": "Šternberk 1", "78701": "Šumperk 1", "78801": "Oskava", "78803": "Nový Malín", "78804": "Hrabišín", "78805": "Libina", "78811": "Loučná nad Desnou", "78813": "Vikýřovice", "78814": "Rapotín", "78815": "Velké Losiny", "78816": "Petrov nad Desnou", "78820": "Dolní Studénky", "78821": "Sudkov", "78823": "Jindřichov u Šumperka", "78825": "Výdejní místo Branná", "78832": "Staré Město pod Sněžníkem", "78833": "Hanušovice", "78901": "Zábřeh", "78961": "Bludov", "78962": "Olšany u Šumperka", "78963": "Ruda nad Moravou", "78964": "Bohdíkov", "78969": "Postřelmov", "78971": "Leština u Zábřeha", "78972": "Dubicko", "78973": "Úsov", "78974": "Rohle", "78975": "Brníčko u Zábřeha", "78982": "Moravičany", "78983": "Loštice", "78985": "Mohelnice", "78991": "Štíty", "79001": "Jeseník 1", "79051": "Supíkovice", "79052": "Velké Kunětice", "79053": "Stará Červená Voda", "79054": "Černá Voda", "79055": "Vidnava", "79057": "Bernartice u Javorníka", "79058": "Velká Kraš", "79061": "Lipová-lázně 1", "79063": "Lipová-lázně 3", "79064": "Vápenná", "79065": "Žulová", "79069": "Bílá Voda u Javorníka", "79070": "Javorník u Jeseníku", "79081": "Česká Ves", "79082": "Písečná u Jeseníku", "79084": "Mikulovice u Jeseníku 1", "79201": "Bruntál 1", "79302": "Lomnice u Rýmařova", "79303": "Dětřichov nad Bystřicí", "79305": "Moravský Beroun", "79312": "Horní Benešov", "79315": "Lichnov u Bruntálu", "79316": "Zátor", "79323": "Karlovice", "79324": "Karlova Studánka", "79326": "Vrbno pod Pradědem", "79331": "Světlá Hora", "79336": "Malá Morávka", "79342": "Janovice u Rýmařova", "79344": "Horní Město", "79351": "Břidličná", "79356": "Ryžoviště", "79368": "Dvorce u Bruntálu", "79371": "Holčovice", "79374": "Heřmanovice", "79376": "Zlaté Hory v Jeseníkách", "79382": "Třemešná u Krnova", "79383": "Jindřichov u Krnova", "79384": "Janov u Krnova", "79391": "Úvalno", "79393": "Brantice", "79395": "Město Albrechtice", "79397": "Slezské Rudoltice", "79399": "Osoblaha", "79401": "Krnov 1", "79501": "Rýmařov", "79601": "Prostějov 1", "79603": "Prostějov 3", "79604": "Prostějov 4", "79607": "Držovice", "79802": "Mostkovice", "79803": "Plumlov", "79804": "Určice", "79805": "Myslejovice", "79806": "Otaslavice", "79807": "Brodek u Prostějova", "79808": "Kelčice", "79809": "Vřesovice", "79811": "Prostějov 6", "79812": "Kralice na Hané", "79813": "Vrbátky", "79814": "Olšany u Prostějova", "79816": "Čelechovice na Hané", "79817": "Smržice", "79821": "Bedihošť", "79823": "Klenovice na Hané", "79824": "Pivín", "79825": "Dobromilice", "79826": "Nezamyslice u Prostějova", "79827": "Němčice nad Hanou", "79828": "Mořice", "79829": "Tištín", "79830": "Pavlovice u Kojetína", "79841": "Kostelec na Hané", "79842": "Lešany u Prostějova", "79843": "Ptení", "79844": "Stražisko", "79845": "Suchdol u Prostějova", "79846": "Brodek u Konice", "79847": "Horní Štěpánov", "79848": "Protivanov", "79849": "Malé Hradisko", "79851": "Přemyslovice", "79852": "Konice", "79853": "Výdejní místo Jesenec", "79854": "Kladky", "79855": "Hvozd u Prostějova", "79856": "Bohuslavice u Konice", "79857": "Laškov", "79858": "Čechy pod Kosířem", "79861": "Drahany", "79862": "Rozstání"}
    
cityDict = {v: k for k, v in codes.items()}

def returnCity(code):
    def raiseValue():
        raise ValueError('%s is probably not a valid code of czech postal system.\n\
    Czech postal numbers have 5 digits, starting with numbers from 1 to 7.\n\
    there are 2700 registered codes in total.'%(code))
    code = str(code)
    code = code.replace(' ','')
    if len(code) == 5:
        if code in codes.keys():
            return codes[code]
        if code not in codes.keys():
            raiseValue()
    if len(code) != 5 :
        raiseValue()
    
def returnCode(city, closestMatch = True):
    def hasNumbers(inputString):
        return any(char.isdigit() for char in inputString)
    cityOriginal = city
    city = str(city)
    if closestMatch:
        city = get_close_matches(city, codes.values())   
        city = city[0]
    if hasNumbers(city) == True and hasNumbers(cityOriginal) == False:
        city = sub('[0123456789]', '1', city)
    if city in cityDict.keys():
        return cityDict[city]   
    else:
        suggestions = ''
        if closestMatch == False:
            suggestions = 'Suggestions: '+', '.join(get_close_matches(cityOriginal, cityDict))
        raise ValueError('This city does not exist. '+suggestions) 
