# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Word(Model):
    """Json object representing a recognized word.

    All required parameters must be populated in order to send to Azure.

    :param bounding_box: Required. Bounding box of a recognized word.
    :type bounding_box: list[int]
    :param text: Required. The text content of the word.
    :type text: str
    :param confidence: Qualitative confidence measure. Possible values
     include: 'High', 'Low'
    :type confidence: str or
     ~azure.cognitiveservices.vision.computervision.models.TextRecognitionResultConfidenceClass
    """

    _validation = {
        'bounding_box': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'bounding_box': {'key': 'boundingBox', 'type': '[int]'},
        'text': {'key': 'text', 'type': 'str'},
        'confidence': {'key': 'confidence', 'type': 'TextRecognitionResultConfidenceClass'},
    }

    def __init__(self, *, bounding_box, text: str, confidence=None, **kwargs) -> None:
        super(Word, self).__init__(**kwargs)
        self.bounding_box = bounding_box
        self.text = text
        self.confidence = confidence
