# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ImageAnalysis(Model):
    """Result of AnalyzeImage operation.

    :param categories: An array indicating identified categories.
    :type categories:
     list[~azure.cognitiveservices.vision.computervision.models.Category]
    :param adult: An object describing whether the image contains
     adult-oriented content and/or is racy.
    :type adult:
     ~azure.cognitiveservices.vision.computervision.models.AdultInfo
    :param color: An object providing additional metadata describing color
     attributes.
    :type color:
     ~azure.cognitiveservices.vision.computervision.models.ColorInfo
    :param image_type: An object providing possible image types and matching
     confidence levels.
    :type image_type:
     ~azure.cognitiveservices.vision.computervision.models.ImageType
    :param tags: A list of tags with confidence level.
    :type tags:
     list[~azure.cognitiveservices.vision.computervision.models.ImageTag]
    :param description: A collection of content tags, along with a list of
     captions sorted by confidence level, and image metadata.
    :type description:
     ~azure.cognitiveservices.vision.computervision.models.ImageDescriptionDetails
    :param faces: An array of possible faces within the image.
    :type faces:
     list[~azure.cognitiveservices.vision.computervision.models.FaceDescription]
    :param objects: Array of objects describing what was detected in the
     image.
    :type objects:
     list[~azure.cognitiveservices.vision.computervision.models.DetectedObject]
    :param brands: Array of brands detected in the image.
    :type brands:
     list[~azure.cognitiveservices.vision.computervision.models.DetectedBrand]
    :param request_id: Id of the REST API request.
    :type request_id: str
    :param metadata:
    :type metadata:
     ~azure.cognitiveservices.vision.computervision.models.ImageMetadata
    """

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[Category]'},
        'adult': {'key': 'adult', 'type': 'AdultInfo'},
        'color': {'key': 'color', 'type': 'ColorInfo'},
        'image_type': {'key': 'imageType', 'type': 'ImageType'},
        'tags': {'key': 'tags', 'type': '[ImageTag]'},
        'description': {'key': 'description', 'type': 'ImageDescriptionDetails'},
        'faces': {'key': 'faces', 'type': '[FaceDescription]'},
        'objects': {'key': 'objects', 'type': '[DetectedObject]'},
        'brands': {'key': 'brands', 'type': '[DetectedBrand]'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': 'ImageMetadata'},
    }

    def __init__(self, **kwargs):
        super(ImageAnalysis, self).__init__(**kwargs)
        self.categories = kwargs.get('categories', None)
        self.adult = kwargs.get('adult', None)
        self.color = kwargs.get('color', None)
        self.image_type = kwargs.get('image_type', None)
        self.tags = kwargs.get('tags', None)
        self.description = kwargs.get('description', None)
        self.faces = kwargs.get('faces', None)
        self.objects = kwargs.get('objects', None)
        self.brands = kwargs.get('brands', None)
        self.request_id = kwargs.get('request_id', None)
        self.metadata = kwargs.get('metadata', None)
