/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.info.ChartCoordinates;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.geom.Geom;
import org.brunel.geom.Point;
import org.brunel.geom.Poly;
import org.brunel.geom.Rect;
import org.brunel.maps.GeoData;
import org.brunel.maps.GeoFile;
import org.brunel.maps.GeoMapping;
import org.brunel.maps.LabelPoint;
import org.brunel.maps.projection.Projection;
import org.brunel.maps.projection.ProjectionBuilder;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class GeoInformation {
    private static final String KEY_GEO_NAMES = "geo names";
    private final Map<VisSingle, GeoMapping> geo;
    private final VisSingle[] elements;
    private final Poly hull;
    private final boolean needsExpansion;
    private final Projection projection;

    public static String getIDField(VisSingle vis) {
        if (vis.fKeys.isEmpty()) {
            if (vis.positionFields().length == 0) {
                return null;
            }
            return vis.positionFields()[0];
        }
        return vis.fKeys.get(0).asField();
    }

    public static double fractionGeoNames(Field f) {
        if (f.property(KEY_GEO_NAMES) == null) {
            double count = 0.0;
            if (!f.isNumeric()) {
                HashSet<Object> unmatched = new HashSet<Object>();
                GeoData.instance().mapFeaturesToFiles(f.categories(), unmatched);
                for (int i = 0; i < f.rowCount(); ++i) {
                    if (unmatched.contains(f.value(i))) continue;
                    count += 1.0;
                }
            }
            f.set(KEY_GEO_NAMES, (Object)(count / (double)f.valid()));
        }
        return f.numProperty(KEY_GEO_NAMES);
    }

    public List<LabelPoint> getLabelsWithinScaleBounds() {
        ArrayList<LabelPoint> points = new ArrayList<LabelPoint>();
        for (GeoMapping g : this.geo.values()) {
            for (GeoFile f : g.files) {
                for (LabelPoint p : f.pts) {
                    if (!this.hull.bounds.contains(p)) continue;
                    points.add(p);
                }
            }
        }
        Collections.sort(points, LabelPoint.COMPARATOR);
        return points;
    }

    public GeoInformation(VisSingle[] elements, Dataset[] datas, ChartCoordinates positionFields) {
        this.elements = elements;
        Poly positionHull = this.getPositionPoints(positionFields);
        this.geo = this.makeGeoMappings(datas, positionHull);
        Poly withoutReferenceMaps = this.combineForHull(positionHull, this.geo, false);
        if (withoutReferenceMaps.count() == 0) {
            this.hull = this.combineForHull(positionHull, this.geo, true);
            this.needsExpansion = false;
        } else {
            this.hull = withoutReferenceMaps;
            this.needsExpansion = true;
        }
        this.projection = ProjectionBuilder.makeProjection(this.adjustForUS());
    }

    private Rect adjustForUS() {
        Rect hawaii = new Rect(-181.0, -154.0, 18.0, 30.0);
        Rect alaskanIslandsA = new Rect(-181.0, -165.0, 50.0, 55.0);
        Rect alaskanIslandsB = new Rect(170.0, 181.0, 50.0, 55.0);
        Rect bounds = this.hull.bounds;
        if (bounds.left < -179.0 && bounds.right > 179.0) {
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            for (Point p : this.hull.points) {
                if (hawaii.contains(p) || alaskanIslandsA.contains(p) || alaskanIslandsB.contains(p)) continue;
                minX = Math.min(minX, p.x);
                maxX = Math.max(maxX, p.x);
            }
            if (maxX > minX) {
                return new Rect(minX, maxX, bounds.top, bounds.bottom);
            }
        }
        return bounds;
    }

    private Poly combineForHull(Poly pointsHull, Map<VisSingle, GeoMapping> geo, boolean includeReferenceMaps) {
        ArrayList<Point> combined = new ArrayList<Point>();
        Collections.addAll(combined, pointsHull.points);
        for (GeoMapping g : geo.values()) {
            if (g == null || !includeReferenceMaps && g.isReference()) continue;
            for (GeoFile f : g.files) {
                Collections.addAll(combined, f.hull.points);
            }
        }
        return Geom.makeConvexHull(combined);
    }

    public String d3Definition() {
        Rect rect = this.adjustForUS();
        if (this.needsExpansion) {
            rect = rect.expand(0.1);
        }
        return this.projection.d3Definition(rect);
    }

    private Poly getPositionPoints(ChartCoordinates positionFields) {
        HashSet<Point> points = new HashSet<Point>();
        for (VisSingle e : this.elements) {
            Field[] xx = positionFields.getX(e);
            Field[] yy = positionFields.getY(e);
            for (Field x : xx) {
                for (Field y : yy) {
                    for (int i = 0; i < x.rowCount(); ++i) {
                        Double a = Data.asNumeric((Object)x.value(i));
                        Double b = Data.asNumeric((Object)y.value(i));
                        if (a == null || b == null) continue;
                        points.add(new Point(a, b));
                    }
                }
            }
        }
        return Geom.makeConvexHull(points);
    }

    public GeoMapping getGeo(VisSingle e) {
        return this.geo.get(e);
    }

    public Rect projectedBounds() {
        return this.projection.projectedBounds(this.hull.points);
    }

    public Point transform(Point p) {
        return this.projection.transform(p);
    }

    private Map<VisSingle, GeoMapping> makeGeoMappings(Dataset[] datas, Poly positionHull) {
        LinkedHashMap<VisSingle, GeoMapping> map = new LinkedHashMap<VisSingle, GeoMapping>();
        GeoFile[] validFiles = null;
        for (int i = 0; i < this.elements.length; ++i) {
            GeoMapping mapping;
            if (this.elements[i].tDiagram != VisTypes.Diagram.map || (mapping = GeoInformation.makeMapping(this.elements[i], datas[i], positionHull)) == null) continue;
            map.put(this.elements[i], mapping);
            if (validFiles != null) continue;
            validFiles = mapping.files;
        }
        if (validFiles == null) {
            GeoMapping world = GeoData.instance().world();
            validFiles = world.files;
            for (VisSingle e : this.elements) {
                if (e.tDiagram != VisTypes.Diagram.map || e.tDiagramParameters.length != 0) continue;
                map.put(e, world);
            }
        }
        for (VisSingle e : this.elements) {
            if (e.tDiagram != VisTypes.Diagram.map || map.get(e) != null) continue;
            map.put(e, GeoMapping.createGeoMapping(new Object[0], Arrays.asList(validFiles), GeoData.instance()));
        }
        return map;
    }

    private static GeoMapping makeMapping(VisSingle e, Dataset data, Poly positionHull) {
        String idField = GeoInformation.getIDField(e);
        Param[] diagramParameters = e.tDiagramParameters;
        if (idField != null) {
            return GeoData.instance().make(data.field(idField).categories(), diagramParameters);
        }
        if (positionHull.count() > 0 || diagramParameters != null) {
            return GeoData.instance().makeForPoints(positionHull, diagramParameters);
        }
        return null;
    }
}

