/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.geom;

import java.util.Collection;
import org.brunel.geom.Geom;
import org.brunel.geom.Point;
import org.brunel.geom.Rect;

public class Poly {
    public final Point[] points;
    public final Rect bounds;

    public Poly(Collection<Point> points) {
        this(points.toArray(new Point[points.size()]));
    }

    public Poly(Point ... points) {
        this.points = points;
        this.bounds = Geom.bounds(points);
    }

    public boolean contains(Point p) {
        if (!this.bounds.contains(p)) {
            return false;
        }
        int intersectCountLeft = 0;
        int N = this.points.length;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            double yj = this.points[j].y;
            double yi = this.points[i].y;
            double xj = this.points[j].x;
            double xi = this.points[i].x;
            double m = (yj - yi) / (xj - xi);
            if (Double.isNaN(m) || Math.abs(m) < 1.0E-6) continue;
            if (Math.abs(m) > 1000000.0) {
                double iy = p.y;
                if (!(iy > yi && iy < yj) && (!(iy > yj - 0.0) || !(iy < yi)) || !(xi < p.x)) continue;
                if (Math.abs(iy - yi) == 0.0) {
                    if (!(yj > p.y)) continue;
                    ++intersectCountLeft;
                    continue;
                }
                if (Math.abs(iy - yj) == 0.0) {
                    if (!(yi > p.y)) continue;
                    ++intersectCountLeft;
                    continue;
                }
                ++intersectCountLeft;
                continue;
            }
            double b = yi - m * xi;
            double ix = (p.y - b) / m;
            if (!(ix > xi && ix < xj) && (!(ix > xj) || !(ix < xi)) || !(ix < p.x)) continue;
            if (Math.abs(p.y - yi) == 0.0) {
                if (!(yj > p.y)) continue;
                ++intersectCountLeft;
                continue;
            }
            if (Math.abs(p.y - yj) == 0.0) {
                if (!(yi > p.y)) continue;
                ++intersectCountLeft;
                continue;
            }
            ++intersectCountLeft;
        }
        return intersectCountLeft % 2 != 0;
    }

    public final int count() {
        return this.points.length;
    }
}

