/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.element;

import org.brunel.build.d3.element.ElementDimension;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.d3.element.GeomAttribute;
import org.brunel.build.util.ModelUtil;
import org.brunel.data.Data;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class ElementDetails {
    public final String dataSource;
    public final ElementRepresentation representation;
    public final String classes;
    private final String userDefinedLabelPosition;
    private final boolean strokedShape;
    public final ElementDimension x;
    public final ElementDimension y;
    public GeomAttribute overallSize;
    private GeomAttribute refLocation;
    public GeomAttribute clusterSize;

    public static ElementDetails makeForCoordinates(VisSingle vis, String symbol) {
        VisTypes.Element element = vis.tElement;
        ElementRepresentation representation = ElementRepresentation.makeForCoordinateElement(element, symbol, vis);
        String dataSource = element.producesSingleShape ? "splits" : "data._rows";
        boolean filled = element.filled || !vis.fSize.isEmpty() && (element == VisTypes.Element.line || element == VisTypes.Element.path);
        return new ElementDetails(vis, representation, element.name(), dataSource, filled);
    }

    public static ElementDetails makeForDiagram(VisSingle vis, ElementRepresentation representation, String elementClass, String dataSource) {
        return new ElementDetails(vis, representation, elementClass, dataSource, representation != ElementRepresentation.segment);
    }

    public GeomAttribute getRefLocation() {
        return this.refLocation;
    }

    public boolean isDrawnAsPath() {
        return this.representation.isDrawnAsPath();
    }

    public void setReferences(String[] references) {
        this.refLocation = GeomAttribute.makeFunction("[" + Data.join((Object[])references) + "]");
    }

    public ElementDetails(VisSingle vis, ElementRepresentation representation, String classes, String dataSource, boolean filled) {
        this.x = new ElementDimension(vis, "width");
        this.y = new ElementDimension(vis, "height");
        if (filled) {
            classes = classes + " filled";
        }
        this.strokedShape = !filled;
        this.dataSource = dataSource;
        this.representation = representation;
        this.classes = "'element " + classes + "'";
        this.userDefinedLabelPosition = ModelUtil.getLabelPosition(vis);
    }

    public String getTextMethod() {
        return this.userDefinedLabelPosition != null ? this.userDefinedLabelPosition : this.representation.getDefaultTextMethod();
    }

    public boolean requiresSplitting() {
        return this.dataSource.equals("splits");
    }

    public boolean isStroked() {
        return this.strokedShape;
    }

    public boolean textFitsShape() {
        return "inside".equals(this.userDefinedLabelPosition) || this.representation.textFitsShape();
    }
}

