/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.d3.AxisDetails;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.ScalePurpose;
import org.brunel.build.info.ChartCoordinates;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.color.ColorMapping;
import org.brunel.color.Palette;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.auto.Auto;
import org.brunel.data.auto.NumericScale;
import org.brunel.data.util.DateFormat;
import org.brunel.data.util.Range;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3ScaleBuilder {
    final VisTypes.Coordinates coords;
    private final Field colorLegendField;
    private final AxisDetails hAxis;
    private final AxisDetails vAxis;
    private final double[] marginTLBR;
    private final ChartStructure structure;
    private final VisSingle[] elements;
    private final ScriptWriter out;

    public D3ScaleBuilder(ChartStructure structure, double chartWidth, double chartHeight, ScriptWriter out) {
        this.structure = structure;
        this.elements = structure.elements;
        this.out = out;
        this.coords = this.makeCombinedCoords();
        AxisSpec[] axes = this.makeCombinedAxes();
        this.colorLegendField = this.getColorLegendField();
        ChartCoordinates coords = structure.coordinates;
        AxisDetails xAxis = axes[0] != null ? new AxisDetails("x", coords.allXFields, coords.xCategorical, axes[0].name, axes[0].ticks) : new AxisDetails("x", new Field[0], coords.xCategorical, null, 9999);
        AxisDetails yAxis = axes[1] != null ? new AxisDetails("y", coords.allYFields, coords.yCategorical, axes[1].name, axes[1].ticks) : new AxisDetails("y", new Field[0], coords.yCategorical, null, 9999);
        if (this.coords == VisTypes.Coordinates.transposed) {
            this.hAxis = yAxis;
            this.vAxis = xAxis;
        } else {
            this.hAxis = xAxis;
            this.vAxis = yAxis;
        }
        int legendWidth = this.legendWidth();
        this.vAxis.layoutVertically(chartHeight - (double)this.hAxis.estimatedSimpleSizeWhenHorizontal());
        this.hAxis.layoutHorizontally(chartWidth - (double)this.vAxis.size - (double)legendWidth, this.elementsFillHorizontal(ScalePurpose.x));
        int marginTop = this.vAxis.topGutter;
        int marginLeft = Math.max(this.vAxis.size, this.hAxis.leftGutter);
        int marginBottom = Math.max(this.hAxis.size, this.vAxis.bottomGutter);
        int marginRight = Math.max(this.hAxis.rightGutter, legendWidth);
        this.marginTLBR = new double[]{marginTop, marginLeft, marginBottom, marginRight};
    }

    public boolean needsLegends() {
        return this.colorLegendField != null;
    }

    private VisTypes.Coordinates makeCombinedCoords() {
        if (this.structure.diagram == VisTypes.Diagram.chord || this.structure.diagram == VisTypes.Diagram.cloud) {
            return VisTypes.Coordinates.polar;
        }
        VisTypes.Coordinates result = this.elements[0].coords;
        for (VisSingle e : this.elements) {
            if (e.coords.compareTo(result) <= 0) continue;
            result = e.coords;
        }
        return result;
    }

    private AxisSpec[] makeCombinedAxes() {
        AxisSpec x = null;
        AxisSpec y = null;
        boolean auto = true;
        for (VisSingle e : this.elements) {
            if (e.fAxes.containsKey((Object)VisTypes.Axes.none)) {
                return new AxisSpec[2];
            }
            for (Map.Entry<VisTypes.Axes, Param[]> p : e.fAxes.entrySet()) {
                auto = false;
                VisTypes.Axes key = p.getKey();
                Param[] value = p.getValue();
                if (key == VisTypes.Axes.x) {
                    x = (x == null ? AxisSpec.DEFAULT : x).merge(value);
                    continue;
                }
                if (key != VisTypes.Axes.y) continue;
                y = (y == null ? AxisSpec.DEFAULT : y).merge(value);
            }
        }
        if (auto) {
            if (this.coords == VisTypes.Coordinates.polar || this.structure.diagram != null || this.structure.nested()) {
                return new AxisSpec[2];
            }
            return new AxisSpec[]{AxisSpec.DEFAULT, AxisSpec.DEFAULT};
        }
        return new AxisSpec[]{x, y};
    }

    private Field getColorLegendField() {
        Field result = null;
        for (VisSingle vis : this.elements) {
            boolean auto;
            boolean bl = auto = vis.tLegends == VisTypes.Legends.auto;
            if (auto && this.structure.nested() || vis.fColor.isEmpty() || vis.tLegends == VisTypes.Legends.none) continue;
            Field f = this.fieldById(this.getColor(vis).asField(), vis);
            if (auto && f.name.equals("#selection")) continue;
            if (result == null) {
                result = f;
                continue;
            }
            if (this.same(result, f)) continue;
            return null;
        }
        return result;
    }

    private int legendWidth() {
        if (!this.needsLegends()) {
            return 0;
        }
        AxisDetails legendAxis = new AxisDetails("color", new Field[]{this.colorLegendField}, this.colorLegendField.preferCategorical(), null, 9999);
        int spaceNeededForTicks = 32 + legendAxis.maxCategoryWidth();
        int spaceNeededForTitle = this.colorLegendField.label.length() * 7;
        return 6 + Math.max(spaceNeededForTicks, spaceNeededForTitle);
    }

    private boolean elementsFillHorizontal(ScalePurpose purpose) {
        for (VisSingle e : this.elements) {
            if (e.tElement != VisTypes.Element.line && e.tElement != VisTypes.Element.area) {
                return false;
            }
            if (purpose != ScalePurpose.x || e.fX.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private Field fieldById(String fieldName, VisSingle vis) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] != vis) continue;
            Field field = this.structure.elementStructure[i].data.field(fieldName);
            if (field == null) {
                throw new IllegalStateException("Unknown field " + fieldName);
            }
            return field;
        }
        throw new IllegalStateException("Passed in a vis that was not part of the system defined in the constructor");
    }

    private Param getColor(VisSingle vis) {
        return vis.fColor.isEmpty() ? null : vis.fColor.get(0);
    }

    private boolean same(Field a, Field b) {
        return a.name.equals(b.name) && a.preferCategorical() == b.preferCategorical();
    }

    public boolean allNumeric(Field[] fields) {
        for (Field f : fields) {
            if (f.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public Double getGranularitySuitableForSizing(Field[] ff) {
        Double r = null;
        for (Field f : ff) {
            Double g;
            if (f.isDate() || (g = f.numProperty("granularity")) == null || !(g / (f.max() - f.min()) > 0.02) || r != null && !(g < r)) continue;
            r = g;
        }
        return r;
    }

    public double[] marginsTLBR() {
        return this.marginTLBR;
    }

    public boolean needsAxes() {
        return this.hAxis.exists() || this.vAxis.exists();
    }

    public void writeAestheticScales(VisSingle vis) {
        Param color = this.getColor(vis);
        Param[] size = this.getSize(vis);
        Param opacity = this.getOpacity(vis);
        if (color == null && opacity == null && size.length == 0) {
            return;
        }
        this.out.onNewLine().comment("Aesthetic Functions");
        if (color != null) {
            this.addColorScale(color, vis);
            this.out.onNewLine().add("var color = function(d) { return scale_color(" + D3Util.writeCall(this.fieldById(color, vis)) + ") }").endStatement();
        }
        if (opacity != null) {
            this.addOpacityScale(opacity, vis);
            this.out.onNewLine().add("var opacity = function(d) { return scale_opacity(" + D3Util.writeCall(this.fieldById(opacity, vis)) + ") }").endStatement();
        }
        if (size.length == 1) {
            String defaultTransform = vis.tElement == VisTypes.Element.point || vis.tElement == VisTypes.Element.text ? "sqrt" : "linear";
            this.addSizeScale("size", size[0], vis, defaultTransform);
            this.out.onNewLine().add("var size = function(d) { return scale_size(" + D3Util.writeCall(this.fieldById(size[0], vis)) + ") }").endStatement();
        } else if (size.length > 1) {
            this.addSizeScale("width", size[0], vis, "linear");
            this.addSizeScale("height", size[1], vis, "linear");
            this.out.onNewLine().add("var width = function(d) { return scale_width(" + D3Util.writeCall(this.fieldById(size[0], vis)) + ") }").endStatement();
            this.out.onNewLine().add("var height = function(d) { return scale_height(" + D3Util.writeCall(this.fieldById(size[1], vis)) + ") }").endStatement();
        }
    }

    public void writeAxes() {
        if (!this.hAxis.exists() && !this.vAxis.exists()) {
            return;
        }
        String width = "geom.inner_width";
        String height = "geom.inner_height";
        if (this.coords == VisTypes.Coordinates.transposed) {
            String t = width;
            width = height;
            height = t;
        }
        if (this.hAxis.exists()) {
            this.out.onNewLine().add("axes.append('g').attr('class', 'x axis')").addChained("attr('transform','translate(0,' + " + height + " + ')')").endStatement();
            if (this.hAxis.title != null) {
                this.out.add("axes.select('g.axis.x').append('text').attr('class', 'title')").addChained("attr('text-anchor', 'middle')").addChained("attr('x', " + width + "/2)").addChained("attr('y', geom.inner_bottom - 6)").addChained("text(" + Data.quote((String)this.hAxis.title) + ")").endStatement();
            }
        }
        if (this.vAxis.exists()) {
            this.out.onNewLine().add("axes.append('g').attr('class', 'y axis')").addChained("attr('transform','translate(geom.chart_left, 0)')").endStatement();
            if (this.vAxis.title != null) {
                this.out.add("axes.select('g.axis.y').append('text').attr('class', 'title')").addChained("attr('text-anchor', 'middle')").addChained("attr('x', -" + height + "/2)").addChained("attr('y', 6-geom.inner_left).attr('dy', '0.7em').attr('transform', 'rotate(270)')").addChained("text(" + Data.quote((String)this.vAxis.title) + ")").endStatement();
            }
        }
        this.out.onNewLine().ln();
        this.defineAxis("var axis_bottom = d3.svg.axis()", this.hAxis);
        this.defineAxis("var axis_left = d3.svg.axis().orient('left')", this.vAxis);
        this.defineAxesBuild();
    }

    private void defineAxis(String basicDefinition, AxisDetails axis) {
        if (axis.exists()) {
            this.out.add(basicDefinition).addChained("scale(" + axis.scale + ").innerTickSize(3).outerTickSize(0)");
            if (axis.tickValues != null) {
                this.out.addChained("tickValues([").addQuoted(axis.tickValues).add("])");
            }
            if (axis.isLog()) {
                this.out.addChained("ticks(7, ',.g3')");
            } else if (axis.tickCount != null) {
                this.out.addChained("ticks(").add(axis.tickCount).add(")");
            } else if (axis == this.hAxis) {
                this.out.addChained("ticks(Math.min(10, Math.round(geom.inner_width / " + 1.5 * (double)axis.maxCategoryWidth() + ")))");
            }
            if (axis.inMillions()) {
                this.out.addChained("tickFormat(  function(x) { return BrunelData.Data.format(x/1e6) + 'M' })");
            }
            this.out.endStatement();
        }
    }

    private void defineAxesBuild() {
        this.out.onNewLine().ln().add("function buildAxes() {").indentMore();
        if (this.hAxis.exists()) {
            this.out.onNewLine().add("axes.select('g.axis.x').call(axis_bottom)");
            if (this.hAxis.rotatedTicks) {
                this.addRotateTicks();
            }
            this.out.endStatement();
        }
        if (this.vAxis.exists()) {
            this.out.onNewLine().add("axes.select('g.axis.y').call(axis_left)");
            if (this.vAxis.rotatedTicks) {
                this.addRotateTicks();
            }
            this.out.endStatement();
        }
        this.out.indentLess().add("}").ln();
    }

    private void addRotateTicks() {
        this.out.add(".selectAll('.tick text')").addChained("style('text-anchor', 'end')").addChained("attr('dx', '-.3em')").addChained("attr('dy', '.6em')").addChained("attr('transform', function(d) { return 'rotate(-45)' })");
    }

    public void writeCoordinateScales(D3Interaction interaction) {
        this.writePositionScale(ScalePurpose.x, this.structure.coordinates.allXFields, this.getXRange(), this.elementsFillHorizontal(ScalePurpose.x));
        this.writePositionScale(ScalePurpose.inner, this.structure.coordinates.allXClusterFields, "[-0.5, 0.5]", this.elementsFillHorizontal(ScalePurpose.inner));
        this.writePositionScale(ScalePurpose.y, this.structure.coordinates.allYFields, this.getYRange(), false);
        interaction.addScaleInteractivity();
    }

    private void writePositionScale(ScalePurpose purpose, Field[] fields, String range, boolean fillToEdge) {
        int categories = this.scaleWithDomain(purpose.name(), fields, purpose, 2, "linear", null);
        if (fields.length == 0) {
            this.out.addChained("range(" + range + ")");
        } else if (categories > 0) {
            if (fillToEdge) {
                this.out.addChained("rangePoints(" + range + ", 0)");
            } else {
                this.out.addChained("rangePoints(" + range + ", 1)");
            }
        } else {
            this.out.addChained("range(" + range + ")");
        }
        this.out.endStatement();
    }

    private String getXRange() {
        boolean reversed;
        if (this.coords == VisTypes.Coordinates.polar) {
            return "[0, geom.inner_radius]";
        }
        boolean bl = reversed = this.coords == VisTypes.Coordinates.transposed && this.structure.coordinates.xCategorical;
        if (this.reverseRange(this.structure.coordinates.allXFields)) {
            reversed = !reversed;
        }
        return reversed ? "[geom.inner_width,0]" : "[0, geom.inner_width]";
    }

    private String getYRange() {
        if (this.coords == VisTypes.Coordinates.polar) {
            return "[0, Math.PI*2]";
        }
        boolean reversed = false;
        if (this.coords != VisTypes.Coordinates.transposed) {
            boolean bl = reversed = !this.structure.coordinates.yCategorical;
        }
        if (this.reverseRange(this.structure.coordinates.allYFields)) {
            reversed = !reversed;
        }
        return reversed ? "[geom.inner_height,0]" : "[0, geom.inner_height]";
    }

    private boolean reverseRange(Field[] fields) {
        if (fields.length == 0) {
            return false;
        }
        for (Field f : fields) {
            if ("rank".equals(f.strProperty("summary"))) continue;
            return false;
        }
        return true;
    }

    private int scaleWithDomain(String name, Field[] fields, ScalePurpose purpose, int numericDomainDivs, String defaultTransform, Object[] partitionPoints) {
        Field scaleField;
        this.out.onNewLine().add("var", "scale_" + name, "= ");
        if (fields.length == 0) {
            this.out.add("d3.scale.linear().domain([0,1])");
            return -1;
        }
        Field field = fields[0];
        if (ModelUtil.combinationIsCategorical(fields, purpose.isCoord)) {
            List<Object> list = this.getCategories(fields);
            this.out.add("d3.scale.ordinal()").addChained("domain([").addQuotedCollection(list).add("])");
            return list.size();
        }
        double includeZero = this.getIncludeZeroFraction(fields, purpose);
        if (purpose == ScalePurpose.size) {
            includeZero = 1.0;
        }
        Field field2 = scaleField = fields.length == 1 ? field : this.combineNumericFields(fields);
        if (name.equals("x")) {
            if (scaleField == field) {
                scaleField = field.rename(field.name, field.label);
            }
            scaleField.set("transform", (Object)this.structure.coordinates.xTransform);
        }
        if (name.equals("y")) {
            if (scaleField == field) {
                scaleField = field.rename(field.name, field.label);
            }
            scaleField.set("transform", (Object)this.structure.coordinates.yTransform);
        }
        boolean nice = (name.equals("x") || name.equals("y")) && this.coords != VisTypes.Coordinates.polar;
        double[] padding = this.getNumericPaddingFraction(purpose, this.coords);
        if (scaleField.isBinned() || purpose == ScalePurpose.x && this.elementsFillHorizontal(ScalePurpose.x)) {
            nice = false;
            padding = new double[]{0.0, 0.0};
            includeZero = 0.0;
        }
        NumericScale detail = Auto.makeNumericScale((Field)scaleField, (boolean)nice, (double[])padding, (double)includeZero, (int)9, (boolean)false);
        double min = detail.min;
        double max = detail.max;
        Object[] divs = new Object[numericDomainDivs];
        if (field.isDate()) {
            DateFormat dateFormat = (DateFormat)field.property("dateFormat");
            D3Util.DateBuilder dateBuilder = new D3Util.DateBuilder();
            for (int i = 0; i < divs.length; ++i) {
                Object v = partitionPoints == null ? Double.valueOf(min + (max - min) * (double)i / (double)(numericDomainDivs - 1)) : partitionPoints[i];
                divs[i] = dateBuilder.make(Data.asDate((Object)v), dateFormat, true);
            }
            this.out.add("d3.time.scale()");
        } else {
            String transform = null;
            if (name.equals("x")) {
                transform = this.structure.coordinates.xTransform;
            }
            if (name.equals("y")) {
                transform = this.structure.coordinates.yTransform;
            }
            if (purpose == ScalePurpose.size) {
                transform = defaultTransform;
            } else if (transform == null) {
                transform = (String)scaleField.property("transform");
                if (transform == null) {
                    transform = "linear";
                }
                if (transform.equals("linear")) {
                    transform = defaultTransform;
                }
            }
            if (transform.equals("root")) {
                transform = "sqrt";
            }
            this.out.add("d3.scale." + transform + "()");
            for (int i = 0; i < divs.length; ++i) {
                divs[i] = partitionPoints == null ? Double.valueOf(min + (max - min) * (double)i / (double)(numericDomainDivs - 1)) : partitionPoints[i];
            }
        }
        this.out.addChained("domain([").add(Data.join((Object[])divs)).add("])");
        return -1;
    }

    public List<Object> getCategories(Field[] ff) {
        LinkedHashSet all = new LinkedHashSet();
        for (Field f : ff) {
            if (!f.preferCategorical()) continue;
            Collections.addAll(all, f.categories());
        }
        return new ArrayList<Object>(all);
    }

    private double getIncludeZeroFraction(Field[] fields, ScalePurpose purpose) {
        if (purpose == ScalePurpose.x) {
            return 0.1;
        }
        if (purpose == ScalePurpose.size) {
            return 0.9;
        }
        if (purpose == ScalePurpose.color) {
            return 0.2;
        }
        for (Field field : fields) {
            if (!field.name.equals("#count") && !"sum".equals(field.strProperty("summary"))) continue;
            return 1.0;
        }
        for (VisSingle visSingle : this.elements) {
            if (visSingle.tElement != VisTypes.Element.bar && visSingle.tElement != VisTypes.Element.area || visSingle.fRange != null) continue;
            return 0.8;
        }
        return 0.2;
    }

    private Field combineNumericFields(Field[] ff) {
        ArrayList<Double> data = new ArrayList<Double>();
        for (Field f : ff) {
            for (int i = 0; i < f.rowCount(); ++i) {
                Object value = f.value(i);
                if (value instanceof Range) {
                    data.add(Data.asNumeric((Object)((Range)value).low));
                    data.add(Data.asNumeric((Object)((Range)value).high));
                    continue;
                }
                data.add(Data.asNumeric((Object)value));
            }
        }
        Field combined = Fields.makeColumnField((String)"combined", null, (Object[])data.toArray(new Object[data.size()]));
        combined.set("numeric", (Object)true);
        return combined;
    }

    private double[] getNumericPaddingFraction(ScalePurpose purpose, VisTypes.Coordinates coords) {
        double[] padding = new double[]{0.0, 0.0};
        if (purpose == ScalePurpose.color || purpose == ScalePurpose.size) {
            return padding;
        }
        if (coords == VisTypes.Coordinates.polar) {
            return padding;
        }
        for (VisSingle e : this.elements) {
            boolean noBottomYPadding;
            boolean bl = noBottomYPadding = e.tElement == VisTypes.Element.bar || e.tElement == VisTypes.Element.area || e.tElement == VisTypes.Element.line;
            if (e.tElement == VisTypes.Element.text) {
                padding[0] = Math.max(padding[0], 0.1);
                padding[1] = Math.max(padding[1], 0.1);
                continue;
            }
            if (purpose == ScalePurpose.y && noBottomYPadding) {
                padding[1] = Math.max(padding[1], 0.02);
                continue;
            }
            padding[0] = Math.max(padding[0], 0.02);
            padding[1] = Math.max(padding[1], 0.02);
        }
        return padding;
    }

    public void writeLegends(VisSingle vis) {
        String title;
        String legendTicks;
        if (vis.fColor.isEmpty() || this.colorLegendField == null) {
            return;
        }
        if (!vis.fColor.get(0).asField().equals(this.colorLegendField.name)) {
            return;
        }
        String legendLabels = null;
        if (this.colorLegendField.preferCategorical()) {
            legendTicks = "scale_color.domain()";
            if (this.colorLegendField.isBinned() && this.colorLegendField.isNumeric()) {
                legendTicks = legendTicks + ".reverse()";
            }
        } else {
            NumericScale details = Auto.makeNumericScale((Field)this.colorLegendField, (boolean)true, (double[])new double[]{0.0, 0.0}, (double)0.25, (int)7, (boolean)false);
            Object[] divisions = details.divisions;
            if (details.granular) {
                Double[] newDiv = new Double[divisions.length - 1];
                for (int i = 0; i < newDiv.length; ++i) {
                    newDiv[i] = (divisions[i] + (Double)divisions[i + 1]) / 2.0;
                }
                divisions = newDiv;
            }
            for (int i = 0; i < divisions.length / 2; ++i) {
                Double t = divisions[divisions.length - 1 - i];
                divisions[divisions.length - 1 - i] = divisions[i];
                divisions[i] = t;
            }
            if (this.colorLegendField.isDate()) {
                DateFormat dateFormat = (DateFormat)this.colorLegendField.property("dateFormat");
                D3Util.DateBuilder dateBuilder = new D3Util.DateBuilder();
                Object[] divs = new String[divisions.length];
                Object[] labels = new String[divisions.length];
                for (int i = 0; i < divs.length; ++i) {
                    divs[i] = dateBuilder.make(Data.asDate((Object)divisions[i]), dateFormat, true);
                    labels[i] = "'" + this.colorLegendField.format(divisions[i]) + "'";
                }
                legendTicks = "[" + Data.join((Object[])divs) + "]";
                legendLabels = "[" + Data.join((Object[])labels) + "]";
            } else {
                legendTicks = "[" + Data.join((Object[])divisions) + "]";
            }
        }
        if ((title = this.colorLegendField.label) == null) {
            title = this.colorLegendField.name;
        }
        this.out.add("BrunelD3.addLegend(legends, " + this.out.quote(title) + ", scale_color, " + legendTicks);
        if (legendLabels != null) {
            this.out.add(", ").add(legendLabels);
        }
        this.out.add(")").endStatement();
    }

    private void addColorScale(Param p, VisSingle vis) {
        boolean largeElement;
        Field f = this.fieldById(p, vis);
        boolean bl = largeElement = vis.tElement == VisTypes.Element.area || vis.tElement == VisTypes.Element.bar || vis.tElement == VisTypes.Element.polygon;
        if (vis.tDiagram == VisTypes.Diagram.map || vis.tDiagram == VisTypes.Diagram.treemap) {
            largeElement = true;
        }
        if (vis.tElement == VisTypes.Element.path && !vis.fSize.isEmpty()) {
            largeElement = true;
        }
        ColorMapping palette = Palette.makeColorMapping(f, p.modifiers(), largeElement);
        this.scaleWithDomain("color", new Field[]{f}, ScalePurpose.color, palette.values.length, "linear", palette.values);
        this.out.addChained("range([ ").addQuoted(palette.colors).add("])").endStatement();
    }

    private void addOpacityScale(Param p, VisSingle vis) {
        double min = p.hasModifiers() ? p.firstModifier().asDouble() : 0.2;
        Field f = this.fieldById(p, vis);
        this.scaleWithDomain("opacity", new Field[]{f}, ScalePurpose.color, 2, "linear", null);
        if (f.preferCategorical()) {
            int length = f.categories().length;
            double[] sizes = new double[length];
            if (length == 1) {
                sizes[0] = min;
            } else {
                for (int i = 0; i < length; ++i) {
                    sizes[i] = min + (1.0 - min) * (double)i / (double)(length - 1);
                }
            }
            this.out.addChained("range(" + Arrays.toString(sizes) + ")");
        } else {
            this.out.addChained("range([" + min + ", 1])");
        }
        this.out.endStatement();
    }

    private void addSizeScale(String name, Param p, VisSingle vis, String defaultTransform) {
        Object[] sizes = p.modifiers().length > 0 ? this.getSizes(p.modifiers()[0].asList()) : new Object[]{0.05, 1.0};
        Field f = this.fieldById(p, vis);
        Object[] divisions = f.isNumeric() ? null : f.categories();
        this.scaleWithDomain(name, new Field[]{f}, ScalePurpose.size, sizes.length, defaultTransform, divisions);
        this.out.addChained("range([ ").add(Data.join((Object[])sizes)).add("])").endStatement();
    }

    private Field fieldById(Param p, VisSingle vis) {
        return this.fieldById(p.asField(), vis);
    }

    private Param getOpacity(VisSingle vis) {
        return vis.fOpacity.isEmpty() ? null : vis.fOpacity.get(0);
    }

    private Param[] getSize(VisSingle vis) {
        List<Param> fSize = vis.fSize;
        return fSize.toArray(new Param[fSize.size()]);
    }

    private Object[] getSizes(List<Param> params) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (Param p : params) {
            Double d;
            String s = p.asString();
            if (s.endsWith("%")) {
                s = s.substring(0, s.length() - 1);
            }
            if ((d = Data.asNumeric((Object)s)) == null) continue;
            result.add(d / 100.0);
        }
        if (result.isEmpty()) {
            return new Object[]{0.05, 1.0};
        }
        if (result.size() == 1) {
            result.add(0, 0.05);
        }
        return result.toArray(new Object[result.size()]);
    }

    private static final class AxisSpec {
        static final AxisSpec DEFAULT = new AxisSpec();
        final int ticks;
        final String name;

        private AxisSpec() {
            this.ticks = 9999;
            this.name = null;
        }

        public AxisSpec(int ticks, String name) {
            this.ticks = ticks;
            this.name = name;
        }

        public AxisSpec merge(Param[] params) {
            AxisSpec result = this;
            for (Param p : params) {
                if (p.type() == Param.Type.number) {
                    result = new AxisSpec(Math.min((int)p.asDouble(), result.ticks), result.name);
                }
                if (p.type() != Param.Type.string) continue;
                result = new AxisSpec(result.ticks, p.asString());
            }
            return result;
        }
    }
}

