/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.AbstractBuilder;
import org.brunel.build.controls.Controls;
import org.brunel.build.d3.D3DataBuilder;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.d3.diagrams.GeoMap;
import org.brunel.build.d3.element.D3ElementBuilder;
import org.brunel.build.data.DataTransformParameters;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.BuilderOptions;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.model.VisItem;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3Builder
extends AbstractBuilder {
    private static final String COPYRIGHT_COMMENTS = "\t<!--\n\t\tD3 Copyright \u00a9 2012, Michael Bostock\n\t\tjQuery Copyright \u00a9 2010 by The jQuery Project\n\t\tsumoselect Copyright \u00a9 2014 Hemant Negi\n \t-->\n";
    private ScriptWriter out;
    private int visWidth;
    private int visHeight;
    private D3ScaleBuilder scalesBuilder;
    private D3Interaction interaction;
    private D3ElementBuilder[] elementBuilders;

    public static D3Builder make() {
        return D3Builder.make(new BuilderOptions());
    }

    public static D3Builder make(BuilderOptions options) {
        return new D3Builder(options);
    }

    private D3Builder(BuilderOptions options) {
        super(options);
    }

    @Override
    public Object getVisualization() {
        return this.out.content();
    }

    @Override
    public String makeImports() {
        String pattern = "\t<script src=\"%s\" charset=\"utf-8\"></script>\n";
        String base = COPYRIGHT_COMMENTS + String.format(pattern, "http://cdnjs.cloudflare.com/ajax/libs/d3/3.5.5/d3.min.js");
        if (this.getControls().isNeeded()) {
            base = base + String.format(pattern, "http://code.jquery.com/jquery-1.10.2.js") + String.format(pattern, "http://code.jquery.com/ui/1.11.4/jquery-ui.js");
        }
        if (this.options.locJavaScript.startsWith("file")) {
            base = base + String.format(pattern, this.options.locJavaScript + "/BrunelData.js") + String.format(pattern, this.options.locJavaScript + "/BrunelD3.js");
            if (this.getControls().isNeeded()) {
                base = base + String.format(pattern, this.options.locJavaScript + "/BrunelEventHandlers.js") + String.format(pattern, this.options.locJavaScript + "/BrunelJQueryControlFactory.js") + String.format(pattern, this.options.locJavaScript + "/sumoselect/jquery.sumoselect.min.js");
            }
        } else {
            base = base + String.format(pattern, this.options.locJavaScript + "/brunel." + this.options.version + ".min.js");
            if (this.getControls().isNeeded()) {
                base = base + String.format(pattern, this.options.locJavaScript + "/brunel.controls." + this.options.version + ".min.js");
            }
        }
        return base;
    }

    @Override
    protected void defineChart(ChartStructure structure, double[] location) {
        double[] chartMargins = new double[]{location[0] / 100.0, location[1] / 100.0, location[2] / 100.0, location[3] / 100.0};
        this.createBuilders(structure, chartMargins);
        this.out.titleComment("Define chart #" + structure.chartID(), "in the visualization");
        this.out.add("charts[" + structure.chartIndex + "] = function(parentNode, filterRows) {").ln();
        this.out.indentMore();
        double[] margins = this.scalesBuilder.marginsTLBR();
        this.out.add("var geom = BrunelD3.geometry(parentNode || vis.node(),", chartMargins, ",", margins, "),").indentMore().onNewLine().add("elements = [];").at(50).comment("Array of elements in this chart").indentLess();
        if (this.scalesBuilder.coords == VisTypes.Coordinates.transposed) {
            this.out.add("geom.transpose()").endStatement();
        }
        for (D3ElementBuilder builder : this.elementBuilders) {
            builder.writePerChartDefinitions();
        }
        this.out.titleComment("Define groups for the chart parts");
        this.interaction = new D3Interaction(structure, this.scalesBuilder, this.out);
        this.writeMainGroups(structure);
        if (structure.geo != null) {
            this.out.titleComment("Projection");
            GeoMap.writeProjection(this.out, structure.geo);
        }
        if (structure.diagram == null) {
            this.out.titleComment("Scales");
            this.scalesBuilder.writeCoordinateScales(this.interaction);
            if (this.scalesBuilder.needsAxes()) {
                this.out.titleComment("Axes");
                this.scalesBuilder.writeAxes();
            }
        }
    }

    private void createBuilders(ChartStructure structure, double[] chartMargins) {
        double chartWidth = (double)this.visWidth - chartMargins[1] - chartMargins[3];
        double chartHeight = (double)this.visHeight - chartMargins[0] - chartMargins[2];
        this.scalesBuilder = new D3ScaleBuilder(structure, chartWidth, chartHeight, this.out);
        ElementStructure[] structures = structure.elementStructure;
        this.elementBuilders = new D3ElementBuilder[structures.length];
        for (int i = 0; i < structures.length; ++i) {
            this.elementBuilders[i] = new D3ElementBuilder(structures[i], this.out, this.scalesBuilder);
        }
    }

    @Override
    protected void defineElement(ElementStructure structure) {
        D3ElementBuilder elementBuilder = this.elementBuilders[structure.index];
        this.out.titleComment("Define element #" + structure.elementID());
        this.out.add("elements[" + structure.index + "] = function() {").indentMore();
        this.out.onNewLine().add("var original, processed,").at(40).comment("data sets passed in and then transformed").indentMore().onNewLine().add("element, data,").at(40).comment("Brunel element information and brunel data").onNewLine().add("selection;").at(40).comment("D3 selection").indentLess();
        this.addElementGroups(elementBuilder, "element" + structure.elementID());
        int datasetIndex = structure.getBaseDatasetIndex();
        VisSingle vis = structure.vis;
        D3DataBuilder dataBuilder = new D3DataBuilder(vis, this.out, structure.data, datasetIndex);
        dataBuilder.writeDataManipulation(this.createResultFields(vis));
        this.scalesBuilder.writeAestheticScales(vis);
        this.scalesBuilder.writeLegends(vis);
        elementBuilder.preBuildDefinitions();
        this.out.titleComment("Build element from data");
        this.out.add("function build(transitionMillis) {").ln().indentMore();
        elementBuilder.generate(structure.index);
        this.interaction.addElementHandlers(structure.vis);
        Integer index = structure.chart.innerChartIndex;
        if (index != null) {
            String id = ChartStructure.makeChartID(index);
            this.out.onNewLine().comment("Build the faceted charts within this chart's selection");
            this.out.add("vis.select('g.chart" + id + "').selectAll('*').remove()").endStatement().add("BrunelD3.facet(charts[" + index + "], element, transitionMillis)").endStatement();
        }
        this.out.indentLess().onNewLine().add("}").ln().ln();
        this.addElementExports(vis);
        this.out.indentLess().onNewLine().add("}()").endStatement().ln();
    }

    @Override
    protected void defineVisSystem(VisItem main, int width, int height) {
        this.visWidth = width;
        this.visHeight = height;
        this.out = new ScriptWriter(this.options);
        this.out.add("function ", this.options.className, "(visId) {").ln().indentMore();
        this.out.add("\"use strict\";").comment("Strict Mode");
        this.out.add("var datasets = [],").at(50).comment("Array of datasets for the original data");
        this.out.add("    pre = function(d, i) { return d },").at(50).comment("Default pre-process does nothing");
        this.out.add("    post = function(d, i) { return d },").at(50).comment("Default post-process does nothing");
        this.out.add("    transitionTime = 200,").at(50).comment("Transition time for animations");
        this.out.add("    charts = [],").at(50).comment("The charts in the system");
        this.out.add("    vis = d3.select('#' + visId).attr('class', 'brunel');").at(60).comment("the SVG container");
    }

    @Override
    protected void endChart(ChartStructure structure) {
        int i;
        int i$;
        int len$;
        Object[] arr$;
        this.out.onNewLine().add("function build(time) {").indentMore();
        this.out.onNewLine().add("var first = elements[0].data() == null").endStatement();
        this.out.add("if (first) time = 0;").comment("No transition for first call");
        if (this.scalesBuilder.needsAxes()) {
            this.out.onNewLine().add("buildAxes(); ");
        }
        Integer[] order = structure.elementBuildOrder();
        this.out.onNewLine().add("if (first || time>0) ");
        if (order.length > 1) {
            this.out.add("{").indentMore();
            arr$ = order;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                i = arr$[i$];
                this.out.onNewLine().add("elements[" + i + "].makeData();");
            }
            this.out.indentLess().onNewLine().add("}").ln();
        } else {
            this.out.add("elements[0].makeData()").endStatement();
        }
        arr$ = order;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            i = arr$[i$];
            this.out.onNewLine().add("elements[" + i + "].build(time);");
        }
        for (D3ElementBuilder builder : this.elementBuilders) {
            builder.writeBuildCommands();
        }
        this.out.indentLess().onNewLine().add("}").ln();
        this.out.ln().comment("Expose the following components of the chart");
        this.out.add("return { build : build, elements : elements }").endStatement();
        if (this.nesting.containsKey(structure.chartIndex)) {
            this.out.add("}");
        } else {
            this.out.add("}()");
        }
        this.out.indentLess().endStatement().ln();
    }

    @Override
    protected void endVisSystem(VisItem main) {
        this.out.add("function setData(rowData, i) { datasets[i||0] = BrunelD3.makeData(rowData) }").ln();
        if (this.nesting.isEmpty()) {
            this.out.add("function updateAll(time) { charts.forEach(function(x) {x.build(time || 20)}) }").ln();
        } else {
            this.out.add("function updateAll(time) {").indentMore().ln().add("var t = time || 20").endStatement().add("charts[0].build(0)").endStatement().indentLess().add("}").ln();
        }
        this.out.add("function buildAll() {").ln().indentMore().add("for (var i=0;i<arguments.length;i++) setData(arguments[i], i)").endStatement().add("updateAll(transitionTime)").endStatement();
        this.out.indentLess().add("}").ln().ln();
        this.out.add("return {").indentMore().ln().add("dataPreProcess:").at(24).add("function(f) { if (f) pre = f; return pre },").ln().add("dataPostProcess:").at(24).add("function(f) { if (f) post = f; return post },").ln().add("data:").at(24).add("function(d,i) { if (d) setData(d,i); return datasets[i||0] },").ln().add("visId:").at(24).add("visId,").ln().add("build:").at(24).add("buildAll,").ln().add("rebuild:").at(24).add("updateAll,").ln().add("charts:").at(24).add("charts").ln().indentLess().add("}").ln();
        this.out.indentLess().onNewLine().add("}").ln();
        D3DataBuilder.writeTables(main, this.out, this.options);
        if (this.options.generateBuildCode) {
            this.out.titleComment("Call Code to Build the system");
            this.out.add("var v = new", this.options.className, "(" + this.out.quote(this.options.visIdentifier) + ")").endStatement();
            int length = main.getDataSets().length;
            this.out.add("v.build(");
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    this.out.add(", ");
                }
                this.out.add(String.format(this.options.dataName, i + 1));
            }
            this.out.add(")").endStatement();
        }
        this.controls.write(this.out);
    }

    private void addElementGroups(D3ElementBuilder builder, String elementID) {
        String elementTransform = this.makeElementTransform(this.scalesBuilder.coords);
        this.out.add("var elementGroup = interior.append('g').attr('class', '" + elementID + "')");
        if (elementTransform != null) {
            this.out.addChained(elementTransform);
        }
        if (builder.needsDiagramExtras()) {
            this.out.continueOnNextLine(",").add("diagramExtras = elementGroup.append('g').attr('class', 'extras')");
        }
        this.out.continueOnNextLine(",").add("main = elementGroup.append('g').attr('class', 'main')");
        if (builder.needsDiagramLabels()) {
            this.out.continueOnNextLine(",").add("diagramLabels = BrunelD3.undoTransform(elementGroup.append('g').attr('class', 'diagram labels'), elementGroup)");
        }
        this.out.continueOnNextLine(",").add("labels = BrunelD3.undoTransform(elementGroup.append('g').attr('class', 'labels'), elementGroup)").endStatement();
    }

    private Map<String, Integer> createResultFields(VisSingle vis) {
        LinkedHashSet<String> needed = new LinkedHashSet<String>();
        if (vis.fY.size() > 1) {
            if (vis.stacked) {
                needed.add("#values$lower");
                needed.add("#values$upper");
            }
            needed.add("#series");
            needed.add("#values");
            for (Param p : vis.fX) {
                needed.add(p.asField());
            }
            Collections.addAll(needed, vis.nonPositionFields());
        } else {
            if (vis.stacked) {
                String y = vis.fY.get(0).asField();
                needed.add(y + "$lower");
                needed.add(y + "$upper");
            }
            Collections.addAll(needed, vis.usedFields(true));
        }
        needed.add("#row");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String s : needed) {
            result.put(s, result.size());
        }
        return result;
    }

    private void addElementExports(VisSingle vis) {
        this.out.add("return {").indentMore();
        this.out.onNewLine().add("data:").at(24).add("function() { return processed },");
        this.out.onNewLine().add("internal:").at(24).add("function() { return data },");
        this.out.onNewLine().add("selection:").at(24).add("function() { return selection },");
        this.out.onNewLine().add("makeData:").at(24).add("makeData,");
        this.out.onNewLine().add("build:").at(24).add("build,");
        this.out.onNewLine().add("fields: {").indentMore();
        this.out.mark();
        this.writeFieldName("x", vis.fX);
        this.writeFieldName("y", vis.fY);
        this.writeFieldName("color", vis.fColor);
        this.writeFieldName("size", vis.fSize);
        this.writeFieldName("opacity", vis.fOpacity);
        this.out.onNewLine().indentLess().add("}");
        this.out.indentLess().onNewLine().add("}").endStatement();
    }

    private String makeElementTransform(VisTypes.Coordinates coords) {
        if (coords == VisTypes.Coordinates.transposed) {
            return "attr('transform','matrix(0,1,1,0,0,0)')";
        }
        if (coords == VisTypes.Coordinates.polar) {
            return this.makeTranslateTransform("geom.inner_width/2", "geom.inner_height/2");
        }
        return null;
    }

    private void writeFieldName(String name, List<Param> fieldNames) {
        if (fieldNames.isEmpty()) {
            return;
        }
        if (this.out.changedSinceMark()) {
            this.out.add(",");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Param p : fieldNames) {
            names.add(p.asField());
        }
        this.out.onNewLine().add(name, ":").at(24).add("[").addQuotedCollection(names).add("]");
    }

    private void writeMainGroups(ChartStructure structure) {
        String chartClassID = "chart" + structure.chartID();
        if (structure.nested()) {
            this.out.onNewLine().comment("Nesting -- create an outer chart and place groups inside for each facet");
            this.out.add("var outer = vis.select('g." + chartClassID + "')").endStatement();
            this.out.add("if (outer.empty()) outer = vis.append('g').attr('class', '" + chartClassID + "')").endStatement();
            this.out.add("var chart = outer.append('g').attr('class', 'facet')");
        } else {
            this.out.add("var chart = vis.append('g').attr('class', '" + chartClassID + "')");
        }
        this.out.addChained(this.makeTranslateTransform("geom.chart_left", "geom.chart_top")).endStatement();
        this.out.add("chart.append('rect').attr('class', 'background')").add(".attr('width', geom.chart_right-geom.chart_left).attr('height', geom.chart_bottom-geom.chart_top)").endStatement();
        String axesTransform = this.makeTranslateTransform("geom.inner_left", "geom.inner_top");
        this.out.add("var interior = chart.append('g').attr('class', 'interior')").addChained(axesTransform);
        if (!structure.nested()) {
            this.out.addChained("attr('clip-path', 'url(#" + this.clipID(structure) + ")')");
        }
        this.out.endStatement();
        this.out.add("interior.append('rect').attr('class', 'inner')").add(".attr('width', geom.inner_width).attr('height', geom.inner_height)").endStatement();
        this.interaction.addPrerequisites();
        if (this.scalesBuilder.needsAxes()) {
            this.out.add("var axes = chart.append('g').attr('class', 'axis')").addChained(axesTransform).endStatement();
        }
        if (this.scalesBuilder.needsLegends()) {
            this.out.add("var legends = chart.append('g').attr('class', 'legend')").addChained(this.makeTranslateTransform("(geom.chart_right-geom.chart_left - 3)", "0")).endStatement();
        }
        if (!structure.nested()) {
            this.out.add("vis.append('clipPath').attr('id', '" + this.clipID(structure) + "').append('rect')");
            this.out.addChained("attr('x', -1).attr('y', -1)");
            if (this.scalesBuilder.coords == VisTypes.Coordinates.transposed) {
                this.out.addChained("attr('width', geom.inner_height+2).attr('height', geom.inner_width+2)").endStatement();
            } else {
                this.out.addChained("attr('width', geom.inner_width+2).attr('height', geom.inner_height+2)").endStatement();
            }
        }
    }

    private String makeTranslateTransform(String dx, String dy) {
        return "attr('transform','translate(' + " + dx + " + ',' + " + dy + " + ')')";
    }

    private String clipID(ChartStructure structure) {
        return "clip_" + this.options.visIdentifier + "_" + structure.chartID();
    }

    public Controls getControls() {
        return this.controls;
    }

    public String makeStyleSheets() {
        String pattern = "\t<link rel=\"stylesheet\" type=\"text/css\" href=\"%s\" charset=\"utf-8\"/>\n";
        String base = this.options.locJavaScript.startsWith("file") ? String.format(pattern, this.options.locJavaScript + "/Brunel.css") : String.format(pattern, this.options.locJavaScript + "/brunel." + this.options.version + ".css");
        if (this.getControls().isNeeded()) {
            base = base + String.format(pattern, "http://code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css") + String.format(pattern, this.options.locJavaScript + "/sumoselect.css");
        }
        return base;
    }

    @Override
    public DataTransformParameters modifyParameters(DataTransformParameters params, VisSingle vis) {
        String stackCommand = "";
        String sortRows = params.sortRowsCommand;
        if (vis.stacked) {
            if (vis.fY.size() > 1) {
                stackCommand = "#values";
            } else if (vis.fY.size() == 1) {
                stackCommand = vis.fY.get(0).asField();
            }
            stackCommand = stackCommand + "; " + Data.join(vis.fX) + "; " + Data.join((Object[])vis.aestheticFields()) + "; " + vis.tElement.producesSingleShape;
        } else if (vis.tElement == VisTypes.Element.line || vis.tElement == VisTypes.Element.area) {
            String x = vis.fX.get(0).asField() + ":ascending";
            sortRows = sortRows.isEmpty() ? x : sortRows + "; " + x;
        }
        return new DataTransformParameters(params.constantsCommand, params.filterCommand, params.eachCommand, params.transformCommand, params.summaryCommand, stackCommand, params.sortCommand, sortRows, params.seriesCommand, params.usedCommand);
    }
}

