/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.stats;

import java.util.ArrayList;
import java.util.Arrays;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.util.Range;

public class NumericStats {
    public static void populate(Field f) {
        int n = f.rowCount();
        ArrayList<Double> valid = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            Object item = f.value(i);
            if (item == null) continue;
            if (item instanceof Range) {
                Object low = ((Range)item).low;
                Object high = ((Range)item).high;
                valid.add(Data.asNumeric(low));
                valid.add(Data.asNumeric(high));
                continue;
            }
            Double d = Data.asNumeric(item);
            if (d == null) continue;
            valid.add(d);
        }
        Object[] data = valid.toArray(new Double[valid.size()]);
        n = data.length;
        f.set("validNumeric", n);
        if (n == 0) {
            return;
        }
        double m1 = NumericStats.moment((Double[])data, 0.0, 1, n);
        double m2 = NumericStats.moment((Double[])data, m1, 2, n - 1);
        double m3 = NumericStats.moment((Double[])data, m1, 3, n - 1);
        double m4 = NumericStats.moment((Double[])data, m1, 4, n - 1);
        f.set("mean", m1);
        f.set("stddev", Math.sqrt(m2));
        f.set("variance", m2);
        f.set("skew", m3 / m2 / Math.sqrt(m2));
        f.set("kurtosis", m4 / m2 / m2 - 3.0);
        Arrays.sort(data);
        double min = (Double)data[0];
        double max = (Double)data[n - 1];
        f.set("min", min);
        f.set("max", max);
        f.set("median", NumericStats.av((Double[])data, (double)(n - 1) * 0.5));
        if (n % 2 == 0) {
            f.set("q1", NumericStats.av((Double[])data, (double)(n / 2 - 1) * 0.5));
            f.set("q3", NumericStats.av((Double[])data, (double)(n / 2) + (double)(n / 2 - 1) * 0.5));
        } else {
            f.set("q1", NumericStats.av((Double[])data, (double)(n - 1) * 0.25));
            f.set("q3", NumericStats.av((Double[])data, (double)((n - 1) / 2) + (double)(n - 1) * 0.25));
        }
        double minD = max - min;
        if (minD == 0.0) {
            minD = Math.abs(max);
        }
        for (int i = 1; i < data.length; ++i) {
            double d = (Double)data[i] - (Double)data[i - 1];
            if (!(d > 0.0)) continue;
            minD = Math.min(minD, d);
        }
        f.set("granularity", minD);
    }

    private static double moment(Double[] data, double c, int p, double N) {
        if (N <= 0.0) {
            return Double.NaN;
        }
        double sum = 0.0;
        for (Double element : data) {
            sum += Math.pow(element - c, p);
        }
        return sum / N;
    }

    private static double av(Double[] v, double index) {
        return (v[(int)Math.floor(index)] + v[(int)Math.ceil(index)]) / 2.0;
    }

    public static boolean creates(String key) {
        return "validNumeric".equals(key) || "mean".equals(key) || "stddev".equals(key) || "variance".equals(key) || "skew".equals(key) || "kurtosis".equals(key) || "min".equals(key) || "max".equals(key) || "q1".equals(key) || "q3".equals(key) || "median".equals(key) || "granularity".equals(key);
    }
}

