/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.auto;

import java.util.Date;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.auto.NumericScale;
import org.brunel.data.util.ItemsList;

public class Auto {
    private static final double FRACTION_TO_CONVERT = 0.5;

    public static NumericScale makeNumericScale(Field f, boolean nice, double[] padFraction, double includeZeroTolerance, int desiredTickCount, boolean forBinning) {
        Auto.setTransform(f);
        if (desiredTickCount < 1) {
            desiredTickCount = Math.min(Auto.optimalBinCount(f), 20) + 1;
        }
        if (f.isDate()) {
            return NumericScale.makeDateScale(f, nice, padFraction, desiredTickCount);
        }
        String p = f.strProperty("transform");
        if (p.equals("log")) {
            return NumericScale.makeLogScale(f, nice, padFraction, includeZeroTolerance, desiredTickCount);
        }
        if (p.equals("root") && f.min() > 0.0) {
            double scaling = f.min() / f.max() / (Math.sqrt(f.min()) / Math.sqrt(f.max()));
            includeZeroTolerance *= scaling;
            padFraction[0] = padFraction[0] * scaling;
        }
        return NumericScale.makeLinearScale(f, nice, includeZeroTolerance, padFraction, desiredTickCount, forBinning);
    }

    public static void setTransform(Field f) {
        if (f.property("transform") != null) {
            return;
        }
        Double skew = f.numProperty("skew");
        if (skew == null) {
            f.set("transform", "linear");
            return;
        }
        if (skew > 2.0 && f.min() > 0.0 && f.max() > 75.0 * f.min()) {
            f.set("transform", "log");
        } else if (skew > 1.0 && f.min() >= 0.0) {
            f.set("transform", "root");
        } else {
            f.set("transform", "linear");
        }
    }

    public static int optimalBinCount(Field f) {
        double h2;
        if (!f.isNumeric()) {
            return Math.min(7, f.categories().length);
        }
        double h1 = 2.0 * (f.numProperty("q3") - f.numProperty("q1")) / Math.pow(f.valid(), 0.33333);
        double h = Math.max(h1, h2 = 3.5 * f.numProperty("stddev") / Math.pow(f.valid(), 0.33333));
        if (h == 0.0) {
            return 1;
        }
        return (int)Math.round((f.max() - f.min()) / h + 0.499);
    }

    public static Field convert(Field base) {
        Object o;
        int i;
        int n;
        Field asNumeric;
        int i2;
        if (base.isSynthetic() || base.isDate()) {
            return base;
        }
        if (base.isProperty("list")) {
            return base;
        }
        Field asList = Data.toList(base);
        if (Auto.goodLists(asList)) {
            return asList;
        }
        int N = base.valid();
        int[] order = new int[base.rowCount()];
        for (i2 = 0; i2 < order.length; ++i2) {
            order[i2] = i2;
        }
        for (i2 = 0; i2 < order.length; ++i2) {
            int j = (int)Math.floor(Math.random() * (double)(order.length - i2));
            int t = order[i2];
            order[i2] = order[j];
            order[j] = t;
        }
        if (base.isNumeric()) {
            asNumeric = base;
        } else {
            n = 0;
            i = 0;
            int nNumeric = 0;
            while (n < N && n < 50) {
                if ((o = base.value(order[i++])) == null) continue;
                ++n;
                if (o instanceof Date || Data.asNumeric(o) == null) continue;
                ++nNumeric;
            }
            Field field = asNumeric = (double)nNumeric > 0.5 * (double)n ? Data.toNumeric(base) : null;
        }
        if (asNumeric != null) {
            if (Auto.isYearly(asNumeric)) {
                return Data.toDate(asNumeric, "year");
            }
            return asNumeric;
        }
        n = 0;
        i = 0;
        int nDate = 0;
        while (n < N && n < 50) {
            if ((o = base.value(order[i++])) == null) continue;
            ++n;
            if (Data.asDate(o) == null) continue;
            ++nDate;
        }
        if ((double)nDate > 0.5 * (double)n) {
            return Data.toDate(base);
        }
        return base;
    }

    private static boolean goodLists(Field f) {
        int nValid = f.valid();
        if (nValid < 3) {
            return false;
        }
        int n = -1;
        for (int i = 1; i < f.rowCount(); ++i) {
            ItemsList o = (ItemsList)f.value(i);
            if (o == null) continue;
            if (n < 0) {
                n = o.size();
                continue;
            }
            if (o.size() == n) continue;
            if (nValid < 20) {
                return true;
            }
            int nList = ((Object[])f.property("listCategories")).length;
            return nList * nList < nValid * 2;
        }
        return false;
    }

    private static boolean isYearly(Field asNumeric) {
        if (asNumeric.min() < 1600.0) {
            return false;
        }
        if (asNumeric.max() > 2100.0) {
            return false;
        }
        Double d = asNumeric.numProperty("granularity");
        return d != null && d - Math.floor(d) < 1.0E-6;
    }
}

