# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SearchSchemaValue(Model):
    """Value object for schema results.

    :param name: The name of the schema.
    :type name: str
    :param display_name: The display name of the schema.
    :type display_name: str
    :param type: The type.
    :type type: str
    :param indexed: The boolean that indicates the field is searchable as free
     text.
    :type indexed: bool
    :param stored: The boolean that indicates whether or not the field is
     stored.
    :type stored: bool
    :param facet: The boolean that indicates whether or not the field is a
     facet.
    :type facet: bool
    :param owner_type: The array of workflows containing the field.
    :type owner_type: list of str
    """

    _validation = {
        'indexed': {'required': True},
        'stored': {'required': True},
        'facet': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'indexed': {'key': 'indexed', 'type': 'bool'},
        'stored': {'key': 'stored', 'type': 'bool'},
        'facet': {'key': 'facet', 'type': 'bool'},
        'owner_type': {'key': 'ownerType', 'type': '[str]'},
    }

    def __init__(self, indexed, stored, facet, name=None, display_name=None, type=None, owner_type=None):
        self.name = name
        self.display_name = display_name
        self.type = type
        self.indexed = indexed
        self.stored = stored
        self.facet = facet
        self.owner_type = owner_type
