#coding:UTF-8
"""
What is :
   quick find Script

Description :
   快速查找内容脚本
   依赖https://www.voidtools.com/的everything

"""

from __future__ import print_function
import re,os,sys
from multiprocessing import *
from threading import Thread
freeze_support()
from concurrent import futures
import base64,zlib

esstr = zlib.decompress(base64.decodestring("""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"""))

if os.path.exists(r'es.exe') is False:
    with open(r'es.exe', 'wb') as f:
        f.write(esstr)

def PTask(task, key, iswarp = False):
    if os.path.exists(task):
        try:
            with open(task, 'r') as f:
                text = f.read()
                if len(re.findall(key, text)) != 0:
                    print(u'{}'.format(task))
        except:
            pass

    if iswarp: return None

def PTaskExcutor(taskgroup, key):
    with futures.ThreadPoolExecutor(max_workers=20) as executor:
        file_to_data = {executor.submit(PTask, info, key, True):None for info in taskgroup}

def main():
    if len(sys.argv) >= 3:
        filter = sys.argv[1]
        key = sys.argv[2]
    else:
        return

    cmd = 'es.exe -p ' + filter
    output = os.popen(cmd)
    lines = output.readlines()
    taskset = set()
    for line in lines:
        taskset.add(line.split('\n')[0])

    print(u'Task：{}'.format(len(taskset)))
    if 100 < len(taskset) and len(taskset) < 600:
        print(u'multi process')
        # p = Pool(cpu_count())
        # for index, task in enumerate(taskset):
        #     p.apply_async(func=PTask, args=(task, key) )
        # p.close()
        # p.join()
        PTaskExcutor(taskset, key)
    elif len(taskset) >= 600:
        print(u'multi process multi threading')
        cpu_numers = cpu_count()
        p = Pool(cpu_numers)
        taskgroup = [[] for _ in xrange(cpu_numers)]
        for index, task in enumerate(taskset):
            taskgroup[index%cpu_numers].append(task)

        for gt in taskgroup:
            p.apply_async(func=PTaskExcutor, args=(gt, key) )
        p.close()
        p.join()
    else:
        print(u'single process')
        for index, task in enumerate(taskset):
            PTask(task, key)

if __name__ == '__main__':
    import time
    b = time.clock()
    main()
    print(time.clock() - b)
