## Expected Command Line

- `pakit --install tmux ag`       -- Install several programs
- `pakit --update`                -- Update local programs
- `pakit --remove tmux`           -- Remove program
- `pakit --list`                  -- List installed programs
- `pakit --available`             -- List ALL available formula
- `pakit --search lib`            -- Display matching avilable recipes
- `pakit --conf ./a.yaml -i ag`   -- Override default config
- `pakit --display vim ag`        -- Display package information
- `pakit --relink`                -- Relink all programs

Short opts in order: -i -u -r -l -a -s -c -d

## Configuration

File config by a YAML file, default at `$HOME/.pakit.yml`.

```yaml
# Default options passed to all recipes self.opts, can be overwridden by specific opts.
defaults:
  repo: unstable
paths:
  # Where all builds will go, each under /tmp/pakit/builds/recipe.name folder
  prefix: /tmp/pakit/builds
  # Where builds will link to, should go on your PATH
  link: /tmp/pakit/links
  # Where source code will go
  source: /tmp/pakit/src
  # User can define a series of folders with recipes
  recipes:
    - path1
    - path2
log:
  enabled: true
  file: /tmp/pakit/main.log
# Example of specific options, for recipe in 'ag.py'
# Note that here ag will be built with 'stable' repo instead of default.
ag:
  repo: stable
  # These two options will be available in build/verify funcs via self.opts.
  option_1: hello
  option_2: world
```

## Recipe Specification

Work In Progress

Below is an example, taken from pakit_recipes/ag.py.
Core logic implemented in pakit/recipe.py
Aim is to have very short easily written recipes.

Parts of standard recipe:
- description: Short 1 line description. First non-empty line of __doc__.
- more_info: Long as you want. second non-empty line of __doc__ to end.
- homepage: Where people can get information on the project.
- repos: A dict of possible source downloaders.
- build(): A function that builds the source selectable by config.
- verify(): A function that uses `assert` statements to verify build.

Example:
```py
""" Formula for building ag """
from pakit import Git, Recipe


class Ag(Recipe):
    """ Grep like tool optimized for speed """
    def __init__(self):
        super(Ag, self).__init__()
        self.src = 'https://github.com/ggreer/the_silver_searcher'
        self.homepage = self.src
        self.repos = {
            'stable': Git(self.src, tag='0.30.0'),
            'unstable': Git(self.src),
        }

    def build(self):
        self.cmd('./build.sh --prefix {prefix}')
        self.cmd('make install')

    def verify(self):
        lines = self.cmd('{link}/bin/ag --version')
        assert lines[0].find('ag version') != -1
```

## Dependencies:

For first attempt, implement simple dependency on 'stable' repos only.
Recipe A depends on B & C, then InstallTasks would be (B C A) or (C B A).

In Recipes Constructor to depend on Git and Hg:
    self.requires = ['git', 'hg']

To determine order, will have to make a directed graph  based on requirements requested.
Then perform a topological sort to get a list of execution.
While Pakit single threaded can return a list of tasks to be iterated in order.

For multithreaded version, should make some queue like adapter for the DAG so that
can lock and pop off one task at a time when requirements met. Else idle the worker.
