/*=========================================================================
 *
 *  Copyright RTK Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/

#ifndef rtkForwardProjectionImageFilter_hxx
#define rtkForwardProjectionImageFilter_hxx

#include "rtkForwardProjectionImageFilter.h"

#include "rtkHomogeneousMatrix.h"

#include <itkImageRegionConstIterator.h>
#include <itkImageRegionIteratorWithIndex.h>
#include <itkIdentityTransform.h>

namespace rtk
{

template <class TInputImage, class  TOutputImage>
void
ForwardProjectionImageFilter<TInputImage,TOutputImage>
::GenerateInputRequestedRegion()
{
  // Input 0 is the stack of projections in which we project
  typename Superclass::InputImagePointer inputPtr0 =
    const_cast< TInputImage * >( this->GetInput(0) );
  if ( !inputPtr0 )
    return;
  inputPtr0->SetRequestedRegion( this->GetOutput()->GetRequestedRegion() );

  // Input 1 is the volume to forward project
  typename Superclass::InputImagePointer  inputPtr1 =
    const_cast< TInputImage * >( this->GetInput(1) );
  if ( !inputPtr1 )
    return;

  typename TInputImage::RegionType reqRegion = inputPtr1->GetLargestPossibleRegion();
  inputPtr1->SetRequestedRegion( reqRegion );

  // Input 2 is the attenuation map relative to the volume
  typename Superclass::InputImagePointer  inputPtr2 =
    const_cast< TInputImage * >( this->GetInput(2) );
  if ( !inputPtr2 )
    return;

  typename TInputImage::RegionType reqRegion2 = inputPtr2->GetLargestPossibleRegion();
  inputPtr2->SetRequestedRegion( reqRegion2 );
}

} // end namespace rtk

#endif
