import urllib.request, os
import time
from datetime import datetime, timedelta

def get_kma_images():

	altitudes = ["surfce", "gph300", "gph500", "gph700", "gph850", "gph925"]
	UTCtime = datetime.now() - timedelta(hours=8)

	for i in range(4):
		jpgtime = UTCtime - timedelta(hours=UTCtime.hour%12) - timedelta(hours=i*12)
		format = jpgtime.strftime('%Y%m%d%H')
		if not os.path.exists(os.getcwd() + "/" + format): 
			os.mkdir(os.getcwd() + "/" + format)
			
		for altitude in altitudes:
			new_image = os.getcwd() + "/" + format + "/" + format + "_" + altitude + ".png"
			if os.path.isfile(new_image):
				print(format[0:4], format[4:8], format[8:10] + "時", altitude, "已存在")
				continue
			try:
				urllib.request.urlretrieve("http://www.kma.go.kr/cht/swfd/glob/swfd_gdps_" + altitude + "_s000_" + format + ".png", new_image)
				print("取得", format[0:4], format[4:8], format[8:10] + "時", altitude)
			except:
				print(format[0:4], format[4:8], format[8:10] + "時", altitude, "尚未更新或已下架")
				continue
				
if __name__ == '__main__':
	get_kma_images()