/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ModelValidatorContext {
    private final StandardEvaluationContext spelContext;
    private SpELVariables spELVariables;

    public ModelValidatorContext(StandardEvaluationContext context) {
        this.spelContext = context;
    }

    public ModelValidatorContext(Task task) {
        LinkedHashMap<String, Serializable> taskVariablesValues = new LinkedHashMap<String, Serializable>();
        for (TaskVariable taskVariable : task.getVariables().values()) {
            taskVariablesValues.put(taskVariable.getName(), (Serializable)((Object)taskVariable.getValue()));
        }
        this.spELVariables = new SpELVariables(taskVariablesValues);
        this.spelContext = new StandardEvaluationContext((Object)this.spELVariables);
    }

    public ModelValidatorContext(TaskFlowJob job) {
        LinkedHashMap<String, Serializable> jobVariablesValues = new LinkedHashMap<String, Serializable>();
        for (JobVariable jobVariable : job.getVariables().values()) {
            jobVariablesValues.put(jobVariable.getName(), (Serializable)((Object)jobVariable.getValue()));
        }
        this.spELVariables = new SpELVariables(jobVariablesValues);
        this.spelContext = new StandardEvaluationContext((Object)this.spELVariables);
    }

    public StandardEvaluationContext getSpELContext() {
        return this.spelContext;
    }

    public SpELVariables getSpELVariables() {
        return this.spELVariables;
    }

    public void updateJobWithContext(TaskFlowJob job) {
        for (JobVariable jobVariable : job.getVariables().values()) {
            jobVariable.setValue(this.spELVariables.getVariables().get(jobVariable.getName()).toString());
        }
    }

    public void updateTaskWithContext(Task task) {
        for (TaskVariable taskVariable : task.getVariables().values()) {
            taskVariable.setValue(this.spELVariables.getVariables().get(taskVariable.getName()).toString());
        }
    }

    public class SpELVariables {
        private Map<String, Serializable> variables;

        public SpELVariables(Map<String, Serializable> variables) {
            this.variables = variables;
        }

        public Map<String, Serializable> getVariables() {
            return this.variables;
        }

        public void setVariables(Map<String, Serializable> variables) {
            this.variables = variables;
        }
    }
}

