'''
Created on 2017. 1. 24.

@author: Hye-Churn Jang
'''

import time
import gevent
import gevent.queue
import gevent.lock

#===============================================================================
# Processing Utils
#===============================================================================
class Time:
    
    @classmethod
    def sleep(cls, sec): gevent.sleep(sec)
    
class Queue(gevent.queue.Queue):
    
    def __init__(self, *argv, **kargs):
        gevent.queue.Queue.__init__(self, *argv, **kargs)

class Lock(gevent.lock.Semaphore):
    
    def __init__(self, *argv, **kargs):
        gevent.lock.Semaphore.__init__(self, *argv, **kargs)

#===============================================================================
# Thread
#===============================================================================

class Task:
    
    def __init__(self, tick=0, delay=0, debug=False):
        self._pygics_thread = None
        self._pygics_thread_sw = False
        self._pygics_thread_tick = tick
        self._pygics_thread_delay = delay
        self._pygics_thread_debug = debug
    
    def __thread_wrapper__(self):
        if self._pygics_thread_delay > 0: Time.sleep(self._pygics_thread_delay)
        while self._pygics_thread_sw:
            if self._pygics_thread_tick > 0:
                start_time = time.time()
                try: self.run()
                except Exception as e:
                    if self._pygics_thread_debug: print('[Error]Task:%s' % str(e))
                end_time = time.time()
                sleep_time = self._pygics_thread_tick - (end_time - start_time)
                if sleep_time > 0: Time.sleep(sleep_time)
                else:
                    if self._pygics_thread_debug: print('[Warning]Task:Processing Time Over Tick')
            else:
                try: self.run()
                except Exception as e:
                    if self._pygics_thread_debug: print('[Error]Task:%s' % str(e))
    
    def start(self):
        if self._pygics_thread == None:
            self._pygics_thread_sw = True
            self._pygics_thread = gevent.spawn(self.__thread_wrapper__)
        return self
    
    def stop(self):
        if self._pygics_thread != None:
            self._pygics_thread_sw = False
            gevent.kill(self._pygics_thread)
            gevent.joinall([self._pygics_thread])
            self._pygics_thread = None
        return self
        
    def run(self):
        pass

class Burst:
    
    def __init__(self, debug=False):
        self.methods = []
        self.args = []
        self.kargs = []
        self.length = 0
        self.debug = debug
        
    def register(self, method, *argv, **kargs):
        self.methods.append(method)
        self.args.append(argv)
        self.kargs.append(kargs)
        self.length += 1
        return self
    
    def __call__(self, method, *argv, **kargs):
        return self.register(method, *argv, **kargs)
    
    def do(self):
        fetches = []
        
        def fetch(__method__, *argv, **kargs):
            try: return __method__(*argv, **kargs)
            except Exception as e:
                if self.debug: print('[Error]Burst:%s' % str(e))
            return None
        
        for i in range(0, self.length):
            fetches.append(gevent.spawn(fetch, self.methods[i], *self.args[i], **self.kargs[i]))
        try: return [r.value for r in gevent.joinall(fetches)]
        except Exception as e:
            if self.debug: print('[Error]Burst:%s' % str(e))
            raise Exception('[Error]Burst:%s' % str(e))
