

windows_templates = {
    "start": """REM %(PROJECT_NAME)s Start script\n"""
             """cmd.exe /K "cd %(INSTALL_DIR)s\%(VENV_DIR)s\Scripts & call activate.bat & cd ..\..\%(INNER_PROJECT_NAME)s & python manage.py runserver 0.0.0.0:%(PORT)s\n""",

    "update": """REM %(PROJECT_NAME)s Update script\n"""
              """git pull\n"""
              """cd %(VENV_DIR)s/Scripts\n"""
              """call activate.bat\n"""
              """cd ../../%(INNER_PROJECT_NAME)s\n"""
              """python manage.py migrate\n"""
              """python manage.py compilemessages\n"""
}

unix_templates = {
    "start": """#!/bin/bash\n"""
             """# %(PROJECT_NAME)s Start script\n"""
             """cd %(INSTALL_DIR)s\n"""
             """. ./%(VENV_DIR)s/bin/activate\n"""
             """cd %(INNER_PROJECT_NAME)s\n"""
             """exec gunicorn --workers=3 -t 30 --log-level debug """
                   """--log-file %(INSTALL_DIR)s/log/server.log -b 0.0.0.0:%(PORT)s """
                   """--user=%(USERNAME)s --group=%(USERGROUP)s %(INNER_PROJECT_NAME)s.wsgi:application """
                   """>> %(INSTALL_DIR)s/log/gunicorn.log\n""",

    "update": """# %(PROJECT_NAME)s Update script\n"""
              """git pull\n"""
              """service gunicorn-%(PROJECT_NAME)s stop\n"""
              """. ./%(VENV_DIR)s/bin/activate\n"""
              """cd %(INNER_PROJECT_NAME)s\n"""
              """python manage.py migrate\n"""
              """python manage.py compilemessages\n"""
              """service gunicorn-%(PROJECT_NAME)s start\n""",

    "nginx_conf": """server {\n"""
                  """    listen         80;\n"""
                  """    server_name    %(DOMAIN)s;\n"""
                  """    root %(INSTALL_DIR)s/%(INNER_PROJECT_NAME)s;\n"""
                  """    location /media/ {\n"""
                  """    }\n"""
                  """    location /static/ {\n"""
                  """    }\n"""
                  """    location /robots.txt {\n"""
                  """        alias %(INSTALL_DIR)s/%(INNER_PROJECT_NAME)s/static/robots.txt;\n"""
                  """    }\n"""
                  """    ## Deny illegal Host headers\n"""
                  """    if ($host !~* ^(%(DOMAIN)s)$ ) {\n"""
                  """        return 444;\n"""
                  """    }\n"""
                  """    location / {\n"""
                  """        proxy_read_timeout      30s;\n"""
                  """        proxy_pass              http://127.0.0.1:%(PORT)s;\n"""
                  """        proxy_set_header        Host                 $host;\n"""
                  """        proxy_set_header        User-Agent           $http_user_agent;\n"""
                  """        proxy_set_header        X-Real-IP            $remote_addr;\n"""
                  """        #auth_basic 'Restricted';\n"""
                  """        #auth_basic_user_file %(INSTALL_DIR)s/%(INNER_PROJECT_NAME)s/.htpasswd;\n"""
                  """    }\n"""
                  """    error_page 500 502 503 504 /media/50x.html;\n"""
                  """}\n""",

    "upstart_job": """description 'start and stop the %(PROJECT_NAME)s server'\n"""
                   """start on runlevel [2345]\n"""
                   """stop on runlevel [!2345]\n"""
                   """respawn\n"""
                   """respawn limit 10 5\n"""
                   """exec %(INSTALL_DIR)s/start.sh\n"""
}