# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class VirtualMachineCaptureResult(SubResource):
    """Output of virtual machine capture operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource Id
    :type id: str
    :ivar schema: the schema of the captured virtual machine
    :vartype schema: str
    :ivar content_version: the version of the content
    :vartype content_version: str
    :ivar parameters: parameters of the captured virtual machine
    :vartype parameters: object
    :ivar resources: a list of resource items of the captured virtual machine
    :vartype resources: list[object]
    """

    _validation = {
        'schema': {'readonly': True},
        'content_version': {'readonly': True},
        'parameters': {'readonly': True},
        'resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'schema': {'key': '$schema', 'type': 'str'},
        'content_version': {'key': 'contentVersion', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'resources': {'key': 'resources', 'type': '[object]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineCaptureResult, self).__init__(**kwargs)
        self.schema = None
        self.content_version = None
        self.parameters = None
        self.resources = None
