// Generated by CoffeeScript 1.6.2
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  define(['jquery', 'reconnecting-websocket', 'app/view_model', 'knockout'], function($, ReconnectingWebSocket, MessagesViewModel, ko) {
    var PywizardUI;

    return PywizardUI = (function() {
      function PywizardUI(group_nodes) {
        this.group_nodes = group_nodes;
        this.on_ws_message = __bind(this.on_ws_message, this);
        this.on_ws_connect = __bind(this.on_ws_connect, this);
      }

      PywizardUI.prototype.run = function() {
        this.url = "ws://" + location.hostname + ":8888/io";
        this.ws = new ReconnectingWebSocket(this.url);
        this.ws.onopen = this.on_ws_connect;
        this.ws.onmessage = this.on_ws_message;
        this.viewModel = new MessagesViewModel(this.ws, this.group_nodes);
        ko.applyBindings(this.viewModel);
        return this.start_resize_listeners();
      };

      PywizardUI.prototype.on_ws_connect = function() {
        return $('#server-down-msg').hide();
      };

      PywizardUI.prototype.on_ws_message = function(evt) {
        var data;

        data = JSON.parse(evt.data);
        if ('host' in data) {
          return this.viewModel.get_node(data['host']).on_ws_message(data['msg']);
        }
      };

      PywizardUI.prototype.start_resize_listeners = function() {
        var resizeIt;

        resizeIt = function() {
          var height;

          height = $(window).height() - $('#header').height() - 160;
          return $('.messages').css('height', height);
        };
        resizeIt();
        return $(window).resize(resizeIt);
      };

      return PywizardUI;

    })();
  });

}).call(this);

/*
//@ sourceMappingURL=ui.map
*/
