# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StreamingPolicyWidevineConfiguration(Model):
    """Class to specify configurations of Widevine in Streaming Policy.

    :param custom_license_acquisition_url_template: Template for the URL of
     the custom service delivering licenses to end user players.  Not required
     when using Azure Media Services for issuing licenses.  The template
     supports replaceable tokens that the service will update at runtime with
     the value specific to the request.  The currently supported token values
     are {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is
     replaced with the value of identifier of the key being requested.
    :type custom_license_acquisition_url_template: str
    """

    _attribute_map = {
        'custom_license_acquisition_url_template': {'key': 'customLicenseAcquisitionUrlTemplate', 'type': 'str'},
    }

    def __init__(self, *, custom_license_acquisition_url_template: str=None, **kwargs) -> None:
        super(StreamingPolicyWidevineConfiguration, self).__init__(**kwargs)
        self.custom_license_acquisition_url_template = custom_license_acquisition_url_template
