# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PresentationTimeRange(Model):
    """The presentation time range, this is asset related and not recommended for
    Account Filter.

    :param start_timestamp: The absolute start time boundary.
    :type start_timestamp: long
    :param end_timestamp: The absolute end time boundary.
    :type end_timestamp: long
    :param presentation_window_duration: The relative to end sliding window.
    :type presentation_window_duration: long
    :param live_backoff_duration: The relative to end right edge.
    :type live_backoff_duration: long
    :param timescale: The time scale of time stamps.
    :type timescale: long
    :param force_end_timestamp: The indicator of forcing exsiting of end time
     stamp.
    :type force_end_timestamp: bool
    """

    _attribute_map = {
        'start_timestamp': {'key': 'startTimestamp', 'type': 'long'},
        'end_timestamp': {'key': 'endTimestamp', 'type': 'long'},
        'presentation_window_duration': {'key': 'presentationWindowDuration', 'type': 'long'},
        'live_backoff_duration': {'key': 'liveBackoffDuration', 'type': 'long'},
        'timescale': {'key': 'timescale', 'type': 'long'},
        'force_end_timestamp': {'key': 'forceEndTimestamp', 'type': 'bool'},
    }

    def __init__(self, *, start_timestamp: int=None, end_timestamp: int=None, presentation_window_duration: int=None, live_backoff_duration: int=None, timescale: int=None, force_end_timestamp: bool=None, **kwargs) -> None:
        super(PresentationTimeRange, self).__init__(**kwargs)
        self.start_timestamp = start_timestamp
        self.end_timestamp = end_timestamp
        self.presentation_window_duration = presentation_window_duration
        self.live_backoff_duration = live_backoff_duration
        self.timescale = timescale
        self.force_end_timestamp = force_end_timestamp
