/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps.projection;

import org.brunel.geom.Point;
import org.brunel.geom.Rect;
import org.brunel.maps.projection.Projection;

class WinkelTripel
extends Projection {
    WinkelTripel() {
    }

    @Override
    public String d3Definition(Rect bounds) {
        Rect ext = this.transform(bounds);
        double y = 0.0;
        double dy = 9.0E99;
        for (int i = -90; i < 90; ++i) {
            Point p = this.transform(new Point(bounds.cx(), i));
            double dp = Math.abs(p.y - ext.cy());
            if (!(dp < dy)) continue;
            dy = dp;
            y = i;
        }
        double x = 0.0;
        double dx = 9.0E99;
        for (int i = -180; i < 180; ++i) {
            Point p = this.transform(new Point(i, y));
            double dp = Math.abs(p.x - ext.cx());
            if (!(dp < dx)) continue;
            dx = dp;
            x = i;
        }
        String center = ".center([" + F.format(x) + ", " + F.format(y) + "])";
        return "winkel3()\n\t\t" + this.translateDefinition() + "\n\t\t" + this.scaleDefinition(ext) + "\n\t\t" + center;
    }

    @Override
    public Point transform(Point p) {
        double x = Math.toRadians(p.x);
        double y = Math.toRadians(p.y);
        double a = Math.acos(Math.cos(y) * Math.cos(x / 2.0));
        double sinca = Math.abs(a) < 1.0E-6 ? 1.0 : Math.sin(a) / a;
        return new Point(Math.cos(y) * Math.sin(x / 2.0) / sinca + x / Math.PI, (Math.sin(y) * sinca + y) / 2.0);
    }

    @Override
    public Point inverse(Point p) {
        throw new UnsupportedOperationException("Inverse not available for Winkel Triple");
    }
}

