/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.brunel.geom.Point;
import org.brunel.geom.Poly;
import org.brunel.geom.Rect;
import org.brunel.maps.GeoData;
import org.brunel.maps.GeoFile;
import org.brunel.maps.GeoFileGroup;
import org.brunel.maps.IndexedFeature;
import org.brunel.util.MappedLists;

public class GeoMapping {
    private final Map<Object, int[]> featureMap = new TreeMap<Object, int[]>();
    private final Set<Object> unmatched;
    final GeoFile[] files;
    private final MappedLists<GeoFile, Object> potential;
    private GeoFileGroup best;

    public static GeoMapping createGeoMapping(Poly polygon, List<GeoFile> required, GeoData geoAnalysis) {
        HashSet<Object> unmatched = new HashSet<Object>();
        MappedLists<GeoFile, Object> map = GeoMapping.mapBoundsToFiles(polygon, geoAnalysis.getGeoFiles());
        GeoMapping mapping = new GeoMapping(required, unmatched, map);
        return mapping.fileCount() > 0 ? mapping : null;
    }

    private static MappedLists<GeoFile, Object> mapBoundsToFiles(Poly poly, GeoFile[] geoFiles) {
        MappedLists<GeoFile, Object> map = new MappedLists<GeoFile, Object>();
        if (poly.count() == 0) {
            return map;
        }
        Rect bounds = poly.bounds;
        for (GeoFile f : geoFiles) {
            if (!bounds.intersects(f.bounds)) continue;
            for (Point p : poly.points) {
                if (!f.covers(p)) continue;
                map.add(f, p);
            }
        }
        return map;
    }

    static GeoMapping createGeoMapping(Object[] names, List<GeoFile> required, GeoData geoAnalysis) {
        HashSet<Object> unmatched = new HashSet<Object>();
        MappedLists<GeoFile, Object> map = geoAnalysis.mapFeaturesToFiles(names, unmatched);
        GeoMapping mapping = new GeoMapping(required, unmatched, map);
        mapping.buildFeatureMap();
        return mapping.fileCount() > 0 ? mapping : null;
    }

    public boolean isReference() {
        return this.featureMap.isEmpty();
    }

    private void buildFeatureMap() {
        for (int i = 0; i < this.files.length; ++i) {
            Object use = this.potential.get(this.files[i]);
            if (use == null) continue;
            Iterator i$ = use.iterator();
            while (i$.hasNext()) {
                Object o = i$.next();
                IndexedFeature s = (IndexedFeature)o;
                if (this.featureMap.containsKey(s.name)) continue;
                this.featureMap.put(s.name, new int[]{i, s.indexWithinFile});
            }
        }
    }

    private GeoMapping(List<GeoFile> required, Set<Object> unmatched, MappedLists<GeoFile, Object> potential) {
        this.potential = this.filter(potential, required);
        this.unmatched = unmatched;
        this.searchForBestSubset();
        if (required != null) {
            this.files = required.toArray(new GeoFile[required.size()]);
        } else {
            this.files = this.best.files.toArray(new GeoFile[this.best.files.size()]);
            Arrays.sort(this.files);
        }
    }

    public int fileCount() {
        return this.files.length;
    }

    public Map<Object, int[]> getFeatureMap() {
        return this.featureMap;
    }

    public String[] getFiles() {
        String[] strings = new String[this.files.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.files[i].name;
        }
        return strings;
    }

    public Set<Object> getUnmatched() {
        return this.unmatched;
    }

    public Rect totalBounds() {
        Rect bounds = null;
        for (GeoFile i : this.files) {
            bounds = Rect.union(i.bounds, bounds);
        }
        return bounds;
    }

    private MappedLists<GeoFile, Object> filter(MappedLists<GeoFile, Object> desired, List<GeoFile> required) {
        if (required == null || required.isEmpty()) {
            return desired;
        }
        MappedLists<GeoFile, Object> filtered = new MappedLists<GeoFile, Object>();
        for (Map.Entry e : desired.entrySet()) {
            if (!required.contains(e.getKey())) continue;
            filtered.addAll((GeoFile)e.getKey(), (List)e.getValue());
        }
        return filtered;
    }

    private void searchForBestAdditions(GeoFileGroup current, List<GeoFile> possibles) {
        if (current.isBetter(this.best)) {
            this.best = current;
        }
        if (possibles.isEmpty()) {
            return;
        }
        int maxImprovement = this.potential.get(possibles.get(0)).size();
        if (current.cannotImprove(this.best, maxImprovement)) {
            return;
        }
        LinkedList<GeoFile> working = new LinkedList<GeoFile>(possibles);
        while (!working.isEmpty()) {
            GeoFile k = working.removeFirst();
            GeoFileGroup trial = current.add(k);
            if (trial == null) continue;
            this.searchForBestAdditions(trial, working);
        }
    }

    private void searchForBestSubset() {
        this.best = GeoFileGroup.makeEmpty(this.potential);
        ArrayList<GeoFile> possibles = new ArrayList<GeoFile>(this.potential.keySet());
        Collections.sort(possibles, new Comparator<GeoFile>(){

            @Override
            public int compare(GeoFile a, GeoFile b) {
                return GeoMapping.this.potential.get(b).size() - GeoMapping.this.potential.get(a).size();
            }
        });
        this.searchForBestAdditions(this.best, possibles);
    }
}

