/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.util;

import org.brunel.data.Field;
import org.brunel.model.VisItem;
import org.brunel.model.VisSingle;
import org.brunel.model.style.StyleSheet;
import org.brunel.model.style.StyleTarget;

public class ModelUtil {
    private static final StyleTarget STYLE_TOP = new StyleTarget("svg", null, "brunel");
    private static final StyleTarget STYLE_ELEMENT = new StyleTarget(null, STYLE_TOP, "currentElement");

    public static boolean combinationIsCategorical(Field[] fields, boolean preferContinuous) {
        boolean allPreferCategorical = true;
        for (Field f : fields) {
            if (!f.preferCategorical()) {
                allPreferCategorical = false;
            }
            if (f.isNumeric()) continue;
            return true;
        }
        if (preferContinuous) {
            return false;
        }
        return allPreferCategorical;
    }

    public static Size getElementSize(VisSingle vis, String tag) {
        StyleTarget target = new StyleTarget(null, STYLE_ELEMENT, "element");
        String s = ModelUtil.getStyle(vis, target, tag);
        if (s == null) {
            if (tag.equals("size")) {
                return null;
            }
            return ModelUtil.getElementSize(vis, "size");
        }
        return ModelUtil.decompose(s);
    }

    public static String getElementSymbol(VisSingle vis) {
        StyleTarget target = new StyleTarget(null, STYLE_ELEMENT, "element", "point");
        return vis.styles == null ? null : vis.styles.get(target, "symbol");
    }

    public static Size getFontSize(VisSingle vis) {
        String s = ModelUtil.getStyle(vis, new StyleTarget("text", STYLE_ELEMENT, "element"), "font-size");
        return ModelUtil.decompose(s);
    }

    private static String getStyle(VisSingle vis, StyleTarget target, String key) {
        String result = vis.styles == null ? null : vis.styles.get(target, key);
        return result == null ? StyleSheet.getBrunelDefault(target, key) : result;
    }

    private static Size decompose(String s) {
        if (s == null) {
            return null;
        }
        s = s.trim();
        try {
            int pUnit;
            for (pUnit = s.length(); pUnit > 0 && "1234567890.".indexOf(s.charAt(pUnit - 1)) < 0; --pUnit) {
            }
            double v = Double.parseDouble(s.substring(0, pUnit));
            return new Size(v, s.substring(pUnit));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse style defined as: " + s, e);
        }
    }

    public static String getLabelPosition(VisSingle vis) {
        if (vis == null) {
            return null;
        }
        String s = ModelUtil.getStyle(vis, new StyleTarget(null, STYLE_ELEMENT, "element"), "label-location");
        if (s != null) {
            return s;
        }
        return ModelUtil.getStyle(vis, new StyleTarget(null, STYLE_ELEMENT, "label"), "label-location");
    }

    public static Size getAxisLabelFontSize(VisSingle vis) {
        String s = ModelUtil.getStyle(vis, new StyleTarget("text", STYLE_ELEMENT, "axis", "label"), "font-size");
        return ModelUtil.decompose(s);
    }

    public static Size getRoundRectangleRadius(VisSingle vis) {
        String s = ModelUtil.getStyle(vis, new StyleTarget("rect", STYLE_ELEMENT, "element", "point"), "border-radius");
        return ModelUtil.decompose(s);
    }

    public static boolean hasFilters(VisItem target) {
        if (target.children() == null) {
            return !target.getSingle().fFilter.isEmpty();
        }
        for (VisItem v : target.children()) {
            if (!ModelUtil.hasFilters(v)) continue;
            return true;
        }
        return false;
    }

    private static String[] splitByUnit(String text) {
        if (text == null) {
            return new String[]{"12", "px"};
        }
        int p = text.length();
        while (p > 0 && !Character.isDigit(text.charAt(--p))) {
        }
        if (p == text.length() - 1) {
            return new String[]{text, "px"};
        }
        return new String[]{text.substring(0, p + 1), text.substring(p + 1)};
    }

    public static final class Size {
        private static final int DPI = 96;
        private final double value;
        private final String unit;

        public Size(double value, String unit) {
            this.value = value;
            this.unit = unit.isEmpty() ? "px" : unit;
        }

        public String suffix() {
            return this.isPercent() ? this.unit : "px";
        }

        public boolean isPercent() {
            return this.unit.equals("%");
        }

        public String toString() {
            return this.value + this.unit;
        }

        public double valueInPixels(double percentSize100) {
            return this.isPercent() ? this.value() * percentSize100 : this.value;
        }

        public double value() {
            if (this.isPercent()) {
                return this.value / 100.0;
            }
            if (this.unit.equals("px")) {
                return this.value;
            }
            if (this.unit.equals("mm")) {
                return this.value * 96.0 / 25.4;
            }
            if (this.unit.equals("cm")) {
                return this.value * 96.0 / 2.54;
            }
            if (this.unit.equals("in")) {
                return this.value * 96.0;
            }
            if (this.unit.equals("pt")) {
                return this.value * 96.0 / 72.0;
            }
            if (this.unit.equals("pc")) {
                return this.value * 96.0 / 6.0;
            }
            throw new IllegalStateException("Unknown unit: " + this.unit);
        }
    }
}

