/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.element;

import org.brunel.build.chart.ChartStructure;
import org.brunel.build.d3.D3Util;
import org.brunel.build.element.ElementDefinition;
import org.brunel.build.element.ElementDetails;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.maps.GeoMapping;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class ElementStructure {
    public final ChartStructure chart;
    public final int index;
    public final VisSingle vis;
    public final Dataset original;
    public final Dataset data;
    public final GeoMapping geo;
    public final boolean dependent;
    public ElementDefinition definition;
    public ElementDetails details;

    public ElementStructure(ChartStructure chartStructure, int elementIndex, VisSingle vis, Dataset data, GeoMapping geo, boolean dependent) {
        this.chart = chartStructure;
        this.index = elementIndex;
        this.vis = vis;
        this.data = data;
        this.geo = geo;
        this.dependent = dependent;
        this.original = vis.getDataset();
    }

    public int getBaseDatasetIndex() {
        return this.chart.getBaseDatasetIndex(this.original);
    }

    public String elementID() {
        return "" + (this.index + 1);
    }

    public boolean isGraphEdge() {
        return !(this.chart.diagram != VisTypes.Diagram.network && this.chart.diagram != VisTypes.Diagram.tree || this.vis.tElement != VisTypes.Element.edge || this.vis.fKeys.size() != 2 && this.vis.positionFields().length != 2);
    }

    public String keyedLocation(String dimName, Field key) {
        String idToPointName = "elements[" + this.chart.sourceIndex + "].internal()._idToPoint(";
        return idToPointName + D3Util.writeCall(key) + ")." + dimName;
    }

    public String referredLocation(Field key) {
        String idToPointName = "elements[" + this.chart.sourceIndex + "].internal()._idToPoint(";
        return idToPointName + D3Util.writeCall(key) + ")";
    }
}

