/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.element.ElementDefinition;
import org.brunel.build.element.ElementDetails;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

class Tree
extends D3Diagram {
    private final int pad;

    public Tree(VisSingle vis, Dataset data, ScriptWriter out) {
        super(vis, data, out);
        this.pad = 10;
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.comment("Define tree (hierarchy) data structures");
        this.makeHierarchicalTree();
        this.out.add("var treeLayout = d3.layout.tree()").addChained("sort(BrunelData.diagram_Hierarchical.compare)");
        if (this.vis.coords == VisTypes.Coordinates.polar) {
            this.out.addChained("size([360, geom.inner_radius-" + this.pad + "])");
        } else {
            this.out.addChained("size([geom.inner_width-" + 2 * this.pad + ", geom.inner_height-" + 2 * this.pad + "])");
        }
        this.out.endStatement();
        this.out.add("function keyFunction(d) { return d.key }").endStatement();
        if (this.vis.coords != VisTypes.Coordinates.polar) {
            this.out.add("elementGroup.attr('transform', 'translate(" + this.pad + ", " + this.pad + ")')").endStatement();
        }
        return ElementDetails.makeForDiagram(this.vis, "treeLayout(tree.root)", "circle", "point", "box", false);
    }

    @Override
    public void writeDefinition(ElementDetails details, ElementDefinition elementDef) {
        this.out.addChained("attr('class', function(d) { return (d.children ? 'L' + d.depth : 'leaf element " + this.element.name() + "') })");
        if (this.vis.coords == VisTypes.Coordinates.polar) {
            this.out.addChained("attr('transform', function(d) { return 'rotate(' + (d.x - 90) + ') translate(' + d.y + ')' })");
        } else {
            this.out.addChained("attr('cx', function(d) { return d.x })").addChained("attr('cy', function(d) { return d.y })");
        }
        this.out.addChained("attr('r', " + D3Util.defineSafeRadius(elementDef.overallSize) + ")").endStatement();
        this.addAestheticsAndTooltips(details, true);
        this.out.onNewLine().ln().comment("Add in the arcs on the outside for the groups");
        this.out.add("diagramExtras.attr('class', 'diagram tree edge')").endStatement();
        this.out.add("var edgeGroup = diagramExtras.selectAll('path').data(treeLayout.links(d3Data))").endStatement();
        this.out.add("edgeGroup.enter().append('path').attr('class', 'edge')").endStatement();
        this.out.add("BrunelD3.trans(edgeGroup,transitionMillis)").addChained("attr('d', d3.svg.diagonal");
        if (this.vis.coords == VisTypes.Coordinates.polar) {
            this.out.add(".radial().projection(function(d) { return [d.y, d.x / 180 * Math.PI] }))");
        } else {
            this.out.add("())");
        }
        this.out.endStatement();
        this.addAestheticsAndTooltips(details, true);
    }

    @Override
    public boolean needsDiagramExtras() {
        return true;
    }

    @Override
    public boolean needsDiagramLabels() {
        return true;
    }
}

