/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build;

import org.brunel.build.Builder;
import org.brunel.build.chart.ChartLayout;
import org.brunel.build.chart.ChartStructure;
import org.brunel.build.controls.Controls;
import org.brunel.build.data.DataBuilder;
import org.brunel.build.data.DataModifier;
import org.brunel.build.element.ElementStructure;
import org.brunel.build.util.BuilderOptions;
import org.brunel.data.Dataset;
import org.brunel.model.VisComposition;
import org.brunel.model.VisException;
import org.brunel.model.VisItem;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;
import org.brunel.model.style.StyleSheet;

public abstract class AbstractBuilder
implements Builder,
DataModifier {
    protected final BuilderOptions options;
    protected Controls controls;
    private StyleSheet visStyles;
    private Dataset[] datasets;

    public AbstractBuilder(BuilderOptions options) {
        this.options = options;
    }

    @Override
    public final void build(VisItem main, int width, int height) {
        this.visStyles = new StyleSheet();
        this.controls = new Controls(this.options);
        this.datasets = main.getDataSets();
        this.defineVisSystem(main, width, height);
        if (main.children() == null) {
            this.buildTiledCharts(width, height, new VisItem[]{main.getSingle()});
        } else {
            VisTypes.Composition compositionMethod = ((VisComposition)main).method;
            if (compositionMethod == VisTypes.Composition.tile) {
                this.buildTiledCharts(width, height, main.children());
            } else if (compositionMethod == VisTypes.Composition.overlay) {
                double[] loc = new ChartLayout(width, height, main).getLocation(0);
                this.buildSingleChart(0, main.children(), loc);
            } else if (compositionMethod == VisTypes.Composition.inside || compositionMethod == VisTypes.Composition.nested) {
                this.buildTiledCharts(width, height, new VisItem[]{main.getSingle()});
            }
        }
        this.endVisSystem(main);
    }

    @Override
    public final BuilderOptions getOptions() {
        return this.options;
    }

    @Override
    public String getStyleOverrides() {
        return this.visStyles.toString("#" + this.options.visIdentifier + ".brunel");
    }

    public abstract String makeImports();

    protected abstract void defineChart(ChartStructure var1, double[] var2);

    protected abstract void defineElement(ElementStructure var1);

    protected abstract void defineVisSystem(VisItem var1, int var2, int var3);

    protected abstract void endChart(ChartStructure var1);

    protected abstract void endVisSystem(VisItem var1);

    private void buildElement(ElementStructure structure) {
        try {
            this.controls.buildControls(structure.vis, structure.vis.getDataset());
            this.defineElement(structure);
            if (structure.vis.styles != null) {
                StyleSheet styles = structure.vis.styles.replaceClass("currentElement", "element" + structure.elementID());
                this.visStyles.add(styles, "chart" + structure.chart.chartID());
            }
        }
        catch (Exception e) {
            throw VisException.makeBuilding(e, structure.vis);
        }
    }

    private void buildSingleChart(int chartIndex, VisItem[] items, double[] loc) {
        Dataset[] data = new Dataset[items.length];
        VisSingle[] elements = new VisSingle[items.length];
        for (int i = 0; i < items.length; ++i) {
            elements[i] = items[i].getSingle().resolve();
            data[i] = new DataBuilder(elements[i], this).build();
        }
        ChartStructure structure = new ChartStructure(chartIndex, elements, data, this.datasets);
        this.defineChart(structure, loc);
        for (ElementStructure e : structure.elementStructure) {
            this.buildElement(e);
        }
        this.endChart(structure);
    }

    private void buildTiledCharts(int width, int height, VisItem[] charts) {
        ChartLayout layout = new ChartLayout(width, height, charts);
        for (int i = 0; i < charts.length; ++i) {
            VisItem chart = charts[i];
            double[] loc = layout.getLocation(i);
            VisItem[] items = chart.children();
            if (items == null) {
                this.buildSingleChart(i, new VisItem[]{chart}, loc);
                continue;
            }
            this.buildSingleChart(i, items, loc);
        }
    }
}

