#!/usr/bin/env python
from setuptools import setup
import platform

system = platform.system()
if system == 'Linux':
    cmd = 'yum install -y python-devel libffi libffi-devel'
    import commands
    commands.getstatusoutput(cmd)
    print cmd

setup(
    name='agileutil',
    version='4.6',
    description='python lib',
    author='lyc',
    license='MIT',
    platforms = "any",
    install_requires=[
        'cryptography==2.0.0',
        'python-decouple>=3.1',
        'PyMySQL>=0.7.11', 
        'redis>=2.10.6', 
        'requests>=2.12.1', 
        'web.py>=0.38',
        'demjson>=2.2.4', 
        'pexpect>=4.3.0', 
        'fabric>=1.14.0', 
        'IPy>=0.83', 
        'ansible==1.9.1',
        'tqdm>=4.19.4', 
        'paramiko>=2.3.1',
        'pika>=0.10.0',
        'gevent==1.1',
        'gunicorn>=19.6.0',
        'phpserialize',
        'pymongo'
    ],
    classifiers=[
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
    ],
    keywords='agileutil',
    packages=['agileutil'],
    include_package_data=True
)
