from sqlalchemy import Column, String, Integer, DATE, ForeignKey
from ETRMDatabase.base import Base


class TradeHeader(Base):

    __tablename__ = 'trade_header'
    __table_args__ = {'schema': 'trade'}

    id = Column(Integer, primary_key=True)
    trade_date = Column(DATE)
    start_date = Column(DATE)
    end_date = Column(DATE)
    trader_id = Column(String(25), ForeignKey('trade.dim_trader.trader_id'))
    broker_id = Column(Integer, ForeignKey('trade.dim_broker.id'))
    from_counter_party_id = Column(Integer, ForeignKey('trade.dim_counter_party.id'))
    to_counter_party_id = Column(Integer, ForeignKey('trade.dim_counter_party.id'))
    deal_type_id = Column(Integer, ForeignKey('trade.dim_deal_type.id'))
    delivery_type_id = Column(Integer, ForeignKey('trade.dim_delivery_type.id'))
    pricing_style_id = Column(Integer, ForeignKey('power.dim_pricing_style.id'))
    frequency_id = Column(Integer, ForeignKey('power.dim_frequency.id'))
    volume_type_id = Column(Integer,ForeignKey('trade.dim_volume_type.id'))
    notes = Column(String(250))

    def __int__(self, trade_date, start_date, end_date, trader_id, broker_id, from_counter_party_id,
                to_counter_party_id, deal_type_id, delivery_type_id,pricing_style_id,
                frequency_id, volume_type_id, notes):
        self.trade_date = trade_date
        self.start_date = start_date
        self.end_date = end_date
        self.trader_id = trader_id
        self.broker_id = broker_id
        self.from_counter_party_id = from_counter_party_id
        self.to_counter_party_id = to_counter_party_id
        self.deal_type_id = deal_type_id
        self.delivery_type_id = delivery_type_id
        self.pricing_style_id = pricing_style_id
        self.frequency_id = frequency_id
        self.volume_type_id = volume_type_id
        self.notes=notes



